/*
 * PanelPodstawowy.java
 *
 * Created on 26 kwiecie 2004, 15:31
 */

package firma;

import javax.swing.*;
import java.awt.*;

/**
 * Implementacja widoku panelu funkcjonalnoci dostpnego
 * po zalogowaniu si firmy. Jest doczany w aplecie {@link KonsolaFirmy}.
 *
 * @author  ek197882
 */
public class PanelPodstawowy extends javax.swing.JPanel {
    
    /**
     * Konsola firmy, na ktorej panel jest wywietlony.
     */
    KonsolaFirmy konsolaFirmy;
    
    /**
     * Konstruktor.
     *
     * @param kons konsola firmy, do ktrej przyczony jest widok
     */
    public PanelPodstawowy(KonsolaFirmy kons) {
        konsolaFirmy = kons;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        edycjaOglButton = new javax.swing.JButton();
        usunOglButton = new javax.swing.JButton();
        statButton = new javax.swing.JButton();
        zmianaHaslaKontoButton = new javax.swing.JButton();
        statusButton = new javax.swing.JButton();
        vCardButton = new javax.swing.JButton();
        wylogujButton = new javax.swing.JButton();

        setLayout(new java.awt.GridLayout(7, 1));

        edycjaOglButton.setText("Edycja ogloszenia");
        edycjaOglButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                edycjaOglButtonActionPerformed(evt);
            }
        });

        add(edycjaOglButton);

        usunOglButton.setText("Usuwanie og\u0142oszenia");
        usunOglButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                usunOglButtonActionPerformed(evt);
            }
        });

        add(usunOglButton);

        statButton.setText("Statystyki");
        statButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                statButtonActionPerformed(evt);
            }
        });

        add(statButton);

        zmianaHaslaKontoButton.setText("Zmiana has\u0142a");
        zmianaHaslaKontoButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zmianaHaslaKontoButtonActionPerformed(evt);
            }
        });

        add(zmianaHaslaKontoButton);

        statusButton.setText("Status og\u0142oszenia");
        statusButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                statusButtonActionPerformed(evt);
            }
        });

        add(statusButton);

        vCardButton.setText("VCard");
        vCardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                vCardButtonActionPerformed(evt);
            }
        });

        add(vCardButton);

        wylogujButton.setText("Wylogowanie");
        wylogujButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wylogujButtonActionPerformed(evt);
            }
        });

        add(wylogujButton);

    }//GEN-END:initComponents
    
    private void vCardButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_vCardButtonActionPerformed
        try {
            String tel = null;
            if (konsolaFirmy.telefony != null)  {
                try {
                    java.util.ArrayList l = (java.util.ArrayList)konsolaFirmy.telefony.get(0);
                    tel = (String)l.get(0);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            konsolaFirmy.komSieciowa.kontaFirm.generujWizytowke(konsolaFirmy.ogl, tel);
            String adresWizytowki =  konsolaFirmy.komSieciowa.kontaFirm.adresWizytowki(konsolaFirmy.ogl.getId());
            konsolaFirmy.getAppletContext().showDocument(new java.net.URL(adresWizytowki), "_blank");
        } catch (Exception e) {
            e.printStackTrace();
        }
        
    }//GEN-LAST:event_vCardButtonActionPerformed
    
    private void statusButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statusButtonActionPerformed
        konsolaFirmy.pokazEkranStatusu();
    }//GEN-LAST:event_statusButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Wyloguj".
     * Informuje konsol firmy, e firma jest wylogowana.
     *
     * @see KonsolaFirmy
     */
    private void wylogujButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wylogujButtonActionPerformed
        konsolaFirmy.firmaWylogowana();
        konsolaFirmy.pokazEkranLogowania();
    }//GEN-LAST:event_wylogujButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Zmie haso".
     * Informuje konsol, e zadano zmiany hasa.
     *
     * @see KonsolaFirmy
     */
    private void zmianaHaslaKontoButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zmianaHaslaKontoButtonActionPerformed
        konsolaFirmy.pokazEkranZmianyHasla();
    }//GEN-LAST:event_zmianaHaslaKontoButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Statystyki".
     * Informuje konsol, e zadano ogldania statystyk.
     *
     *@see KonsolaFirmy
     */
    private void statButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statButtonActionPerformed
        konsolaFirmy.pokazEkranStatystyk();
    }//GEN-LAST:event_statButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Usu ogoszenie".
     * Wywietla pytanie o potwierdzenie usunicia ogoszenia i - jeli nastpio -
     * zleca przez konsol firmy usunicie ogoszenia.
     *
     * @see KonsolaFirmy
     */
    private void usunOglButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_usunOglButtonActionPerformed
        Object[] options = { "Nie, jeszcze to przemy\u015bl\u0119", "Tak, na 100 %" };
        int r = JOptionPane.showOptionDialog(this,
        "Czy na pewno chcesz usun\u0105\u0107 og\u0142oszenie i konto firmy?",
        "Jeste\u015b pewien?", JOptionPane.DEFAULT_OPTION,
        JOptionPane.OK_CANCEL_OPTION, null, options, options[0]);
        if ((r == 0) || (r == JOptionPane.CLOSED_OPTION)) {
            /* nic nie robimy */
        } else {
            try {
                konsolaFirmy.komSieciowa.kontaFirm.usunLogo(konsolaFirmy.ogl.getId());
                konsolaFirmy.komSieciowa.ogloszenia.usunOgloszenie(konsolaFirmy.ogl);
                JOptionPane.showMessageDialog(this, "Og\u0142oszenie usuni\u0119to.",
                "Informacja", JOptionPane.INFORMATION_MESSAGE);
                konsolaFirmy.firmaWylogowana();
                konsolaFirmy.pokazEkranLogowania();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }//GEN-LAST:event_usunOglButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Edycja ogoszenia".
     * Przekazanie dania edycji do konsoli.
     *
     * @see KonsolaFirmy
     */
    private void edycjaOglButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_edycjaOglButtonActionPerformed
        konsolaFirmy.pokazEkranEdycjiOgloszenia();
    }//GEN-LAST:event_edycjaOglButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton edycjaOglButton;
    private javax.swing.JButton statButton;
    private javax.swing.JButton statusButton;
    private javax.swing.JButton usunOglButton;
    private javax.swing.JButton vCardButton;
    private javax.swing.JButton wylogujButton;
    private javax.swing.JButton zmianaHaslaKontoButton;
    // End of variables declaration//GEN-END:variables
    
}
