/*
 * WidokLogowania.java
 *
 * Created on 25 kwiecie 2004, 19:08
 */

package firma;

import shared.*;
import javax.swing.*;
import java.awt.*;
import java.rmi.RemoteException;
import komponenty.JPasswordFieldPolski;

/**
 * Wywietla ekran logowania firmy. Implementuje wszystkie funkcjonalnoci
 * dostpne bez autoryzacji firmy oraz autoryzacj.
 *
 * @author  ek197882
 */
public class WidokLogowania extends javax.swing.JPanel {
    
    /**
     * Konsola firmy, na ktrej zostal wywietlony panel.
     */
    KonsolaFirmy konsolaFirmy;
    
    /**
     * Konstruktor.
     *
     * @param kons konsola firmy, do ktrej przyczony jest widok
     */
    public WidokLogowania(KonsolaFirmy kons) {
        konsolaFirmy = kons;
        initComponents();
        hasloText = new komponenty.JPasswordFieldPolski();
        add(hasloText);
        hasloText.setBounds(220, 70, 160, 19);
        
        linkButton.setText("<html><a href=" + adresCennika() + ">" + adresCennika() + "</a></html>");
    }
    
    /**
     * Generuje adres cennika.
     *
     * @return Adres cennika, sformatowany: http://serwer/na/ktorym/uruchomiono/niikta/cennik.html
     */
    public String adresCennika() {
        return konsolaFirmy.getCodeBase().toString() + "cennik.html";
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        nipText = new javax.swing.JTextField();
        zalogujButton = new javax.swing.JButton();
        nipLabel = new javax.swing.JLabel();
        hasloLabel = new javax.swing.JLabel();
        zapomButton = new javax.swing.JButton();
        zalozButton = new javax.swing.JButton();
        zarejLabel = new javax.swing.JFormattedTextField();
        nowaLabel = new javax.swing.JFormattedTextField();
        nowaSeparator = new javax.swing.JSeparator();
        obejrzyjLabel = new javax.swing.JLabel();
        linkButton = new javax.swing.JButton();

        setLayout(null);

        setPreferredSize(new java.awt.Dimension(100, 100));
        add(nipText);
        nipText.setBounds(220, 40, 160, 20);

        zalogujButton.setText("Zaloguj");
        zalogujButton.setPreferredSize(new java.awt.Dimension(147, 25));
        zalogujButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zalogujButtonActionPerformed(evt);
            }
        });

        add(zalogujButton);
        zalogujButton.setBounds(220, 100, 160, 50);

        nipLabel.setText("NIP");
        add(nipLabel);
        nipLabel.setBounds(50, 40, 30, 20);

        hasloLabel.setText("Has\u0142o");
        add(hasloLabel);
        hasloLabel.setBounds(50, 70, 70, 20);

        zapomButton.setText("Przypomnij has\u0142o");
        zapomButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zapomButtonActionPerformed(evt);
            }
        });

        add(zapomButton);
        zapomButton.setBounds(220, 160, 160, 50);

        zalozButton.setText("Za\u0142\u00f3\u017c nowe konto");
        zalozButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zalozButtonActionPerformed(evt);
            }
        });

        add(zalozButton);
        zalozButton.setBounds(220, 230, 160, 50);

        zarejLabel.setBackground(new java.awt.Color(102, 102, 255));
        zarejLabel.setBorder(null);
        zarejLabel.setEditable(false);
        zarejLabel.setText("  Zarejestrowana firma");
        zarejLabel.setFocusable(false);
        zarejLabel.setFont(new java.awt.Font("Dialog", 1, 12));
        add(zarejLabel);
        zarejLabel.setBounds(50, 10, 150, 20);

        nowaLabel.setBackground(new java.awt.Color(102, 102, 255));
        nowaLabel.setBorder(null);
        nowaLabel.setEditable(false);
        nowaLabel.setText("  Nowa firma");
        nowaLabel.setFocusable(false);
        nowaLabel.setFont(new java.awt.Font("Dialog", 1, 12));
        add(nowaLabel);
        nowaLabel.setBounds(50, 240, 150, 20);

        add(nowaSeparator);
        nowaSeparator.setBounds(50, 220, 330, 10);

        obejrzyjLabel.setText("Obejrzyj nasz cennik:");
        add(obejrzyjLabel);
        obejrzyjLabel.setBounds(50, 300, 133, 15);

        linkButton.setBorder(null);
        linkButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        linkButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                linkButtonActionPerformed(evt);
            }
        });

        add(linkButton);
        linkButton.setBounds(70, 320, 450, 25);

    }//GEN-END:initComponents

    /** Otwiera cennik w nowym oknie przegldarki. */
    private void linkButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_linkButtonActionPerformed
        try {
            konsolaFirmy.getAppletContext().showDocument(new java.net.URL(adresCennika()), "_blank");
        } catch(Exception e) {}
    }//GEN-LAST:event_linkButtonActionPerformed
    
    /**
     * Akcja wykonywaja po naciniciu guzika "Przypomnij haso".
     * Zleca poprzez konsol firmy i jej komunikacj sieciow logice na serwerze wysanie maila.
     *
     * @see KonsolaFirmy
     * @see KomSieciowa
     */
    private void zapomButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zapomButtonActionPerformed
        String nip = nipText.getText();
        if ((nip == null) || (nip.length() == 0)) {
            JOptionPane.showMessageDialog(this, "Nie zapomnij wpisa\u0107 numeru NIP.",
            "Uwaga!", JOptionPane.WARNING_MESSAGE);
        } else
            try {
                konsolaFirmy.komSieciowa.kontaFirm.przypomnijHaslo(new Nip(nip));
                JOptionPane.showMessageDialog(this, "E-mail wys\u0142ano.", "Informacja", JOptionPane.INFORMATION_MESSAGE);
            } catch (Wyjatek w) {
                JOptionPane.showMessageDialog(this, "Nie uda\u0142o si\u0119 wysa\u0107 e-maila.\n" +
                "Upewnij si\u0119, \u017ce numer NIP jest poprawny.", "B\u0142\u0105!", JOptionPane.ERROR_MESSAGE);
            } catch (RemoteException re) {
                re.printStackTrace();
            }
    }//GEN-LAST:event_zapomButtonActionPerformed
    
    /**
     * Akcja wykonywana po naciniciu guzika "Nowe konto".
     * Przekazuje danie zaoenia nowego konta do konsoliFirmy.
     *
     * @see KonsolaFirmy
     */
    private void zalozButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zalozButtonActionPerformed
        konsolaFirmy.pokazEkranNowegoOgloszenia();
    }//GEN-LAST:event_zalozButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Loguj".
     * Zleca danie serwerowi poprzez konsol firmy i jej komSieciow.
     *
     * @see KonsolaFirmy
     * @see KomSieciowa
     */
    private void zalogujButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zalogujButtonActionPerformed
        String nip = nipText.getText();
        String haslo = hasloText.getPasswordString();
        
        Ogloszenie ogl = null;
        try {
            ogl = konsolaFirmy.komSieciowa.kontaFirm.autoryzacja(new Nip(nip), haslo);
        } catch (Wyjatek e) {
            ogl = null;
        } catch (RemoteException re) {
            ogl = null;
            re.printStackTrace();
        }
        if (ogl == null) {
            JOptionPane.showMessageDialog(this, "Logowanie nie powiod\u0142o si\u0119.\n" +
            "Upewnij si\u0119, \u017ce NIP i has\u0142o zosta\u0142y wprowadzone poprawnie.",
            "B\u0142\u0105d!", JOptionPane.ERROR_MESSAGE);
        } else {
            konsolaFirmy.firmaZalogowana(ogl);
        }
    }//GEN-LAST:event_zalogujButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel hasloLabel;
    private javax.swing.JButton linkButton;
    private javax.swing.JLabel nipLabel;
    private javax.swing.JTextField nipText;
    private javax.swing.JFormattedTextField nowaLabel;
    private javax.swing.JSeparator nowaSeparator;
    private javax.swing.JLabel obejrzyjLabel;
    private javax.swing.JButton zalogujButton;
    private javax.swing.JButton zalozButton;
    private javax.swing.JButton zapomButton;
    private javax.swing.JFormattedTextField zarejLabel;
    // End of variables declaration//GEN-END:variables
    private komponenty.JPasswordFieldPolski hasloText;
    
}
