/*
 * WidokNowegoOgloszenia.java
 *
 * Created on 27 kwiecie 2004, 00:56
 */

package firma;

import java.rmi.RemoteException;
import javax.swing.*;
import java.awt.*;
import java.util.Iterator;
import shared.*;


/**
 * Wywietla widok, ktry umoliwia wstawienie nowego ogoszenia do bazy.
 *
 * @author  ek197882
 */
public class WidokNowegoOgloszenia extends javax.swing.JPanel {
    
    /**
     * Konsola firmy, na ktorej jest wyswietlony panel.
     */
    KonsolaFirmy konsolaFirmy;
    
    /**
     * Konstruktor.
     *
     * @param kons konsola firmy, do ktrej przyczony jest widok
     */
    public WidokNowegoOgloszenia(KonsolaFirmy kons) {
        konsolaFirmy = kons;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        noweOgloszenieLabel = new javax.swing.JFormattedTextField();
        wyslijButton = new javax.swing.JButton();
        anulujButton = new javax.swing.JButton();

        setLayout(new java.awt.GridLayout(1, 2));

        noweOgloszenieLabel.setBackground(new java.awt.Color(153, 153, 255));
        noweOgloszenieLabel.setBorder(null);
        noweOgloszenieLabel.setEditable(false);
        noweOgloszenieLabel.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        noweOgloszenieLabel.setText("Nowe og\u0142oszenie");
        noweOgloszenieLabel.setFocusable(false);
        noweOgloszenieLabel.setFont(new java.awt.Font("Dialog", 1, 12));
        add(noweOgloszenieLabel);

        wyslijButton.setBackground(new java.awt.Color(153, 153, 255));
        wyslijButton.setText("Wy\u015blij");
        wyslijButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wyslijButtonActionPerformed(evt);
            }
        });

        add(wyslijButton);

        anulujButton.setBackground(new java.awt.Color(153, 153, 255));
        anulujButton.setText("Anuluj");
        anulujButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                anulujButtonActionPerformed(evt);
            }
        });

        add(anulujButton);

    }//GEN-END:initComponents
    
    /**
     * Akcja wykonywana po wciniciu guzika "Anuluj".
     * Przekazuje danie anulowania do konsoli firmy.
     *
     * @param evt Zdarzenie wcinicie guzika "Anuluj"
     */
    private void anulujButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_anulujButtonActionPerformed
        konsolaFirmy.usunWidokOgloszenia();
    }//GEN-LAST:event_anulujButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Wyslij".
     * Przesya ogoszenie na serwer za porednictwem konsoli firmy.
     *
     * @param evt Zdarzenie nacinici guzika "Wylij"
     * @see KonsolaFirmy
     */
    private void wyslijButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wyslijButtonActionPerformed
        WidokOgloszenia wo = (WidokOgloszenia)konsolaFirmy.oframe.getContentPane().getComponent(0);
        wo.konstruujOgloszenie();
        if (konsolaFirmy.konstrOgl != null) {
            try {
                /* logo */
                PlikGraficzny pg = null;
                if (konsolaFirmy.pg != null) {
                    try {
                        pg = konsolaFirmy.pg;
                        //konsolaFirmy.komSieciowa.kontaFirm.zapiszLogoFirmy(konsolaFirmy.ogl.getId(), pg);
                    } catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Nie uda\u0142o si\u0119 wczyta\u0107 pliku logo.",
                        "B\u0142\u0105d!", JOptionPane.ERROR_MESSAGE);
                    }
                }
                /* ogloszenie */
                String errmsg;
                if (pg != null)
                    errmsg = konsolaFirmy.komSieciowa.kontaFirm.utworzKontoZLogo(
                    konsolaFirmy.konstrOgl, konsolaFirmy.konstrTelefony, pg);
                else
                    errmsg = konsolaFirmy.komSieciowa.kontaFirm.utworzKonto(konsolaFirmy.konstrOgl, konsolaFirmy.konstrTelefony);
                if (errmsg.compareTo("OK") == 0) {
                    JOptionPane.showMessageDialog(this, "Rejestracja uwie\u0144czona sukcesem.\n " +
                    "Mo\u017cesz si\u0119 zalogowa\u0107.", "Informacja", JOptionPane.INFORMATION_MESSAGE);
                    konsolaFirmy.usunWidokOgloszenia();
                }
                else
                    JOptionPane.showMessageDialog(this, "Rejestracja nie powiod\u0142a si\u0119.\n" + errmsg,
                    "B\u0142\u0105d", JOptionPane.ERROR_MESSAGE);
                
                konsolaFirmy.pg = null;
                konsolaFirmy.konstrOgl = null;
                
            } catch (Wyjatek w) {
                JOptionPane.showMessageDialog(this, "Rejestracja nie powiod\u0142a si\u0119.\n" +
                "Upewnij si\u0119, czy dane s\u0105 wprowadzone poprawnie.", "B\u0142\u0105d", JOptionPane.ERROR_MESSAGE);
            } catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }//GEN-LAST:event_wyslijButtonActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton anulujButton;
    private javax.swing.JFormattedTextField noweOgloszenieLabel;
    private javax.swing.JButton wyslijButton;
    // End of variables declaration//GEN-END:variables
    
}
