/*
 * WidokNowegoOgloszenia.java
 *
 * Created on 26 kwiecie 2004, 12:16
 */

package firma;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Calendar;
import java.util.ArrayList;
import java.rmi.RemoteException;
import javax.swing.*;
import java.awt.*;
import java.io.*;
import shared.*;
import komponenty.PomocnikFirmaUser;
import komponenty.JPasswordFieldPolski;

/**
 * Wywietla ekran, ktry umoliwia edycj ogoszenia firmy.
 *
 * @author  ek197882
 */
public class WidokOgloszenia extends javax.swing.JPanel implements komponenty.BranzaWaiter {
    
    /**
     * Konsola firmy, na ktorej jest wywietlony ten widok.
     */
    KonsolaFirmy konsolaFirmy;
    
    /** Wybr brany. */
    komponenty.BranzaWyborOkno bwo;
    
    /**
     * Wybrana brana.
     */
    Branza branza;
    
    /**
     * Konstruktor.
     *
     * @param kons Konsola firmy, do ktrej przyczony jest widok
     */
    public WidokOgloszenia(KonsolaFirmy kons) {
        branza = null;
        konsolaFirmy = kons;
        initComponents();
        myInitComponents();
        pokazOgloszenie();
    }
    
    /** Inicjalizacja dodatkowych pl. */
    private void myInitComponents() {
        hasloText = new komponenty.JPasswordFieldPolski();
        powtorzText = new komponenty.JPasswordFieldPolski();
        
        hasloText.setToolTipText("Has\u0142o dost\u0119pu do konta zarz\u0105dzaj\u0105cego og\u0142oszeniem.");
        glownyJPanel.add(hasloText);
        hasloText.setBounds(60, 30, 80, 19);
        
        powtorzText.setToolTipText("Powt\u00f3rzenie has\u0142a.");
        glownyJPanel.add(powtorzText);
        powtorzText.setBounds(210, 30, 80, 19);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        logoGdzieButtonGroup = new javax.swing.ButtonGroup();
        glownyJPanel = new javax.swing.JPanel();
        nipText = new javax.swing.JTextField();
        nazwaText = new javax.swing.JTextField();
        branzaText = new javax.swing.JTextField();
        przegladajBranzeButton = new javax.swing.JButton();
        ulicaText = new javax.swing.JTextField();
        domText = new javax.swing.JTextField();
        mieszkText = new javax.swing.JTextField();
        pocztaText = new javax.swing.JTextField();
        dzienSpinner = new javax.swing.JSpinner();
        miesiacComboBox = new javax.swing.JComboBox();
        rokSpinner = new javax.swing.JSpinner();
        rokLabel = new javax.swing.JLabel();
        nipLabel = new javax.swing.JLabel();
        hasloLabel = new javax.swing.JLabel();
        ulicaLabel = new javax.swing.JLabel();
        domLabel = new javax.swing.JLabel();
        mieszkLabel = new javax.swing.JLabel();
        pocztaLabel = new javax.swing.JLabel();
        nazwaLabel = new javax.swing.JLabel();
        dataLabel = new javax.swing.JLabel();
        miesiacLabel = new javax.swing.JLabel();
        branzaLabel = new javax.swing.JLabel();
        adresLabel = new javax.swing.JLabel();
        dzienLabel = new javax.swing.JLabel();
        dataSeparator = new javax.swing.JSeparator();
        adresSeparator = new javax.swing.JSeparator();
        powtorzLabel = new javax.swing.JLabel();
        internetJPanel = new javax.swing.JPanel();
        stronaText = new javax.swing.JTextField();
        mailText = new javax.swing.JTextField();
        kontaktText = new javax.swing.JTextField();
        telefonGlownyText = new javax.swing.JTextField();
        telefonGlownyOpisText = new javax.swing.JTextField();
        faxText = new javax.swing.JTextField();
        stronaLabel = new javax.swing.JLabel();
        mailLabel = new javax.swing.JLabel();
        kontaktLabel = new javax.swing.JLabel();
        telefonLabel = new javax.swing.JLabel();
        faxLabel = new javax.swing.JLabel();
        telefonGlownyOpisLabel = new javax.swing.JLabel();
        platneBox = new javax.swing.JCheckBox();
        platneJPanel = new javax.swing.JPanel();
        godzinyText = new javax.swing.JTextField();
        uslugiText = new javax.swing.JTextPane();
        lewoRadio = new javax.swing.JRadioButton();
        goraRadio = new javax.swing.JRadioButton();
        prawoRadio = new javax.swing.JRadioButton();
        dolRadio = new javax.swing.JRadioButton();
        przegladajButton = new javax.swing.JButton();
        usunLogoButton = new javax.swing.JButton();
        slowoKl1Text = new javax.swing.JTextField();
        slowoKl2Text = new javax.swing.JTextField();
        slowoKl3Text = new javax.swing.JTextField();
        slowoKl4Text = new javax.swing.JTextField();
        telefon1Text = new javax.swing.JTextField();
        telefon1OpisText = new javax.swing.JTextField();
        telefon2Text = new javax.swing.JTextField();
        telefon2OpisText = new javax.swing.JTextField();
        telefon3Text = new javax.swing.JTextField();
        telefon3OpisText = new javax.swing.JTextField();
        telefon4Text = new javax.swing.JTextField();
        telefon4OpisText = new javax.swing.JTextField();
        godzinyLabel = new javax.swing.JLabel();
        uslugiLabel = new javax.swing.JLabel();
        logoLabel = new javax.swing.JLabel();
        gdzieLogoLabel = new javax.swing.JLabel();
        polozenieLogoLabel = new javax.swing.JLabel();
        slowaKlLabel = new javax.swing.JLabel();
        dodTelLabel = new javax.swing.JLabel();
        logoSeparator = new javax.swing.JSeparator();
        logoPanel = new javax.swing.JPanel();
        logoPomPanel = new javax.swing.JPanel();

        setLayout(null);

        setForeground(new java.awt.Color(0, 0, 153));
        setAutoscrolls(true);
        glownyJPanel.setLayout(null);

        glownyJPanel.setBorder(new javax.swing.border.EtchedBorder());
        glownyJPanel.setFont(new java.awt.Font("Dialog", 1, 12));
        nipText.setToolTipText("Numer NIP firmy. Identyfikuje og\u0142oszenie.");
        glownyJPanel.add(nipText);
        nipText.setBounds(60, 10, 230, 19);

        nazwaText.setToolTipText("Nazwa firmy.");
        glownyJPanel.add(nazwaText);
        nazwaText.setBounds(60, 50, 230, 19);

        branzaText.setEditable(false);
        branzaText.setToolTipText("Bran\u017ca firmy.");
        branzaText.setFocusable(false);
        glownyJPanel.add(branzaText);
        branzaText.setBounds(60, 70, 230, 19);

        przegladajBranzeButton.setText("Przegl\u0105daj katalog bran\u017c");
        przegladajBranzeButton.setToolTipText("Umo\u017cliwia wyb\u00f3r bran\u017cy firmy.");
        przegladajBranzeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                przegladajBranzeButtonActionPerformed(evt);
            }
        });

        glownyJPanel.add(przegladajBranzeButton);
        przegladajBranzeButton.setBounds(100, 92, 188, 25);

        ulicaText.setToolTipText("Nazwa ulicy, przy kt\u00f3rej jest po\u0142o\u017cona firma.");
        glownyJPanel.add(ulicaText);
        ulicaText.setBounds(130, 150, 160, 19);

        domText.setToolTipText("Numer domu przy ulicy, gdzie mie\u015bci si\u0119 firma.");
        glownyJPanel.add(domText);
        domText.setBounds(130, 170, 160, 19);

        mieszkText.setToolTipText("Numer mieszkania. Nieobowi\u0105zkowy.");
        glownyJPanel.add(mieszkText);
        mieszkText.setBounds(130, 190, 160, 19);

        pocztaText.setToolTipText("Kod pocztowy firmy.");
        glownyJPanel.add(pocztaText);
        pocztaText.setBounds(130, 210, 160, 19);

        dzienSpinner.setToolTipText("Dzie\u0144 za\u0142o\u017cenia firmy.");
        dzienSpinner.setModel(new SpinnerNumberModel(1, 1, 31, 1));
        glownyJPanel.add(dzienSpinner);
        dzienSpinner.setBounds(130, 270, 160, 20);

        miesiacComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "stycze\u0144", "luty", "marzec", "kwiecie\u0144", "maj", "czerwiec", "lipiec", "sierpie\u0144", "wrzesie\u0144", "pa\u017adziernik", "listopad", "grudzie\u0144" }));
        miesiacComboBox.setToolTipText("Miesi\u0105c za\u0142o\u017cenia firmy.");
        glownyJPanel.add(miesiacComboBox);
        miesiacComboBox.setBounds(130, 290, 160, 20);

        rokSpinner.setToolTipText("Rok za\u0142o\u017cenia firmy.");
        rokSpinner.setModel(new SpinnerNumberModel(2000, 1600, 3000, 1));
        glownyJPanel.add(rokSpinner);
        rokSpinner.setBounds(130, 310, 160, 20);

        rokLabel.setText("Rok");
        rokLabel.setToolTipText("Rok za\u0142o\u017cenia.");
        glownyJPanel.add(rokLabel);
        rokLabel.setBounds(30, 310, 24, 15);

        nipLabel.setText("NIP");
        nipLabel.setToolTipText("Numer NIP firmy. Identyfikuje og\u0142oszenie.");
        glownyJPanel.add(nipLabel);
        nipLabel.setBounds(10, 10, 30, 15);

        hasloLabel.setText("Has\u0142o");
        hasloLabel.setToolTipText("Has\u0142o dost\u0119pu do konta umo\u017cliwiaj\u0105cego zarz\u0105dzanie og\u0142oszeniem.");
        glownyJPanel.add(hasloLabel);
        hasloLabel.setBounds(10, 30, 35, 15);

        ulicaLabel.setText("Ulica");
        ulicaLabel.setToolTipText("Nazwa ulicy, przy kt\u00f3rej jest po\u0142o\u017cona firma.");
        glownyJPanel.add(ulicaLabel);
        ulicaLabel.setBounds(30, 150, 30, 15);

        domLabel.setText("Nr domu");
        domLabel.setToolTipText("Numer domu przy ulicy, gdzie mie\u015bci si\u0119 firma.");
        glownyJPanel.add(domLabel);
        domLabel.setBounds(30, 170, 54, 15);

        mieszkLabel.setText("Nr mieszkania");
        mieszkLabel.setToolTipText("Numer mieszkania. Nieobowi\u0105zkowy.");
        glownyJPanel.add(mieszkLabel);
        mieszkLabel.setBounds(30, 190, 89, 15);

        pocztaLabel.setText("Kod pocztowy");
        pocztaLabel.setToolTipText("Kod pocztowy firmy.");
        glownyJPanel.add(pocztaLabel);
        pocztaLabel.setBounds(30, 210, 89, 15);

        nazwaLabel.setText("Nazwa");
        nazwaLabel.setToolTipText("Nazwa firmy.");
        glownyJPanel.add(nazwaLabel);
        nazwaLabel.setBounds(10, 50, 41, 15);

        dataLabel.setText("Data za\u0142o\u017cenia");
        dataLabel.setToolTipText("Data za\u0142o\u017cenia firmy.");
        glownyJPanel.add(dataLabel);
        dataLabel.setBounds(10, 250, 92, 15);

        miesiacLabel.setText("Miesi\u0105c");
        miesiacLabel.setToolTipText("Miesi\u0105c za\u0142o\u017cenia.");
        glownyJPanel.add(miesiacLabel);
        miesiacLabel.setBounds(30, 290, 46, 15);

        branzaLabel.setText("Bran\u017ca");
        branzaLabel.setToolTipText("Bran\u017ca firmy.");
        glownyJPanel.add(branzaLabel);
        branzaLabel.setBounds(10, 70, 42, 15);

        adresLabel.setText("Adres:");
        adresLabel.setToolTipText("Adres firmy.");
        glownyJPanel.add(adresLabel);
        adresLabel.setBounds(10, 130, 39, 15);

        dzienLabel.setText("Dzie\u0144");
        dzienLabel.setToolTipText("Dzie\u0144 za\u0142o\u017cenia.");
        glownyJPanel.add(dzienLabel);
        dzienLabel.setBounds(30, 270, 36, 15);

        glownyJPanel.add(dataSeparator);
        dataSeparator.setBounds(10, 240, 280, 10);

        glownyJPanel.add(adresSeparator);
        adresSeparator.setBounds(10, 120, 280, 10);

        powtorzLabel.setText("Powt\u00f3rz");
        glownyJPanel.add(powtorzLabel);
        powtorzLabel.setBounds(152, 32, 51, 15);

        add(glownyJPanel);
        glownyJPanel.setBounds(0, 0, 300, 340);

        internetJPanel.setLayout(null);

        internetJPanel.setBorder(new javax.swing.border.EtchedBorder());
        stronaText.setToolTipText("Adres portalu internetowego. Nieobowi\u0105zkowy.");
        internetJPanel.add(stronaText);
        stronaText.setBounds(130, 10, 590, 19);

        mailText.setToolTipText("Adres e-mail, kt\u00f3ry zostanie wypisany na wizyt\u00f3wce firmy. Nieobowi\u0105zkowy.");
        internetJPanel.add(mailText);
        mailText.setBounds(130, 30, 590, 19);

        kontaktText.setToolTipText("Adres kontaktowy z firm\u0105. Nie b\u0119dzie cz\u0119\u015bci\u0105 wy\u015bwietlanych danych.");
        internetJPanel.add(kontaktText);
        kontaktText.setBounds(130, 50, 590, 19);

        telefonGlownyText.setText(" ");
        telefonGlownyText.setToolTipText("Telefon do firmy. Nieobowi\u0105zkowy.");
        internetJPanel.add(telefonGlownyText);
        telefonGlownyText.setBounds(130, 70, 90, 19);

        telefonGlownyOpisText.setToolTipText("Opis telefonu. Nieobowi\u0105zkowy.");
        internetJPanel.add(telefonGlownyOpisText);
        telefonGlownyOpisText.setBounds(310, 70, 170, 19);

        faxText.setToolTipText("Numer faksu do firmy. Nieobowi\u0105zkowy.");
        internetJPanel.add(faxText);
        faxText.setBounds(530, 70, 190, 20);

        stronaLabel.setText("Strona internetowa");
        stronaLabel.setToolTipText("Adres portalu internetowego firmy. Nieobowi\u0105zkowy.");
        internetJPanel.add(stronaLabel);
        stronaLabel.setBounds(10, 10, 119, 15);

        mailLabel.setText("E-mail");
        mailLabel.setToolTipText("Adres e-mail, kt\u00f3ry zostanie wypisany na wizyt\u00f3wce firmy. Nieobowi\u0105zkowy.");
        internetJPanel.add(mailLabel);
        mailLabel.setBounds(10, 30, 42, 15);

        kontaktLabel.setText("Kontakt e-mail");
        kontaktLabel.setToolTipText("Adres kontaktowy z firm\u0105, Nie b\u0119dzie cz\u0119\u015bci\u0105 wy\u015bwietlanych danych.");
        internetJPanel.add(kontaktLabel);
        kontaktLabel.setBounds(10, 50, 96, 15);

        telefonLabel.setText("Telefon g\u0142\u00f3wny");
        telefonLabel.setToolTipText("Telefon do firmy. Nieobowi\u0105zkowy.");
        internetJPanel.add(telefonLabel);
        telefonLabel.setBounds(10, 70, 97, 15);

        faxLabel.setText("Fax");
        faxLabel.setToolTipText("Numer faksu do firmy. Nieobowi\u0105zkowy.");
        internetJPanel.add(faxLabel);
        faxLabel.setBounds(500, 72, 21, 15);

        telefonGlownyOpisLabel.setText("opis telefonu");
        telefonGlownyOpisLabel.setToolTipText("Opis telefonu. Nieobowi\u0105zkowy.");
        internetJPanel.add(telefonGlownyOpisLabel);
        telefonGlownyOpisLabel.setBounds(224, 72, 83, 15);

        add(internetJPanel);
        internetJPanel.setBounds(0, 340, 730, 100);

        platneBox.setMnemonic('L');
        platneBox.setText("P\u0142atne og\u0142oszenie?");
        platneBox.setToolTipText("Okre\u015bla, czy og\u0142oszenie jest p\u0142atne?");
        platneBox.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                setReversePlatne(evt);
            }
        });

        add(platneBox);
        platneBox.setBounds(300, 2, 141, 18);

        platneJPanel.setLayout(null);

        platneJPanel.setBorder(new javax.swing.border.EtchedBorder());
        platneJPanel.setAutoscrolls(true);
        platneJPanel.setEnabled(false);
        godzinyText.setToolTipText("Godziny otwarcia firmy. Nieobowi\u0105zkowe.");
        godzinyText.setEnabled(false);
        platneJPanel.add(godzinyText);
        godzinyText.setBounds(130, 10, 290, 20);

        uslugiText.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(102, 102, 102)));
        uslugiText.setToolTipText("Opis us\u0142ug firmy. Nieobowi\u0105zkowy.");
        uslugiText.setFocusCycleRoot(false);
        uslugiText.setEnabled(false);
        platneJPanel.add(uslugiText);
        uslugiText.setBounds(70, 30, 350, 80);

        lewoRadio.setMnemonic('l');
        lewoRadio.setText("lewo");
        lewoRadio.setToolTipText("W lewej cz\u0119\u015bci wizyt\u00f3wki.");
        logoGdzieButtonGroup.add(lewoRadio);
        lewoRadio.setEnabled(false);
        platneJPanel.add(lewoRadio);
        lewoRadio.setBounds(80, 140, 55, 23);

        goraRadio.setMnemonic('g');
        goraRadio.setSelected(true);
        goraRadio.setText("g\u00f3ra");
        goraRadio.setToolTipText("W g\u00f3rnej cz\u0119\u015bci wizyt\u00f3wki.");
        logoGdzieButtonGroup.add(goraRadio);
        goraRadio.setEnabled(false);
        platneJPanel.add(goraRadio);
        goraRadio.setBounds(80, 120, 53, 23);

        prawoRadio.setMnemonic('p');
        prawoRadio.setText("prawo");
        prawoRadio.setToolTipText("W prawej cz\u0119\u015bci wizyt\u00f3wki.");
        logoGdzieButtonGroup.add(prawoRadio);
        prawoRadio.setEnabled(false);
        platneJPanel.add(prawoRadio);
        prawoRadio.setBounds(80, 160, 64, 23);

        dolRadio.setMnemonic('d');
        dolRadio.setText("d\u00f3\u0142");
        dolRadio.setToolTipText("W dolnej cz\u0119\u015bci wizyt\u00f3wki.");
        logoGdzieButtonGroup.add(dolRadio);
        dolRadio.setEnabled(false);
        platneJPanel.add(dolRadio);
        dolRadio.setBounds(80, 180, 45, 20);

        przegladajButton.setMnemonic('W');
        przegladajButton.setText("Wybierz logo");
        przegladajButton.setToolTipText("Umo\u017cliwia wskazanie pliku logo. Logo zostanie umieszczone na serwerze po zatwierdzenieu zmian.");
        przegladajButton.setEnabled(false);
        przegladajButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                przegladajButtonActionPerformed(evt);
            }
        });

        platneJPanel.add(przegladajButton);
        przegladajButton.setBounds(210, 120, 120, 40);

        usunLogoButton.setMnemonic('U');
        usunLogoButton.setText("Usu\u0144 logo");
        usunLogoButton.setToolTipText("Bezzw\u0142ocznie usuwa logo z serwera.");
        usunLogoButton.setEnabled(false);
        usunLogoButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                usunLogoButtonActionPerformed(evt);
            }
        });

        platneJPanel.add(usunLogoButton);
        usunLogoButton.setBounds(210, 165, 120, 30);

        slowoKl1Text.setToolTipText("S\u0142owo kluczowe.");
        slowoKl1Text.setEnabled(false);
        platneJPanel.add(slowoKl1Text);
        slowoKl1Text.setBounds(10, 230, 200, 19);

        slowoKl2Text.setToolTipText("S\u0142owo kluczowe.");
        slowoKl2Text.setEnabled(false);
        platneJPanel.add(slowoKl2Text);
        slowoKl2Text.setBounds(10, 250, 200, 19);

        slowoKl3Text.setToolTipText("S\u0142owo kluczowe.");
        slowoKl3Text.setEnabled(false);
        platneJPanel.add(slowoKl3Text);
        slowoKl3Text.setBounds(10, 270, 200, 19);

        slowoKl4Text.setToolTipText("S\u0142owo kluczowe.");
        slowoKl4Text.setEnabled(false);
        platneJPanel.add(slowoKl4Text);
        slowoKl4Text.setBounds(10, 290, 200, 19);

        telefon1Text.setToolTipText("Numer telefonu.");
        telefon1Text.setEnabled(false);
        platneJPanel.add(telefon1Text);
        telefon1Text.setBounds(230, 230, 70, 19);

        telefon1OpisText.setToolTipText("Opis telefonu.");
        telefon1OpisText.setEnabled(false);
        platneJPanel.add(telefon1OpisText);
        telefon1OpisText.setBounds(310, 230, 110, 19);

        telefon2Text.setToolTipText("Numer telefonu.");
        telefon2Text.setEnabled(false);
        platneJPanel.add(telefon2Text);
        telefon2Text.setBounds(230, 250, 70, 19);

        telefon2OpisText.setToolTipText("Opis telefonu.");
        telefon2OpisText.setEnabled(false);
        platneJPanel.add(telefon2OpisText);
        telefon2OpisText.setBounds(310, 250, 110, 19);

        telefon3Text.setToolTipText("Numer telefonu.");
        telefon3Text.setEnabled(false);
        platneJPanel.add(telefon3Text);
        telefon3Text.setBounds(230, 270, 70, 19);

        telefon3OpisText.setToolTipText("Opis telefonu.");
        telefon3OpisText.setEnabled(false);
        platneJPanel.add(telefon3OpisText);
        telefon3OpisText.setBounds(310, 270, 110, 20);

        telefon4Text.setToolTipText("Numer telefonu.");
        telefon4Text.setEnabled(false);
        platneJPanel.add(telefon4Text);
        telefon4Text.setBounds(230, 290, 70, 19);

        telefon4OpisText.setToolTipText("Opis telefonu.");
        telefon4OpisText.setEnabled(false);
        platneJPanel.add(telefon4OpisText);
        telefon4OpisText.setBounds(310, 290, 110, 20);

        godzinyLabel.setLabelFor(godzinyText);
        godzinyLabel.setText("Godziny otwarcia");
        godzinyLabel.setToolTipText("Godziny otwarcia firmy. Nieobowi\u0105zkowe.");
        godzinyLabel.setEnabled(false);
        platneJPanel.add(godzinyLabel);
        godzinyLabel.setBounds(10, 10, 108, 15);

        uslugiLabel.setLabelFor(uslugiText);
        uslugiLabel.setText("Us\u0142ugi");
        uslugiLabel.setToolTipText("Opis us\u0142ug firmy. Nieobowi\u0105zkowy.");
        uslugiLabel.setEnabled(false);
        platneJPanel.add(uslugiLabel);
        uslugiLabel.setBounds(10, 30, 40, 15);

        logoLabel.setText("Logo");
        logoLabel.setToolTipText("Plik logo firmy. Nieobowi\u0105zkowy.");
        logoLabel.setEnabled(false);
        platneJPanel.add(logoLabel);
        logoLabel.setBounds(170, 120, 31, 15);

        gdzieLogoLabel.setText("Po\u0142o\u017cenie");
        gdzieLogoLabel.setToolTipText("Po\u0142o\u017cenie logo na wizyt\u00f3wce. Nieobowi\u0105zkowe.");
        gdzieLogoLabel.setEnabled(false);
        platneJPanel.add(gdzieLogoLabel);
        gdzieLogoLabel.setBounds(10, 120, 60, 15);

        polozenieLogoLabel.setText("logo");
        polozenieLogoLabel.setToolTipText("Po\u0142o\u017cenie logo na wizyt\u00f3wce. Nieobowi\u0105zkowe.");
        polozenieLogoLabel.setEnabled(false);
        platneJPanel.add(polozenieLogoLabel);
        polozenieLogoLabel.setBounds(10, 135, 28, 15);

        slowaKlLabel.setText("S\u0142owa kluczowe");
        slowaKlLabel.setToolTipText("S\u0142owa umo\u017cliwiaj\u0105ce wyszukiwanie og\u0142oszenia. Nieobowi\u0105zkowe.");
        slowaKlLabel.setEnabled(false);
        platneJPanel.add(slowaKlLabel);
        slowaKlLabel.setBounds(10, 210, 140, 15);

        dodTelLabel.setText("Dodatkowe telefony");
        dodTelLabel.setToolTipText("Inne telefony do firmy.");
        dodTelLabel.setEnabled(false);
        platneJPanel.add(dodTelLabel);
        dodTelLabel.setBounds(230, 210, 130, 15);

        platneJPanel.add(logoSeparator);
        logoSeparator.setBounds(10, 202, 410, 10);

        logoPanel.setBorder(new javax.swing.border.EtchedBorder());
        logoPanel.setEnabled(false);
        platneJPanel.add(logoPanel);
        logoPanel.setBounds(340, 115, 80, 80);

        logoPomPanel.setLayout(null);

        logoPomPanel.setBorder(new javax.swing.border.EtchedBorder());
        logoPomPanel.setToolTipText("Plik logo formy. Nieobowi\u0105zkowy.");
        logoPomPanel.setEnabled(false);
        platneJPanel.add(logoPomPanel);
        logoPomPanel.setBounds(340, 115, 80, 80);

        add(platneJPanel);
        platneJPanel.setBounds(300, 20, 430, 320);

    }//GEN-END:initComponents
    
    /**
     * Akcja wykonywana po przyciniciu przycisku "Usu logo".
     * Usuwa logo z serwera.
     */
    private void usunLogoButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_usunLogoButtonActionPerformed
        konsolaFirmy.pg = null;
        logoPanel.setVisible(false);
        if (konsolaFirmy.ogl != null)
            try {
                if (konsolaFirmy.komSieciowa.kontaFirm.usunLogo(konsolaFirmy.ogl.getId()))
                    JOptionPane.showMessageDialog(this, "Logo usuni\u0119to.", "Informacja",
                    JOptionPane.INFORMATION_MESSAGE);
            } catch (RemoteException re) {
                re.printStackTrace();
            }
    }//GEN-LAST:event_usunLogoButtonActionPerformed
    
    private void przegladajBranzeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_przegladajBranzeButtonActionPerformed
        try {
            if (konsolaFirmy.kb == null) {
                /* pobieramy skompilowany katalog branz */
                konsolaFirmy.kb = konsolaFirmy.komSieciowa.pobierzKatalogBranz(konsolaFirmy.getCodeBase().toString())                ;
                /* aby pobrac katalog branz bezposrednio z bazy danych: */
                /* konsolaFirmy.kb = konsolaFirmy.komSieciowa.katalogBranz.dajZwartoscKataloguBranz(); */
            }
            bwo = new komponenty.BranzaWyborOkno(konsolaFirmy.kb, this);
            bwo.show();
        } catch (Wyjatek w) {
            err("Pobieranie katalogu bran\u017c nie powiod\u0142o si\u0119.");
        }
    }//GEN-LAST:event_przegladajBranzeButtonActionPerformed
    
    /**
     * Akcja wykonywana po klikniciu guzika "Wska logo".
     * Umozliwia wybor logo (wskazanie pliku zawierajcego logo),
     * ktre zostanie umieszczone na serwerze i zwizane z t firm.
     *
     * eby ta metoda nie zakoczya si bedem "access denied",
     * aplet firmy musi by podpisany i uytkownik musi zaakceptowa
     * certyfikat.
     *
     * @param evt Zdarzenie wcinicia guzika "Wska logo"
     */
    private void przegladajButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_przegladajButtonActionPerformed
        JFileChooser fc = new JFileChooser();
        
        int rv = fc.showDialog(this, "Wybierz");
        if (rv == JFileChooser.APPROVE_OPTION) {
            try {
                /* zapamietaj plik logo */
                
                /* uw. ponizszy kod nie moze byc wykonany za pomoca:
                 * PlikGraficzny(fc.getSelectedFile()), gdyz, ta metoda
                 * znajduje si w niepodpisanym pliku jar */
                File plik = fc.getSelectedFile();
                byte[] dane;
                
                FileInputStream is = new FileInputStream(plik);
                long length = plik.length();
                if (length > Integer.MAX_VALUE)
                    throw new Wyjatek(); // plik za duzy
                dane = new byte[(int)length];
                
                int offset = 0;
                int numRead = 0;
                while (offset < dane.length &&
                (numRead=is.read(dane, offset, dane.length-offset)) >= 0) {
                    offset += numRead;
                }
                
                if (offset < dane.length)
                    throw new Wyjatek();
                is.close();
                konsolaFirmy.pg = new PlikGraficzny(dane);
                
                /* wyswietl logo */
                wyswietlLogo(new ImageIcon(fc.getSelectedFile().toURL()));
            } catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Nie uda\u0142o si\u0119 pobra\u0107 pliku.");
            }
        }
    }//GEN-LAST:event_przegladajButtonActionPerformed
    
    /**
     * Blokuje / odblokowuje panel z informacjemi o platnym
     * ogloszeniu, zalenie od tego czy pletneBox jest zaznaczone.
     */
    private void reverse() {
        boolean czy = platneBox.isSelected();
        platneJPanel.setEnabled(czy);
        godzinyLabel.setEnabled(czy);
        godzinyText.setEnabled(czy);
        uslugiLabel.setEnabled(czy);
        uslugiText.setEnabled(czy);
        if (czy) {
            uslugiText.setForeground(Color.BLACK);
            logoPanel.setVisible(true);
        } else {
            uslugiText.setForeground(Color.LIGHT_GRAY);
            logoPanel.setVisible(false);
        }
        gdzieLogoLabel.setEnabled(czy);
        polozenieLogoLabel.setEnabled(czy);
        lewoRadio.setEnabled(czy);
        prawoRadio.setEnabled(czy);
        dolRadio.setEnabled(czy);
        goraRadio.setEnabled(czy);
        logoLabel.setEnabled(czy);
        logoPanel.setEnabled(czy);
        logoPomPanel.setEnabled(czy);
        przegladajButton.setEnabled(czy);
        usunLogoButton.setEnabled(czy);
        slowaKlLabel.setEnabled(czy);
        slowoKl1Text.setEnabled(czy);
        slowoKl2Text.setEnabled(czy);
        slowoKl3Text.setEnabled(czy);
        slowoKl4Text.setEnabled(czy);
        dodTelLabel.setEnabled(czy);
        telefon1Text.setEnabled(czy);
        telefon2Text.setEnabled(czy);
        telefon3Text.setEnabled(czy);
        telefon4Text.setEnabled(czy);
        telefon1OpisText.setEnabled(czy);
        telefon2OpisText.setEnabled(czy);
        telefon3OpisText.setEnabled(czy);
        telefon4OpisText.setEnabled(czy);
        logoSeparator.setEnabled(czy);
        
        this.repaint();
    }
    
    /**
     * Akcja wykonywana po zaznaczeniu i odznaczeniu pola "platneBox".
     * Blokuje / odblokowuje panel z informacjemi o platnym
     * ogloszeniu.
     *
     * @param evt Zdarzenie zaznaczenia / odznaczenia pola "platneBox"
     */
    private void setReversePlatne(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_setReversePlatne
        reverse();
    }//GEN-LAST:event_setReversePlatne
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel adresLabel;
    private javax.swing.JSeparator adresSeparator;
    private javax.swing.JLabel branzaLabel;
    private javax.swing.JTextField branzaText;
    private javax.swing.JLabel dataLabel;
    private javax.swing.JSeparator dataSeparator;
    private javax.swing.JLabel dodTelLabel;
    private javax.swing.JRadioButton dolRadio;
    private javax.swing.JLabel domLabel;
    private javax.swing.JTextField domText;
    private javax.swing.JLabel dzienLabel;
    private javax.swing.JSpinner dzienSpinner;
    private javax.swing.JLabel faxLabel;
    private javax.swing.JTextField faxText;
    private javax.swing.JLabel gdzieLogoLabel;
    private javax.swing.JPanel glownyJPanel;
    private javax.swing.JLabel godzinyLabel;
    private javax.swing.JTextField godzinyText;
    private javax.swing.JRadioButton goraRadio;
    private javax.swing.JLabel hasloLabel;
    private javax.swing.JPanel internetJPanel;
    private javax.swing.JLabel kontaktLabel;
    private javax.swing.JTextField kontaktText;
    private javax.swing.JRadioButton lewoRadio;
    private javax.swing.ButtonGroup logoGdzieButtonGroup;
    private javax.swing.JLabel logoLabel;
    private javax.swing.JPanel logoPanel;
    private javax.swing.JPanel logoPomPanel;
    private javax.swing.JSeparator logoSeparator;
    private javax.swing.JLabel mailLabel;
    private javax.swing.JTextField mailText;
    private javax.swing.JComboBox miesiacComboBox;
    private javax.swing.JLabel miesiacLabel;
    private javax.swing.JLabel mieszkLabel;
    private javax.swing.JTextField mieszkText;
    private javax.swing.JLabel nazwaLabel;
    private javax.swing.JTextField nazwaText;
    private javax.swing.JLabel nipLabel;
    private javax.swing.JTextField nipText;
    private javax.swing.JCheckBox platneBox;
    private javax.swing.JPanel platneJPanel;
    private javax.swing.JLabel pocztaLabel;
    private javax.swing.JTextField pocztaText;
    private javax.swing.JLabel polozenieLogoLabel;
    private javax.swing.JLabel powtorzLabel;
    private javax.swing.JRadioButton prawoRadio;
    private javax.swing.JButton przegladajBranzeButton;
    private javax.swing.JButton przegladajButton;
    private javax.swing.JLabel rokLabel;
    private javax.swing.JSpinner rokSpinner;
    private javax.swing.JLabel slowaKlLabel;
    private javax.swing.JTextField slowoKl1Text;
    private javax.swing.JTextField slowoKl2Text;
    private javax.swing.JTextField slowoKl3Text;
    private javax.swing.JTextField slowoKl4Text;
    private javax.swing.JLabel stronaLabel;
    private javax.swing.JTextField stronaText;
    private javax.swing.JTextField telefon1OpisText;
    private javax.swing.JTextField telefon1Text;
    private javax.swing.JTextField telefon2OpisText;
    private javax.swing.JTextField telefon2Text;
    private javax.swing.JTextField telefon3OpisText;
    private javax.swing.JTextField telefon3Text;
    private javax.swing.JTextField telefon4OpisText;
    private javax.swing.JTextField telefon4Text;
    private javax.swing.JLabel telefonGlownyOpisLabel;
    private javax.swing.JTextField telefonGlownyOpisText;
    private javax.swing.JTextField telefonGlownyText;
    private javax.swing.JLabel telefonLabel;
    private javax.swing.JLabel ulicaLabel;
    private javax.swing.JTextField ulicaText;
    private javax.swing.JLabel uslugiLabel;
    private javax.swing.JTextPane uslugiText;
    private javax.swing.JButton usunLogoButton;
    // End of variables declaration//GEN-END:variables
    private komponenty.JPasswordFieldPolski hasloText;
    private komponenty.JPasswordFieldPolski powtorzText;
    
    
    /**
     * Informuje uytkownika o bdach, np.&nbsp;w konstrukcji nowego ogloszenia.
     *
     * @param errmsg Informacja, ktra zostanie wywietlona uytkownikowi
     */
    public void err(String errmsg) {
        JOptionPane.showMessageDialog(this, errmsg, "B\u0142\u0105d", JOptionPane.ERROR_MESSAGE);
    }
    
    /**
     * Konstruuje numer domu i mieszkania. Dokonuje wstpnego
     * sprawdzenia poprawnoci danych.
     *
     * @return Skonstruowany numer lub -1, gdy dane miay niepoprawny format.
     *
     * @param pole Pole widoku, z ktrego zostanie odczytany numer.
     * @param nazwaPola Nazwa pola jako napis, potrzebne przy informacji, e
     * nastpi bd konstrukcji
     */
    private int konstruujNumer(JTextField pole, String nazwaPola) {
        Integer nr;
        try {
            nr = new Integer(pole.getText());
            if (nr.intValue() <= 0) {
                err(nazwaPola + " nie mo\u017ce by\u0107 licz\u0105 ujemn\u0105 ani zerem.");
                return 0;
            }
        } catch (Exception e) {
            err("Niepoprawny format numeru domu/mieszkania.");
            return -1;
        }
        return nr.intValue();
    }
    
    /**
     * Konstruuje dat zaoenia firmy.
     *
     * @return Skonstruowana data
     */
    private Date konstruujDateZalozenia() {
        Date d;
        try {
            SpinnerNumberModel modelDzien = (SpinnerNumberModel)dzienSpinner.getModel();
            SpinnerNumberModel modelRok = (SpinnerNumberModel)rokSpinner.getModel();
            int dzien = modelDzien.getNumber().intValue();    /* 1-31 */
            int miesiac = miesiacComboBox.getSelectedIndex(); /* 0-11 */
            int rok = modelRok.getNumber().intValue();
            GregorianCalendar gc = new GregorianCalendar();
            gc.setLenient(false);
            gc.set(Calendar.YEAR, rok);
            gc.set(Calendar.MONTH, miesiac);
            gc.set(Calendar.DAY_OF_MONTH, dzien);
            d = gc.getTime();
        } catch (Exception e) {
            err("Niepoprawny format daty.");
            return null;
        }
        return d;
    }
    
    /**
     * Konstruuje ogloszenie z pobranych danych.
     * Skonstruowane ogoszenie - jeli konstrukcja si powiedzie
     * zostanie zapamitane na zmiennej {@link KonsolaFirmy#konstrOgl}
     */
    public void konstruujOgloszenie() {
        Ogloszenie ogl = new Ogloszenie();
        ArrayList telefony = new ArrayList();
        File logoFile;
        boolean czyPlatne;
        int nr;
        int ileTel = 0;
        
        konsolaFirmy.konstrOgl = null;
        konsolaFirmy.konstrTelefony = null;
        
        /* nip */
        try {
            Nip nip = new Nip(nipText.getText());
            ogl.setNip(nip.nipToInt());
            ogl.setOsobowoscPrawna(nip.czyOsPrawna());
        } catch (Exception e) {
            err("Niepoprawny format nipu.");
            return;
        }
        
        /* haslo */
        String h1 = hasloText.getPasswordString();
        String h2 = powtorzText.getPasswordString();
        if (h1.length() > 0 && h2.length() > 0) {
            if (h1.compareTo(h2) != 0)  {
                err("Wprowadzone has\u0142a s\u0105 r\u00f3\u017cne.");
                return;
            }
            ogl.setHaslo(h1);
        } else {
            err("Ustaw has\u0142o firmy.");
            return;
        }
        
        /* nazwa */
        if (nazwaText.getText().length() > 0)
            ogl.setNazwa(nazwaText.getText());
        else {
            err("Ustaw nazw\u0119 firmy.");
            return;
        }
        
        /* branza */
        if (branza != null) {
            branzaText.setText(branza.getNazwa());
            ogl.setBranza(branza);
        } else {
            err("Ustaw bran\u017c\u0119.");
            return;
        }
        
        
        /* adres */
        
        /* ulica */
        if (ulicaText.getText().length() > 0) {
            java.util.List listaUlic = null;
            try {
                listaUlic = konsolaFirmy.komSieciowa.ulice.znajdzUlice(ulicaText.getText());
            } catch (Wyjatek w) {
            } catch (RemoteException re) {
                err("Pobieranie ulic si\u0119 nie powiod\u0142o.");
                re.printStackTrace();
                return;
            }
            
            if (listaUlic == null || listaUlic.size() == 0) {
                err("Nie ma takiej ulicy!");
                return;
            } else {
                Ulica ulica = (Ulica)listaUlic.get(0);
                ogl.setUlica(ulica);
            }
        } else {
            err("Ustaw ulic\u0119.");
            return;
        }
        
        /* numer domu */
        nr = konstruujNumer(domText, "Numer domu");
        if (nr <= 0) return;
        ogl.setNrDomu(nr);
        
        /* numer mieszkania */
        if (mieszkText.getText().length() > 0) {
            nr = konstruujNumer(mieszkText, "Numer mieszkania");
            if (nr <= 0) return;
        } else
            nr = 0;
        ogl.setNrMieszkania(nr); /* 0 = nie ustawiony */
        
        /* kod pocztowy */
        if (pocztaText.getText().length() > 0) {
            String kod = pocztaText.getText();
            if ((kod.length() !=6) && (kod.length() != 5)) {
                err("Niepoprawny format kodu pocztowego.");
                return;
            }
            
            for (int i = 0; i < kod.length(); i++) {
                Character c = new Character(kod.charAt(i));
                if ((kod.length() == 5 && !Character.isDigit(kod.charAt(i))) ||
                (kod.length() == 6 && ((i != 2 && !Character.isDigit(kod.charAt(i))) ||
                (i == 2 && kod.charAt(i) != '-' && kod.charAt(i) != ' ')
                ))) {
                    err("Niepoprawny format kodu pocztowego.");
                    return;
                }
            }
            if (!Character.isDigit(kod.charAt(0)) && !Character.isDigit(kod.charAt(kod.length() - 1))) {
                err("Niepoprawny format kodu pocztowego.");
                return;
            }
            ogl.setPoczta(pocztaText.getText());
        } else {
            err("Ustaw kod pocztowy.");
            return;
        }
        
        /* data zalozenia */
        Date dataZalozenia = konstruujDateZalozenia();
        if (dataZalozenia == null) return;
        ogl.setDataZalozenia(dataZalozenia);
        
        /* adres internetowty */
        if (stronaText.getText().length() > 0)
            ogl.setStronaInternetowa(stronaText.getText());
        else
            ogl.setStronaInternetowa(null);
        
        /* email */
        if (mailText.getText().length() > 0)
            ogl.setEmail(mailText.getText());
        else
            ogl.setEmail(null);
        
        /* ekontakt */
        if (kontaktText.getText().length() == 0) {
            err("Ustaw e-kontakt.");
            return;
        }
        ogl.setEkontakt(kontaktText.getText());
        
        /* fax */
        if (faxText.getText().length() == 0)
            ogl.setFax(null);
        else
            ogl.setFax(faxText.getText());
        
        /* opcje ogloszenia platnego */
        czyPlatne = this.platneBox.isSelected();
        
        /* telefony zwykle */
        if (telefonGlownyText.getText().length() > 0) {
            ArrayList l = new ArrayList(2);
            l.add(0, telefonGlownyText.getText());
            l.add(1, telefonGlownyOpisText.getText());
            telefony.add(0, l);
            ileTel++;
        }
        
        if (czyPlatne) {
            OgloszeniePlatne oglp = new OgloszeniePlatne();
            ogl.setPlatne(oglp);
            
            /* godziny */
            if (godzinyText.getText().length() == 0)
                oglp.setGodziny(null);
            else
                oglp.setGodziny(godzinyText.getText());
            
            /* uslugi */
            if (uslugiText.getText().length() == 0)
                oglp.setUslugi(null);
            else
                oglp.setUslugi(uslugiText.getText());
            
            /* polozenie logo */
            int logoGdzie;
            if (logoGdzieButtonGroup.getSelection().getMnemonic() == lewoRadio.getMnemonic())
                logoGdzie = PomocnikFirmaUser.LEWO_LOGO;
            else if (logoGdzieButtonGroup.getSelection().getMnemonic() == prawoRadio.getMnemonic())
                logoGdzie = PomocnikFirmaUser.PRAWO_LOGO;
            else if (logoGdzieButtonGroup.getSelection().getMnemonic() == goraRadio.getMnemonic())
                logoGdzie = PomocnikFirmaUser.GORA_LOGO;
            else
                logoGdzie = PomocnikFirmaUser.DOL_LOGO;
            oglp.setLogoGdzie(logoGdzie);
            
            /* slowa kluczowe */
            if (this.slowoKl1Text.getText().length() == 0)
                oglp.setSlowoKluczowe1(null);
            else
                oglp.setSlowoKluczowe1(slowoKl1Text.getText());
            
            if (this.slowoKl2Text.getText().length() == 0)
                oglp.setSlowoKluczowe2(null);
            else
                oglp.setSlowoKluczowe2(slowoKl2Text.getText());
            
            if (this.slowoKl3Text.getText().length() == 0)
                oglp.setSlowoKluczowe3(null);
            else
                oglp.setSlowoKluczowe3(slowoKl3Text.getText());
            
            if (this.slowoKl4Text.getText().length() == 0)
                oglp.setSlowoKluczowe4(null);
            else
                oglp.setSlowoKluczowe4(slowoKl4Text.getText());
            
            /* telefony */
            if (telefon1Text.getText().length() > 0) {
                ArrayList l = new ArrayList(2);
                l.add(0, telefon1Text.getText());
                l.add(1, telefon1OpisText.getText());
                telefony.add(ileTel, l);
                ileTel++;
            }
            
            if (telefon2Text.getText().length() > 0) {
                ArrayList l = new ArrayList(2);
                l.add(0, telefon2Text.getText());
                l.add(1, telefon2OpisText.getText());
                telefony.add(ileTel, l);
                ileTel++;
            }
            
            if (telefon3Text.getText().length() > 0) {
                ArrayList l = new ArrayList(2);
                l.add(0, telefon3Text.getText());
                l.add(1, telefon3OpisText.getText());
                telefony.add(ileTel, l);
                ileTel++;
            }
            
            if (telefon4Text.getText().length() > 0) {
                ArrayList l = new ArrayList(2);
                l.add(0, telefon4Text.getText());
                l.add(1, telefon4OpisText.getText());
                telefony.add(ileTel, l);
                ileTel++;
            }
            
            if (konsolaFirmy.ogl != null && konsolaFirmy.ogl.getPlatne() != null) {
                ogl.getPlatne().setDataOplacenia(konsolaFirmy.ogl.getPlatne().getDataOplacenia());
                ogl.getPlatne().setId(konsolaFirmy.ogl.getPlatne().getId());
            } else {
                ogl.getPlatne().setDataOplacenia(new Date());
            }
        } else {
            ogl.setPlatne(null);
        }
        
        /* inne */
        if (konsolaFirmy.ogl != null) {
            ogl.setId(konsolaFirmy.ogl.getId());
            ogl.setDataAktualizacji(konsolaFirmy.ogl.getDataAktualizacji());
            ogl.setPopularnosc(konsolaFirmy.ogl.getPopularnosc());
            ogl.setPopularnoscPoprz(konsolaFirmy.ogl.getPopularnoscPoprz());
            ogl.setRanking(konsolaFirmy.ogl.getRanking());
            ogl.setWspolrzedna_x(konsolaFirmy.ogl.getWspolrzedna_x());
            ogl.setWspolrzedna_y(konsolaFirmy.ogl.getWspolrzedna_y());
        }
        ogl.setZaakceptowane(false);
        
        /* zapamietanie skonstruowanych obiektow */
        konsolaFirmy.konstrTelefony = telefony;
        konsolaFirmy.konstrOgl = ogl;
        /* konsolaFirmy.pg juz ustawiono */
        
    }
    
    /**
     * Wywietla ogoszenie w polach widoku.
     */
    public void pokazOgloszenie() {
        String brak = "";
        Ogloszenie ogl = konsolaFirmy.ogl;
        ArrayList telefony = konsolaFirmy.telefony;
        
        if (ogl == null) return;
        
        /* nip */
        try {
            nipText.setText(Nip.intToNip(ogl.getNip(), ogl.isOsobowoscPrawna()));
        } catch (Exception e) {
            e.printStackTrace();
        };
        
        /* haslo */
        hasloText.setText(ogl.getHaslo());
        powtorzText.setText(ogl.getHaslo());
        
        /* adres */
        ulicaText.setText(ogl.getUlica().getNazwa());
        domText.setText(String.valueOf(ogl.getNrDomu()));
        if (ogl.getNrMieszkania() > 0)
            mieszkText.setText(String.valueOf(ogl.getNrMieszkania()));
        else
            mieszkText.setText(brak);
        if (ogl.getPoczta().length() > 0)
            pocztaText.setText(ogl.getPoczta());
        else
            pocztaText.setText(brak);
        
        /* nazwa */
        nazwaText.setText(ogl.getNazwa());
        
        /* data zalozenia */
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(ogl.getDataZalozenia());
        SpinnerNumberModel nsm = (SpinnerNumberModel)rokSpinner.getModel();
        nsm.setValue(new Integer(gc.get(Calendar.YEAR)));
        miesiacComboBox.setSelectedIndex(gc.get(Calendar.MONTH));
        nsm = (SpinnerNumberModel)dzienSpinner.getModel();
        nsm.setValue(new Integer(gc.get(Calendar.DAY_OF_MONTH)));
        
        /* branza */
        branza = ogl.getBranza();
        branzaText.setText(ogl.getBranza().getNazwa());
        
        /* adresy internetowe */
        if (ogl.getStronaInternetowa() != null)
            stronaText.setText(ogl.getStronaInternetowa());
        else
            stronaText.setText(brak);
        
        if (ogl.getEkontakt() != null)
            kontaktText.setText(ogl.getEkontakt());
        else
            kontaktText.setText(brak);
        
        if (ogl.getEmail() != null)
            mailText.setText(ogl.getEmail());
        else
            mailText.setText(brak);
        
        if (ogl.getFax() != null)
            faxText.setText(ogl.getFax());
        else
            faxText.setText(brak);
        
        if (ogl.getPlatne() != null) {
            platneBox.setSelected(true);
            reverse();
            
            /* godziny */
            if (ogl.getPlatne().getGodziny() != null)
                godzinyText.setText(ogl.getPlatne().getGodziny());
            else
                godzinyText.setText(brak);
            
            /* uslugi */
            if (ogl.getPlatne().getUslugi() != null)
                uslugiText.setText(ogl.getPlatne().getUslugi());
            else
                uslugiText.setText(brak);
            
            /* polozenie logo */
            
            switch (ogl.getPlatne().getLogoGdzie()) {
                case PomocnikFirmaUser.LEWO_LOGO:
                    logoGdzieButtonGroup.setSelected(lewoRadio.getModel(), true);
                    break;
                case PomocnikFirmaUser.PRAWO_LOGO:
                    logoGdzieButtonGroup.setSelected(prawoRadio.getModel(), true);
                    break;
                case PomocnikFirmaUser.GORA_LOGO:
                    logoGdzieButtonGroup.setSelected(goraRadio.getModel(), true);
                    break;
                case PomocnikFirmaUser.DOL_LOGO:
                    logoGdzieButtonGroup.setSelected(dolRadio.getModel(), true);
                    break;
            }
            /* logo */
            pobierzWyswietlLogo();
            
            /* slowa kluczowe */
            if (ogl.getPlatne().getSlowoKluczowe1() != null)
                slowoKl1Text.setText(ogl.getPlatne().getSlowoKluczowe1());
            else
                slowoKl1Text.setText(brak);
            
            if (ogl.getPlatne().getSlowoKluczowe2() != null)
                slowoKl2Text.setText(ogl.getPlatne().getSlowoKluczowe2());
            else
                slowoKl2Text.setText(brak);
            
            if (ogl.getPlatne().getSlowoKluczowe3() != null)
                slowoKl3Text.setText(ogl.getPlatne().getSlowoKluczowe3());
            else
                slowoKl3Text.setText(brak);
            
            if (ogl.getPlatne().getSlowoKluczowe4() != null)
                slowoKl4Text.setText(ogl.getPlatne().getSlowoKluczowe4());
            else
                slowoKl4Text.setText(brak);
        } else {
            platneBox.setSelected(false);
            reverse();
        }
        
        /* telefony */
        if (telefony != null && telefony.size() > 0) {
            ArrayList l = (ArrayList)telefony.get(0);
            telefonGlownyText.setText((String)l.get(0));
            telefonGlownyOpisText.setText((String)l.get(1));
            if (ogl.getPlatne() != null) {
                if (telefony.size() > 1) {
                    l = (ArrayList)telefony.get(1);
                    this.telefon1Text.setText((String)l.get(0));
                    this.telefon1OpisText.setText((String)l.get(1));
                }
                if (telefony.size() > 2) {
                    l = (ArrayList)telefony.get(2);
                    this.telefon2Text.setText((String)l.get(0));
                    this.telefon2OpisText.setText((String)l.get(1));
                }
                if (telefony.size() > 3) {
                    l = (ArrayList)telefony.get(3);
                    this.telefon3Text.setText((String)l.get(0));
                    this.telefon3OpisText.setText((String)l.get(1));
                }
                if (telefony.size() > 4) {
                    l = (ArrayList)telefony.get(4);
                    this.telefon4Text.setText((String)l.get(0));
                    this.telefon4OpisText.setText((String)l.get(1));
                }
            }
        }
    }
    
    /**
     * Wyswietla ikone z logo.
     *
     * @param ii Ikona z logo do wywietlenia
     */
    public void wyswietlLogo(ImageIcon ii) {
        try {
            logoPanel.removeAll();
            logoPanel.setLayout(new GridLayout(1, 1));
            JLabel picture = new JLabel();
            picture.setHorizontalAlignment(JLabel.CENTER);
            picture.setAlignmentX(Component.CENTER_ALIGNMENT);
            picture.setIcon(ii);
            logoPanel.invalidate();
            logoPanel.add(picture);
            logoPanel.validate();
            logoPanel.setVisible(true);
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Nie mo\u0017cna wy\u015bwietli\u0107 pliku.");
        }
    }
    
    /**
     * Pobiera i wywietla logo. Jeli pobieranie logo si nie powiedzie (gdy na przykad
     * firma nie umiecia swojego logo na serwerze) to nic si nie dzieje.
     */
    public void pobierzWyswietlLogo() {
        java.net.URL u;
        try {
            String s = konsolaFirmy.komSieciowa.kontaFirm.konstruujHttpSciezkeLogo(konsolaFirmy.ogl.getId());
            u = new java.net.URL(s);
            Image i = konsolaFirmy.getImage(u);
            i.flush();
            ImageIcon ii = new ImageIcon(i);
            wyswietlLogo(ii);
        } catch (Exception e) {
            e.printStackTrace();
            /* nie informujemy, ze sie nie udalo, bo dostajemy
             * wyjatek, jak do ogloszenia po prostu nie jest przypisane
             * zadne logo */
        }
    }
    
    /**
     * Zeruje widok ogoszenia (likwiduje napisy ze wszystkich pl) .
     */
    public void zerujOgloszenie() {
        nipText.setText("");
        hasloText.setText("");
        domText.setText("");
        mieszkText.setText("");
        pocztaText.setText("");
        nazwaText.setText("");
        
        SpinnerNumberModel nsm = (SpinnerNumberModel)rokSpinner.getModel();
        nsm.setValue(new Integer(2000));
        nsm = (SpinnerNumberModel)dzienSpinner.getModel();
        nsm.setValue(new Integer(1));
        miesiacComboBox.setSelectedIndex(0);
        
        branzaText.setText("");
        ulicaText.setText("");
        godzinyText.setText("");
        uslugiText.setText("");
        slowoKl1Text.setText("");
        slowoKl2Text.setText("");
        slowoKl3Text.setText("");
        slowoKl4Text.setText("");
        telefon1Text.setText("");
        telefon2Text.setText("");
        telefon3Text.setText("");
        telefon4Text.setText("");
        telefon1OpisText.setText("");
        telefon2OpisText.setText("");
        telefon3OpisText.setText("");
        telefon4OpisText.setText("");
        platneBox.setSelected(false);
        reverse();
        stronaText.setText("");
        kontaktText.setText("");
        mailText.setText("");
        telefonGlownyText.setText("");
        faxText.setText("");
        telefonGlownyOpisText.setText("");
        konsolaFirmy.pg = null;
        logoPanel.invalidate();
        logoPanel.removeAll();
        logoPanel.validate();
        
        konsolaFirmy.konstrOgl = null;
        konsolaFirmy.konstrTelefony = null;
    }
    
    /**
     * Wypisuje biece parametry ogoszenia (takie jakie s w bazie danych,
     * bez uwzgldniania ewentualnych zmian, ktre wykona uytkownik).
     */
    public void resetujkOgloszenie() {
        pokazOgloszenie();
    }
    
    /**
     * Zapamituje wybran przez uytkownika bran.
     *
     * @param b Wybrana brana
     */
    public void setBranza(Branza b) {
        branza = b;
        if (b != null)
            branzaText.setText(b.getNazwa());
    }
    
}