/*
 * WidokPowitania.java
 *
 * Created on 3 maj 2004, 11:47
 */

package firma;

import java.util.GregorianCalendar;
import java.util.Calendar;

/**
 * Wywietla widok powitalny, po zalogowaniu si firmy. Na widoku znajduj si:
 * <UL>
 *  <LI>Przywitanie uytkownika.
 *  <LI>Informacja o tym, e logowanie si powiodo.
 *  <LI>Informacja o upywie terminu aktualizacji ogoszenia.
 *   Ponadto, jeli termin upywa w cigu dwch tygodnie, zostanie
 *   wywietlony czerwony napis "Uwaga!".
 * </UL>
 *
 * @author  ek197882
 */
public class WidokPowitania extends javax.swing.JPanel {
    
    /** Konsola firmy, na ktrej jest wywietlony ten widok. */
    private KonsolaFirmy konsolaFirmy;
    
    /**
     * Konstruktor.
     *
     * @param kons Konsola, na ktrej wywietlany jest widok
     */
    public WidokPowitania(KonsolaFirmy kons) {
        initComponents();
        konsolaFirmy = kons;
        pokazTerminAktualizacji();
    }
     
    /** Wywietla informacje dotyczce terminu aktualizacji ogoszenia. */
    public void pokazTerminAktualizacji() {
        try {
            GregorianCalendar data_aktualizacji = new GregorianCalendar();
            GregorianCalendar data_przypomnienia = new GregorianCalendar();
            data_aktualizacji.setLenient(true);
            data_przypomnienia.setLenient(true);
            data_aktualizacji.setTime(konsolaFirmy.ogl.getDataAktualizacji());
            data_aktualizacji.add(Calendar.YEAR, 1);
            data_przypomnienia.add(Calendar.DAY_OF_YEAR, 14);
            if (data_aktualizacji.before(data_przypomnienia))
                uwagaLabel.setText("<html><font color=red>Uwaga!</font><font color=black> Dnia:");
            else
                uwagaLabel.setText("Dnia: ");
            dniaLabel.setText("<html><font color=blue><u>" + data_aktualizacji.get(Calendar.YEAR) + "-"
            + new Integer(data_aktualizacji.get(Calendar.MONTH) + 1) + "-" + data_aktualizacji.get(Calendar.DAY_OF_MONTH)
            + "</u></font></html>");
            uplywaLabel.setText("upywa termin aktualizacji ogoszenia!");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        logowanieOKLabel = new javax.swing.JLabel();
        dostep1Label = new javax.swing.JLabel();
        dostep2Label = new javax.swing.JLabel();
        uwagaLabel = new javax.swing.JLabel();
        dniaLabel = new javax.swing.JLabel();
        uplywaLabel = new javax.swing.JLabel();
        witamyLabel = new javax.swing.JFormattedTextField();

        setLayout(null);

        logowanieOKLabel.setText("Logowanie powiod\u0142o si\u0119.");
        logowanieOKLabel.setFocusable(false);
        add(logowanieOKLabel);
        logowanieOKLabel.setBounds(30, 80, 156, 15);

        dostep1Label.setText("Masz teraz dost\u0119p do cz\u0119\u015bci systemu");
        dostep1Label.setFocusable(false);
        add(dostep1Label);
        dostep1Label.setBounds(30, 110, 270, 15);

        dostep2Label.setText("umo\u017cliwiaj\u0105cej zarz\u0105dzanie kontem.");
        dostep2Label.setFocusable(false);
        add(dostep2Label);
        dostep2Label.setBounds(30, 130, 260, 15);

        uwagaLabel.setText(" ");
        uwagaLabel.setFocusable(false);
        add(uwagaLabel);
        uwagaLabel.setBounds(30, 180, 230, 15);

        dniaLabel.setText(" ");
        add(dniaLabel);
        dniaLabel.setBounds(50, 200, 380, 15);

        uplywaLabel.setText(" ");
        add(uplywaLabel);
        uplywaLabel.setBounds(30, 220, 390, 15);

        witamyLabel.setBackground(new java.awt.Color(153, 153, 255));
        witamyLabel.setEditable(false);
        witamyLabel.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        witamyLabel.setText("Witamy w systemie NIIKT");
        witamyLabel.setFocusable(false);
        witamyLabel.setFont(new java.awt.Font("Dialog", 1, 12));
        add(witamyLabel);
        witamyLabel.setBounds(30, 30, 230, 19);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel dniaLabel;
    private javax.swing.JLabel dostep1Label;
    private javax.swing.JLabel dostep2Label;
    private javax.swing.JLabel logowanieOKLabel;
    private javax.swing.JLabel uplywaLabel;
    private javax.swing.JLabel uwagaLabel;
    private javax.swing.JFormattedTextField witamyLabel;
    // End of variables declaration//GEN-END:variables
    
}
