/*
 * WidokStatusu.java
 *
 * Created on 27 maj 2004, 17:35
 */

package firma;

import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * Wywietla ekran umoliwiajcy obejrzenie statusu ogoszenia.
 * @author  ek197882
 */
public class WidokStatusu extends javax.swing.JPanel {
    
    /** Status: zaakceptowane. */
    public String ZAAKCEPTOWANE_INFO = "zaakceptowane";
    
    /** Status: niezaakceptowane. */
    public String NIE_ZAAKCEPTOWANE_INFO = "jeszcze nie zaakceptowane";
    
    /** Konsola, na ktrej jest wywietlony panel. */
    private KonsolaFirmy konsolaFirmy;
    
    /** Konstruktor.
     *
     * @param kons Konsola firmy, na ktrej zostanie wywietlony panel.
     */
    public WidokStatusu(KonsolaFirmy kons) {
        initComponents();
        konsolaFirmy = kons;
        pokazStatus();
    }
    
    /** Wywietla status. */
    public void pokazStatus() {
        
        /* ustawienie zaakceptowanego */
        if (konsolaFirmy.ogl.isZaakceptowane())
            statusText.setText(ZAAKCEPTOWANE_INFO);
        else
            statusText.setText(NIE_ZAAKCEPTOWANE_INFO);
        
        /* ustawienie daty aktualizacji */
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(konsolaFirmy.ogl.getDataAktualizacji());
        dataAktualizacjiText.setText(gc.get(Calendar.YEAR) + "-" + (gc.get(Calendar.MONTH) + 1)
        + "-" + gc.get(Calendar.DAY_OF_MONTH));
        
        /* ustawienie daty opaty */
        if (konsolaFirmy.ogl.getPlatne() != null) {
            dataOplaceniaText.setEnabled(true);
            dataOplaceniaLabel.setEnabled(true);
            gc.setTime(konsolaFirmy.ogl.getPlatne().getDataOplacenia());
            dataOplaceniaText.setText(gc.get(Calendar.YEAR) + "-" + (gc.get(Calendar.MONTH) + 1)
            + "-" + gc.get(Calendar.DAY_OF_MONTH));
        } else {
            dataOplaceniaText.setText("");
            dataOplaceniaText.setEnabled(false);
            dataOplaceniaLabel.setEnabled(false);
        }
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        statusText = new javax.swing.JTextField();
        dataAktualizacjiText = new javax.swing.JTextField();
        dataOplaceniaText = new javax.swing.JTextField();
        statusLabel = new javax.swing.JFormattedTextField();
        dataAktualizacjiLabel = new javax.swing.JLabel();
        dataOplaceniaLabel = new javax.swing.JLabel();

        setLayout(null);

        statusText.setEditable(false);
        add(statusText);
        statusText.setBounds(30, 70, 190, 19);

        dataAktualizacjiText.setEditable(false);
        add(dataAktualizacjiText);
        dataAktualizacjiText.setBounds(30, 130, 190, 19);

        dataOplaceniaText.setEditable(false);
        add(dataOplaceniaText);
        dataOplaceniaText.setBounds(30, 190, 190, 19);

        statusLabel.setBackground(new java.awt.Color(102, 102, 255));
        statusLabel.setBorder(null);
        statusLabel.setEditable(false);
        statusLabel.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        statusLabel.setText("Status og\u0142oszenia");
        statusLabel.setFont(new java.awt.Font("Dialog", 1, 12));
        add(statusLabel);
        statusLabel.setBounds(30, 30, 130, 20);

        dataAktualizacjiLabel.setText("Data ostatniej aktualizacji");
        add(dataAktualizacjiLabel);
        dataAktualizacjiLabel.setBounds(30, 110, 163, 15);

        dataOplaceniaLabel.setText("Data op\u0142acenia");
        add(dataOplaceniaLabel);
        dataOplaceniaLabel.setBounds(30, 170, 92, 15);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel dataAktualizacjiLabel;
    private javax.swing.JTextField dataAktualizacjiText;
    private javax.swing.JLabel dataOplaceniaLabel;
    private javax.swing.JTextField dataOplaceniaText;
    private javax.swing.JFormattedTextField statusLabel;
    private javax.swing.JTextField statusText;
    // End of variables declaration//GEN-END:variables
    
}
