/*
 * WidokStatystyk.java
 *
 * Created on 27 kwiecie 2004, 00:09
 */

package firma;

/**
 * Wywietla ekran umoliwiajcy obejrzenie statystyk dotyczcych ogoszenia.
 *
 * @author  ek197882
 */
public class WidokStatystyk extends javax.swing.JPanel {
    
    /**
     * Konsola firmy, na ktorej panel jest wywietlony.
     */
    KonsolaFirmy konsolaFirmy;
    
    /**
     * Konstruktor.
     *
     * @param kons konsola firmy, do ktrej przyczony jest widok
     */
    public WidokStatystyk(KonsolaFirmy kons) {
        konsolaFirmy = kons;
        initComponents();
        pokazStatystyki();
    }
 
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        biezacaLabel = new javax.swing.JLabel();
        poprzLabel = new javax.swing.JLabel();
        poprzedniaText = new javax.swing.JTextField();
        biezacaText = new javax.swing.JTextField();
        statystykiLabel = new javax.swing.JFormattedTextField();

        setLayout(null);

        biezacaLabel.setText("Bie\u017c\u0105ca");
        add(biezacaLabel);
        biezacaLabel.setBounds(30, 80, 46, 15);

        poprzLabel.setText("Z poprzedniego miesi\u0105ca");
        add(poprzLabel);
        poprzLabel.setBounds(30, 110, 156, 15);

        poprzedniaText.setEditable(false);
        add(poprzedniaText);
        poprzedniaText.setBounds(200, 110, 100, 19);

        biezacaText.setEditable(false);
        add(biezacaText);
        biezacaText.setBounds(200, 80, 100, 19);

        statystykiLabel.setBackground(new java.awt.Color(102, 102, 255));
        statystykiLabel.setBorder(null);
        statystykiLabel.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        statystykiLabel.setText("Statystyki");
        statystykiLabel.setFocusCycleRoot(true);
        statystykiLabel.setFocusable(false);
        statystykiLabel.setFont(new java.awt.Font("Dialog", 1, 12));
        add(statystykiLabel);
        statystykiLabel.setBounds(30, 30, 130, 20);

    }//GEN-END:initComponents
    
    /** Wywietla statystyki. */
    public void pokazStatystyki() {
        biezacaText.setText(String.valueOf(new Integer(konsolaFirmy.ogl.getPopularnosc())));
        poprzedniaText.setText(String.valueOf(new Integer(konsolaFirmy.ogl.getPopularnoscPoprz())));
    }
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel biezacaLabel;
    private javax.swing.JTextField biezacaText;
    private javax.swing.JLabel poprzLabel;
    private javax.swing.JTextField poprzedniaText;
    private javax.swing.JFormattedTextField statystykiLabel;
    // End of variables declaration//GEN-END:variables
    
}
