/*
 * WidokZarzadzaniaOgloszeniem.java
 *
 * Created on 27 kwiecie 2004, 01:07
 */

package firma;

import javax.swing.*;
import java.awt.*;
import java.rmi.RemoteException;
import shared.*;
import java.util.ArrayList;

/**
 * Wywietla widok umoliwiajcy edycj istniejcego ogoszenia.
 *
 * @author  ek197882
 */
public class WidokZarzadzaniaOgloszeniem extends javax.swing.JPanel {
    
    /**
     * Konsola firmy, na kt?rej panel jest wywietlony.
     */
    KonsolaFirmy konsolaFirmy;
    
    /**
     * Konstruktor.
     * @param kons konsola firmy, do ktrej przyczony jest widok
     */
    public WidokZarzadzaniaOgloszeniem(KonsolaFirmy kons) {
        konsolaFirmy = kons;
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        zatwierdZmianyButton = new javax.swing.JButton();
        potwierdzAktualnoscButton = new javax.swing.JButton();
        resetujPolaButton = new javax.swing.JButton();
        anulujButton = new javax.swing.JButton();

        setLayout(new java.awt.GridLayout(1, 0));

        zatwierdZmianyButton.setBackground(new java.awt.Color(153, 153, 255));
        zatwierdZmianyButton.setText("Zatwierd\u017a zmiany");
        zatwierdZmianyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zatwierdZmianyButtonActionPerformed(evt);
            }
        });

        add(zatwierdZmianyButton);

        potwierdzAktualnoscButton.setBackground(new java.awt.Color(153, 153, 255));
        potwierdzAktualnoscButton.setText("Uaktualnij");
        potwierdzAktualnoscButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                potwierdzAktualnoscButtonActionPerformed(evt);
            }
        });

        add(potwierdzAktualnoscButton);

        resetujPolaButton.setBackground(new java.awt.Color(153, 153, 255));
        resetujPolaButton.setText("Resetuj pola");
        resetujPolaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetujPolaButtonActionPerformed(evt);
            }
        });

        add(resetujPolaButton);

        anulujButton.setBackground(new java.awt.Color(153, 153, 255));
        anulujButton.setText("Zako\u0144cz edycj\u0119");
        anulujButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                anulujButtonActionPerformed(evt);
            }
        });

        add(anulujButton);

    }//GEN-END:initComponents
    
    private void potwierdzAktualnoscButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_potwierdzAktualnoscButtonActionPerformed
        try {
            konsolaFirmy.komSieciowa.ogloszenia.potwierdzAktualnosc(konsolaFirmy.ogl);
            JOptionPane.showMessageDialog(this, "Aktualno\u015b\u0107 potwierdzona.",
            "Informacja", JOptionPane.INFORMATION_MESSAGE);
            konsolaFirmy.ogl.setDataAktualizacji(new java.util.Date());
        } catch (Wyjatek w) {
            JOptionPane.showMessageDialog(this, "Potwierdzenie aktualno\u015bci" +
            " nie powiod\u0142o si\u0119.", "B\u0142\u0105d", JOptionPane.WARNING_MESSAGE);
        } catch (RemoteException re) {
            re.printStackTrace();
        }
        konsolaFirmy.uaktualnijWidoki();
    }//GEN-LAST:event_potwierdzAktualnoscButtonActionPerformed
    
    /**
     * Akcja wykonywana po klikniciu przycisku "Anuluj".
     * Przekazuje zlecenie anulowania edycji do konsoli firmy.
     *
     * @param evt Zdarzenie nacinicia przycisku "Anuluj"
     * @see KonsolaFirmy
     */
    private void anulujButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_anulujButtonActionPerformed
        konsolaFirmy.usunWidokOgloszenia();
        konsolaFirmy.konstrOgl = null;
        konsolaFirmy.konstrTelefony = null;
        konsolaFirmy.pg = null;
    }//GEN-LAST:event_anulujButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu guzika "Resetuj".
     * Wywietla pola z danymi jakie s w bazie.
     *
     * @param evt Zdarzenie nacinicia przycisku "Resetuj"
     */
    private void resetujPolaButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetujPolaButtonActionPerformed
        WidokOgloszenia wo = (WidokOgloszenia)konsolaFirmy.oframe.getContentPane().getComponent(0);
        wo.resetujkOgloszenie();
        konsolaFirmy.konstrOgl = null;
        konsolaFirmy.konstrTelefony = null;
        konsolaFirmy.pg = null;
    }//GEN-LAST:event_resetujPolaButtonActionPerformed
    
    /**
     * Akcja wykonywana po wciniciu przycisku "Zatwierd zmiany".
     * Zleca konstrukcj ogoszenia z wpisanych przez uytkownika danych,
     * jeli si ona powiedzie zleca wstawienie nowej wersji ogloszenia do
     * bazy danych.
     *
     * @param evt Zdarzenie wcinicia przycisku "Aktualizuj"
     * @see KonsolaFirmy
     */
    private void zatwierdZmianyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zatwierdZmianyButtonActionPerformed
        /* skonstruuj ogloszenie */
        WidokOgloszenia wo = (WidokOgloszenia)konsolaFirmy.oframe.getContentPane().getComponent(0);
        wo.konstruujOgloszenie();
        if (konsolaFirmy.konstrOgl == null) return;
        
        /* probuj wstawic ogloszenie do bazy */
        try {
            String errmsg = konsolaFirmy.komSieciowa.kontaFirm.modyfikujOgloszenie(konsolaFirmy.konstrOgl, konsolaFirmy.konstrTelefony);
            if (errmsg.compareTo("OK") != 0) {
                JOptionPane.showMessageDialog(this, errmsg, "Uwaga!", JOptionPane.ERROR_MESSAGE);
                return;
            }
        } catch (Wyjatek w) {
            JOptionPane.showMessageDialog(this, "Aktualizacja si\u0119 nie powiod\u0142a.\n" +
            "Upewnij si\u0119, czy dane s\u0105 poprawnie wprowadzone.", "Uwaga!", JOptionPane.WARNING_MESSAGE);
            return;
        } catch (RemoteException re) {
            re.printStackTrace();
            return;
        }
        
        /* probuj wstawic logo do bazy jesli zostalo zmienione */
        if ((konsolaFirmy.pg != null) && (konsolaFirmy.konstrOgl.getPlatne() != null))
            /* nadpisywanie logo (niezaleznie od tego, czy byo ju czy nie wstawione wczeniej) */
            try {
                PlikGraficzny pg = konsolaFirmy.pg;
                konsolaFirmy.komSieciowa.kontaFirm.zapiszLogoFirmy(konsolaFirmy.ogl.getId(), pg);
                konsolaFirmy.pg = null;
                JOptionPane.showMessageDialog(this, "Og\u0142oszenie zaktualizowano. Logo zapisano.", "Informacja",
                JOptionPane.INFORMATION_MESSAGE);
            } catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Og\u0142oszenie zaktualizowane, "
                + "ale nie uda\u0142o si\u0119 wczyta\u0107 pliku logo.\n"
                + "Logo nie zosta\u0142o zapisane.", "Informacja.", JOptionPane.ERROR_MESSAGE);
            }
        else
            JOptionPane.showMessageDialog(this, "Og\u0142oszenie zaktualizowano.", "Informacja",
            JOptionPane.INFORMATION_MESSAGE);
        
        /* w przypadku zmiany platne => bezplatne trzeba usunac logo */
        if ((konsolaFirmy.ogl.getPlatne() != null) && (konsolaFirmy.konstrOgl.getPlatne() == null))
            try{
                konsolaFirmy.komSieciowa.kontaFirm.usunLogo(konsolaFirmy.ogl.getId());
            } catch (Exception e) {
                e.printStackTrace();
            }
        
        /* pobierz aktualna wersje ogkloszenia i telefonow z serwera */
        wczytajOgloszenie();
        konsolaFirmy.uaktualnijWidoki();
    }//GEN-LAST:event_zatwierdZmianyButtonActionPerformed
    
    /**
     * Wczytuje aktualn wersj ogoszenia zalogowanej firmy.
     */
    public void wczytajOgloszenie() {
        try {
            Ogloszenie o = konsolaFirmy.komSieciowa.kontaFirm.pobierzOgloszenie(konsolaFirmy.ogl.getId());
            ArrayList ts = konsolaFirmy.komSieciowa.kontaFirm.pobierzTelefony(konsolaFirmy.ogl.getId());
            
            konsolaFirmy.ogl = o;
            konsolaFirmy.telefony = ts;
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Nie uda\u0142 sie\u0119 pobra\u0105 og\u0142oszenia.",
            "B\u0142\u0105d!", JOptionPane.ERROR_MESSAGE);
        }
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton anulujButton;
    private javax.swing.JButton potwierdzAktualnoscButton;
    private javax.swing.JButton resetujPolaButton;
    private javax.swing.JButton zatwierdZmianyButton;
    // End of variables declaration//GEN-END:variables
}
