/*
 * WidokZmianyHasla.java
 *
 * Created on 26 kwiecie 2004, 23:48
 */

package firma;

import javax.swing.*;
import java.rmi.RemoteException;
import shared.*;
import komponenty.JPasswordFieldPolski;

/**
 * Wywietla ekran umoliwiajcy zmian hasa zalogowanej firmy.
 *
 * @author  ek197882
 */
public class WidokZmianyHasla extends javax.swing.JPanel {
    
    /**
     * Konsola firmy, na ktrej panel jest wywietlony.
     */
    KonsolaFirmy konsolaFirmy;
    
    /**
     * Konstruktor.
     *
     * @param kons konsola firmy, do ktrej przyczony jest widok
     */
    public WidokZmianyHasla(KonsolaFirmy kons) {
        konsolaFirmy = kons;
        initComponents();
        myInitComponents();
    }
    
    private void myInitComponents() {
        hasloText = new komponenty.JPasswordFieldPolski();
        powtorzText = new komponenty.JPasswordFieldPolski();
        add(hasloText);
        hasloText.setBounds(160, 80, 150, 19);

        add(powtorzText);
        powtorzText.setBounds(160, 110, 150, 19);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        hasloLabel = new javax.swing.JLabel();
        powtorzLabel = new javax.swing.JLabel();
        zmienHasloButton = new javax.swing.JButton();
        noweHasloLabel = new javax.swing.JFormattedTextField();

        setLayout(null);

        hasloLabel.setText("Nowe has\u0142o");
        add(hasloLabel);
        hasloLabel.setBounds(30, 80, 73, 15);

        powtorzLabel.setText("Powt\u00f3rz nowe has\u0142o");
        add(powtorzLabel);
        powtorzLabel.setBounds(30, 110, 127, 15);

        zmienHasloButton.setText("Zmie\u0144 has\u0142o");
        zmienHasloButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zmienHasloButtonActionPerformed(evt);
            }
        });

        add(zmienHasloButton);
        zmienHasloButton.setBounds(160, 140, 150, 40);

        noweHasloLabel.setBackground(new java.awt.Color(102, 102, 255));
        noweHasloLabel.setBorder(null);
        noweHasloLabel.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        noweHasloLabel.setText("Nowe has\u0142o");
        noweHasloLabel.setFocusCycleRoot(true);
        noweHasloLabel.setFocusable(false);
        noweHasloLabel.setFont(new java.awt.Font("Dialog", 1, 12));
        add(noweHasloLabel);
        noweHasloLabel.setBounds(30, 30, 130, 20);

    }//GEN-END:initComponents
    
    /**
     * Akcja wykonywana po wciniciu przycisku "Zmie haso".
     * Sprawdza czy haso zostao wprowadzone tak samo w obie rubryki
     * z nowym hasem.
     *
     * @param evt Zdarzenie wcinicia przycisku "Zmie haso"
     */
    private void zmienHasloButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zmienHasloButtonActionPerformed
        
        String haslo1 = hasloText.getPasswordString();
        String haslo2 = powtorzText.getPasswordString();
        
        if ((haslo1.length() == 0) || (haslo2.length() == 0))
            JOptionPane.showMessageDialog(this, "Nie zapomnij wprowadzi\u0107 has\u0142a.", "Uwaga!",
            JOptionPane.WARNING_MESSAGE);
        else if (haslo1.compareTo(haslo2) != 0)
            JOptionPane.showMessageDialog(this, "Upewnij si\u0119, " +
            " czy wprowadzi\u0142e\u015b dwukrotnie to samo has\u0142o.", "Uwaga!",
            JOptionPane.WARNING_MESSAGE);
        else {
            boolean czyZmieniono = false;
            try {
                konsolaFirmy.komSieciowa.kontaFirm.zmienHaslo(konsolaFirmy.ogl.getId(), haslo1);
                czyZmieniono = true;
            } catch (Wyjatek e) {
                JOptionPane.showMessageDialog(this, "Has\u0142o nie zosta\u0142o zmienione.\n" +
                "Upewnij si\u0119, czy dobrze wprowadzi\u0142e\u015b oba has\u0142a.", "Uwaga!",
                JOptionPane.WARNING_MESSAGE);
            }catch (RemoteException re) {
                re.printStackTrace();
            }
            if (czyZmieniono) {
                JOptionPane.showMessageDialog(this, "Has\u0142o zosta\u0142o zmienione.", "Informacja",
                JOptionPane.INFORMATION_MESSAGE);
                konsolaFirmy.ogl.setHaslo(haslo1);
            } else
                JOptionPane.showMessageDialog(this, "Has\u0142o nie zosta\u0142o zmienione.\n" +
                "Upewnij si\u0119, czy dobrze wprowadzi\u0142es oba has\u0142a.", "Uwaga!",
                JOptionPane.WARNING_MESSAGE);
        }
    }//GEN-LAST:event_zmienHasloButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel hasloLabel;
    private javax.swing.JFormattedTextField noweHasloLabel;
    private javax.swing.JLabel powtorzLabel;
    private javax.swing.JButton zmienHasloButton;
    // End of variables declaration//GEN-END:variables
    private komponenty.JPasswordFieldPolski hasloText;
    private komponenty.JPasswordFieldPolski powtorzText;
    
}
