/*
 * BranzaWybor.java
 *
 * Created on 4 maj 2004, 16:06
 */

package komponenty;

import shared.branze.*;
import shared.Branza;

import javax.swing.JTree;
import javax.swing.tree.*;
import javax.swing.tree.TreePath;
import javax.swing.JTree;

/**
 * Okno umoliwiajce uytkownikowi wybr Brany
 * z Katalogu Najpopularniejszych Bran
 * @author  witus
 * @version %I% %G%
 */
public class BranzaWybor extends javax.swing.JPanel {
    private KatTreeNode mojModel;
    
    /** Tworzy nowy obiekt klasy BranzaWybor 
     * @param drzewoBranz Drzewo Bran, ktre bdzie wywietlane w oknie
     */
    public BranzaWybor(KatalogBranzDrzewo drzewoBranz) {
        initComponents();
        mojModel = drzewoBranz.dajModel();
        jTree1 = new JTree(mojModel);
        jTree1.getSelectionModel().setSelectionMode
            (TreeSelectionModel.SINGLE_TREE_SELECTION);
        jScrollPane1.setViewportView(jTree1);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();

        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setViewportView(jTree1);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTree jTree1;
    // End of variables declaration//GEN-END:variables
    /**
     * Dostp do wybranej przez uytkownika Brany
     * @return Wybrana przez uytkownika Brana
     */
    public Branza wybor() {
        KatTreeNode parentNode = null;
        TreePath parentPath = jTree1.getSelectionPath();
        
        if (parentPath == null) {
            /* Nic nie wybrano, zwracam Bran podczepion do gwnego wza */
            /* Chyba, e wolicie ebym zwraca wyjtek albo nulla (dajcie zna) */
            parentNode = mojModel;
        } else {
            /* Ustalam ktra pozycja w drzewie jest zaznaczone jest zaznaczona */
            parentNode = (KatTreeNode)
                         (parentPath.getLastPathComponent());
        }
        /* Zwracam Bran zwizan z zaznaczon pozycj */
        return ((EltKatBranz) parentNode.getUserObject()).getBranza();
    }
}
