/*
 * JPasswordFieldPolski.java
 *
 * Created on 21 sierpie 2004, 14:27
 */

package komponenty;

/**
 * Umoliwia wprowadzanie i poprawne odczytanie "wygwiazdkowanego" hasa
 * zawierajcego polskie litery. Zapewnia:
 * <ul>
 *  <li>poprawne wprowadzanie nastpujcych znakw:
 *      <ul>
 *          <li>liter - alfabetu polskiego
 *          <li>cyfr - take z klawiatury "NumLock"
 *          <li>znakw interpunkcyjnych, przestankowych, itd. (lecz
 *              nie mona wprowadzi tabulatora)
 *      </ul>
 *  <li>brak reakcji na znaki sterujce (np. klawisze F1-F12)
 *  <li>interfejs do pobrania hasa jako napis (String)
 * </ul>
 *
 * <p><i>Uwaga</i>: Klasa nie gwarantuje poprawnego dziaania
 * dla hase zawierajcych znaki z innych alfabetw ni polski.
 *
 * @author  ek197882
 * @see <a href="http://www.cs.mun.ca/~michael/java/jdk1.2-docs/api/javax/swing/JPasswordField.html" target="_blank">javax.swing.JPasswordField</a>
 */
public class JPasswordFieldPolski extends javax.swing.JPasswordField {
    
    boolean czyLinux;

    /** Konstruktor. */
    public JPasswordFieldPolski() {
        super();
        
        String systemOp = System.getProperty("os.name");
        /* Szczliwie nawet aplet ma pozwolestwo na odczyt wasnoci os.name */
        
        czyLinux = (systemOp.equals("Linux"));
        
    }
    
    /**
     * Metoda zablokowana, nic nie robi.
     *
     * @return null
     * @see #setPassword
     * @see <a href="http://www.cs.mun.ca/~michael/java/jdk1.2-docs/api/javax/swing/JPasswordField.html#getPassword()" target="_blank">javax.swing.JPasswordField.getPassword()</a>
     */
    public char[] getPassword() {
        
        /* Nie uywaj tej metody. Dzikuj :). */
        return null;
    }
    
    /**
     * Zwraca napis zawierajcy haso.
     *
     * @return napis, zawierajcy haso, z poprawnymi polskimi znakami
     * @see #setPassword
     */
    public String getPasswordString() {
        if (!czyLinux)
            return new String(super.getPassword());
        
        char[] oryginalne = super.getPassword();
        int dl = oryginalne.length;
        
        byte[] nowe = new byte[dl];
        
        // System.out.print("getPassword ==>");
        
        for (int i = 0; i < dl; i++) {
            nowe[i] = (byte)(oryginalne[i]);
            // System.out.print(nowe[i]+" ("+ (int)oryginalne[i]+")");
        }
        // System.out.println("<==");
        
        return new String(nowe);
        
    }
    
    /**
     * Ustawia haso.
     *
     * @param haslo Haso, ktre bdzie wpisane ('wygwiazdkowane').
     * @see #getPassword
     */
    public void setPassword(String haslo) {
        
        if (!czyLinux) {
            super.setText(haslo);
            return;
        }
        
        String hasloOK = null;
        try {
            byte[] bajty = haslo.getBytes("ISO-8859-2");
            int dl = bajty.length;
            
            byte[] bajtowe = new byte[2 * dl];
            for (int i = 0; i < dl; i++) {
                bajtowe[2 * i] = (byte)0;
                bajtowe[2 * i + 1] = (byte)(bajty[i]);
            }
            
            // System.out.print("Dostalem ISO ==>"); for (int u=0; u<dl; u++) System.out.print(bajty[u]+" "); System.out.println("<==");
            // System.out.print("Zrobilem     ==>"); for (int u=0; u<dl*2; u++) System.out.print(bajtowe[u]+" "); System.out.println("<==");
            
            hasloOK = new String(bajtowe, "UTF-16");
            
            
        } catch (Exception e) {
            // e.printStackTrace();
            hasloOK = haslo;
        }
        super.setText(hasloOK);
        
    }
    
    /**
     * Ustawia haso. Alias do {@link JPasswordFieldPolski#setPassword}.
     *
     * @param haslo Haso, ktre bdzie wpisane ('wygwiazdkowane').
     * @see #setText
     */
    public void setText(String haslo) {
        setPassword(haslo);
    }
    
    
}