/*
 * MapaKomSieciowa.java
 *
 * Created on 23 kwiecie 2004, 17:49
 */

package komponenty;

import shared.*;
import java.awt.Point;

/** Interfejs komunikacji sieciowej, zawierajcej metody obsugi mapy.
 *
 * @author  me201258
 */
public interface MapaKomSieciowa {
    
    /** Pobiera z serwera warstwy mapy. 
     */
    public void pobierzWarstwy();
    
    /** Pobiera z serwera fragmenty mapy, ktre pozwalaj przedstawi zadany punkt.
     *  @param w warstwa mapy
     *  @param ile pierwiastek liczby potrzebnych fragmentw (bok kwadratu)
     *  @param pkt punkt, ktry ma by widoczny na rodku zestawu
     */
    public void pobierzFragmenty(final WarstwaMapy w, final int ile, final Point pkt);
    
    /** Znajduje ulic (lub ulice) o  podanej nazwie.
     *  @param nazwa szukana nazwa ulicy
     */
    public void znajdzUlice(final String nazwa);
    
    /** Znajduje fragmenty podanej ulicy.
     *  @param ul ulica
     */
    public void znajdzFragmentyUlicy(final Ulica ul);
}
