/*
 * NawigacjaMapa.java
 *
 * Created on 23 kwiecie 2004, 17:31
 */

package komponenty;

import shared.*;
import java.util.List;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.net.*;
import java.awt.image.*;

/** Abstrakcyjna klasa reprezentujca panel nawigacji po mapie.
 *  Jej podklasy implementuj specyficzn dla danego interfejsu obsug mapy.
 *
 * @author  me201258
 */
public abstract class NawigacjaMapa extends JPanel {
    /** Zarejestrowane w systemie warstwy mapy. */
    protected WarstwaMapy[] warstwy = null;
    /** Aktualnie wywietlana warstwa mapy. */
    protected WarstwaMapy biezacaWarstwa = null;
    /** Identyfikator aktualnie wywietlanej warstwy mapy. */
    protected int biezacaWarstwaId = -1;
    /** Pobrane z serwera fragmenty mapy, aktualnie wywietlane. Tablica indeksowana jest 
     *  liczbami od 0 do ileFragmentow*ileFragmentow i odpowiada indeksom pl w wywietlanej
     *  siatce fragmentw mapy. Jeli pod jakim polem w tej tablice znajduje si null,
     *  oznacza to, i w systemie nie istnieje jeszcze fragment mapy, ktry powienien 
     *  by wywietlany w tym miejscu.
     */
    protected FragmentMapy[] fragmenty = null;
    /** zmienna okrela ile fragmentw mapy powinno zosta wywietlonych w jednym wierszu 
     *  (tyle samo wywietli si w jednej kolumnie). W sumie wywietlanych fragmentw: 
     *  ileFragmentow^2.
     */
    protected int ileFragmentow = 3;
    /** Bezwzgldne wsprzdne centralnego punktu w biecym widoku mapy. Na pocztku centralnym
      * punktem jest - zgodnie z umow - punkt (0,0).
      */
    protected Point centralnyPkt = new Point(0,0);
    /** Wzgldne wsprzdne lewego grnego punktu na mapie. */
    protected Point lewyGornyPkt = null;
    /** Liczba istniejcych fragmentw mapy w aktualnie wywietlanym zestawie. */
    protected int ileAktywnychFragmentow = 0;
    /** Waciwy obiekt komunikacji sieciowej, potraficy realizowa zlecenia map. */
    protected MapaKomSieciowa mKomSieciowa;
    /** Czy nastpia zmiana warstwy.*/
    protected boolean czyZmianaWarstwy = true;
    /** Kopia napisu z szukan ulic.*/
    protected String szukanaUlica = "";
    /** Zapamitana bieca wybrana ulica. */
    protected Ulica biezacaUlica;
    /** Fragmenty wybranej ulicy.*/
    protected FragmentUlicy[] frUlicy;
    private javax.swing.event.ChangeListener skalaSliderChangeListener = new javax.swing.event.ChangeListener() {
                public void stateChanged(javax.swing.event.ChangeEvent evt) {
                    skalaSliderStateChanged(evt);
                }
            };
    /** Adres serwera, ustalany w rny, zaleny od tego, czy jeste w aplikacji czy aplecie, sposb. */
    private String adresSerwera;

    /** Obiekty obrazkw fragmentw mapy aktualnie znajdujcych si na ekranie. */
    protected Image[] obrazkiFrMapy;
    
    /** Tworzy nowy obiekt NawigacjaMapa. */
    public NawigacjaMapa() {
        initComponents();
    }

    /** Inicjalizuje widok mapy, pobierajc z serwera wszystkie potrzebne informacje. 
     *  @param mKomSieciowa obiekt komunikacji sieciowej
     *  @param adresSerwera adres http serwera
     */
    public void initWidok(MapaKomSieciowa mKomSieciowa, String adresSerwera) {
        this.mKomSieciowa = mKomSieciowa;
        this.adresSerwera = adresSerwera;
        mKomSieciowa.pobierzWarstwy();
    }
    
    /** Metoda reagujca na pojawienie si warstw. */
    protected void saWarstwy() {};

    /** Metoda reagujca na brak warstw. */
    protected void niemaWarstw() {};
    
    /** Przyjmuje zestaw warstw. Metoda powinna by wywoywana w czasie inicjalizacji widoku
     *  lub po zmianach dokonanych w licie warstw. 
     *  @param w odbierane warstwy mapy
     */
    public synchronized void odbierzWarstwy(WarstwaMapy[] w) {
        int i, j = -1, ov;

        warstwy = w;
        if (w.length > 0) { //mamy jakie warstwy na serwerze
            if (biezacaWarstwaId != -1) {  //bya poprzednio jaka warstwa - wywietlmy j znowu
                for (i=0;i<w.length && j == -1;i++)
                    if (w[i].getId().intValue() == biezacaWarstwaId)
                        j = i;
            } 
            if (j == -1) {
                j = -1;
                for (i=0;i<w.length && j == -1;i++)
                    if (w[i].getSkala() == PomocnikMapy.SKALA_BAZOWA)
                        j = i;
                if (j == -1) j = 0;
            }
            skalaSlider.removeChangeListener(skalaSliderChangeListener);
            skalaSlider.setMaximum(w.length - 1);
            skalaSlider.setMinimum(0);
            skalaSlider.setEnabled(true);
            skalaSlider.setValue(j);
            skalaSlider.addChangeListener(skalaSliderChangeListener);
            rozmiarMapkiSlider.setEnabled(true);
            WLabel.setEnabled(true);
            NLabel.setEnabled(true);
            SLabel.setEnabled(true);
            ELabel.setEnabled(true);
            SELabel.setEnabled(true);
            SWLabel.setEnabled(true);
            NELabel.setEnabled(true);
            NWLabel.setEnabled(true);
            HomeLabel.setEnabled(true);
            ulicaNazwaTextField.setEnabled(true);
            ulicaNrTextField.setEnabled(true);
            ulicaSzukajButton.setEnabled(true);
            rozpocznijPraceZWarstwa(warstwy[j]);
            saWarstwy();
        } else { //na serwerze nie ma adnej warstwy
            skalaSlider.setEnabled(false);
            opisSkaliLabel.setText("");
            rozmiarMapkiSlider.setEnabled(false);
            WLabel.setEnabled(false);
            NLabel.setEnabled(false);
            SLabel.setEnabled(false);
            ELabel.setEnabled(false);
            SELabel.setEnabled(false);
            SWLabel.setEnabled(false);
            NELabel.setEnabled(false);
            NWLabel.setEnabled(false);
            HomeLabel.setEnabled(false);
            ulicaNazwaTextField.setEnabled(false);
            ulicaNrTextField.setEnabled(false);
            ulicaSzukajButton.setEnabled(false);
            niemaWarstw();
        }
    }

    /** Stworzenie popup-menu dla fragmentu. 
     *  @return myszkowy nasuchiwacz wypluwajcy popup-menu
     */
    protected MouseAdapter stworzPopupMenuDlaFragmentuNieobecnego() {
        return null;
    }
    
    /** Stworzenie popup-menu dla pustego obszaru mapy.
     *  @return myszkowy nasuchiwacz wypluwajcy popup-menu
     */
    protected MouseAdapter stworzPopupMenuDlaFragmentuObecnego() {
        return null;
    }
    
    /** Reakcja na narysowanie fragmentw mapy. */
    protected void fragmentyMapyNarysowane() {        
    }
    
    /** Inicjalizuje pobieranie wszystkich potrzebnych obrazkw fragmentw mapy. */
    private void pobierzObrazkiMapy() {
        final NawigacjaMapa komp = this;
        final SwingWorker worker = new SwingWorker() {

        public Object construct() {
            int i, ii = 0;
            MediaTracker t = new MediaTracker(komp);

            //zwalniamy zasoby poprzednich obrazkw
            if (obrazkiFrMapy != null)
                for (i=0;i<obrazkiFrMapy.length;i++)
                    obrazkiFrMapy[i].flush();
            obrazkiFrMapy = new Image[ileAktywnychFragmentow];
            try {
                for (i = 0; i <ileFragmentow*ileFragmentow; i++) {
                    if (fragmenty[i] != null) {
                        obrazkiFrMapy[ii] = Toolkit.getDefaultToolkit().
                                        getImage(new java.net.URL(adresSerwera + PomocnikMapy.wzglednaNazwaFrMapy(fragmenty[i], "/")));
                        t.addImage(obrazkiFrMapy[ii], ii);
                        ii++;
                    }
                }
                t.waitForAll();
                ii = 0;
                for (i=0;i<ileFragmentow*ileFragmentow;i++) {
                    if (fragmenty[i] != null) {
                        ((JLabel)mapaPanel.getComponent(i)).setIcon(new ImageIcon(obrazkiFrMapy[ii]));
                        ii++;
                    }
                }
                komp.fragmentyMapyNarysowane();
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public void finished() {
        }
    };
    worker.start();
    }
    
    /** Reakcja na odebranie fragmentw mapy. */
    protected void przyszlyFragmentyMapy(){
    }
    
    /** Przyjmuje zamwiony zestaw fragmentw mapy, przerysowuje mapaPanel. 
     *  @param fr zestaw fragmentw mapy przysany przez serwer
     */
    public synchronized void odbierzFragmenty(FragmentMapy[] fr) {
        if (fr.length == ileFragmentow*ileFragmentow) { //jeli nie - kto zmieni decyzj w trakcie
            //+2 na border
            Dimension dp = new Dimension(
                            ileFragmentow*(biezacaWarstwa.getRozmiar_x())+2,
                            ileFragmentow*(biezacaWarstwa.getRozmiar_y())+2);
            int i;
            JLabel l;
            MouseAdapter maAkt, maNieakt; //do obsugi popup menu
            JMenuItem mi;
            ImageIcon ii;
            boolean czyDuzeZmiany;
            MouseListener[] mli;
            
            czyDuzeZmiany = czyZmianaWarstwy || (mapaPanel.getComponentCount() != ileFragmentow*ileFragmentow);
            fragmenty = fr;
            ileAktywnychFragmentow = 0;
            if (czyDuzeZmiany) {
                mapaPanel.removeAll();
                mapaPanel.setLayout(new GridLayout(ileFragmentow, ileFragmentow));
                mapaPanel.setPreferredSize(dp);
                mapaPanel.setMinimumSize(dp);
                mapaPanel.setMaximumSize(dp);
                pomMapaPanel.setMaximumSize(new Dimension(dp.width, pomMapaPanel.getMaximumSize().height));
                Dimension d = nawigacjaPanel.getMinimumSize();
                d = new Dimension(d.width+dp.width, Math.max(dp.height, d.height));
                setMinimumSize(d);
                setPreferredSize(d);
            }
            lewyGornyPkt = null;
            //przygotujemy ikonk - zalepk
            BufferedImage im = GraphicsEnvironment.getLocalGraphicsEnvironment()
                                .getDefaultScreenDevice()
                                .getDefaultConfiguration()
                                .createCompatibleImage(biezacaWarstwa.getRozmiar_x(), biezacaWarstwa.getRozmiar_y());
            Graphics2D myg = im.createGraphics();
            myg.setColor(Color.LIGHT_GRAY);
            myg.fillRect(0,0,biezacaWarstwa.getRozmiar_x(), biezacaWarstwa.getRozmiar_y());
            myg.dispose();
            ImageIcon zaslepkaII = new ImageIcon(Toolkit.getDefaultToolkit().createImage(im.getSource()));
            //konfigurujemy popup menus
            maNieakt = stworzPopupMenuDlaFragmentuNieobecnego();
            maAkt = stworzPopupMenuDlaFragmentuObecnego();
            //dodajemy fragmenty mapy
            for (i = 0; i < ileFragmentow*ileFragmentow;i++) {
                if (czyDuzeZmiany) {
                    l = new JLabel();
                } else {
                    l = (JLabel) mapaPanel.getComponent(i);
                    mli = (MouseListener[]) l.getListeners(MouseListener.class);
                    if (mli.length > 1) {
                        //pierwszy - action listener do tooltipw
                        //drugi (ewentualnie) - al do menu
                        l.removeMouseListener(mli[1]);
                    }
                }
                if (fragmenty[i] != null) { //ten fragment istnieje
                    l.setToolTipText(biezacaWarstwa.getId() + "$" + fragmenty[i].getId());
                    if (maAkt != null)
                        l.addMouseListener(maAkt);
                    if (czyDuzeZmiany)
                        mapaPanel.add(l);
                    if (lewyGornyPkt == null)
                        lewyGornyPkt = new Point(fragmenty[i].getWsp_lg_x() - (i%ileFragmentow)*biezacaWarstwa.getRozmiar_x(),
                                                 fragmenty[i].getWsp_lg_y() - (i/ileFragmentow)*biezacaWarstwa.getRozmiar_y());
                    ileAktywnychFragmentow++;
                    l.setIcon(null);
                } else {//fragmentu nie ma
                    l.setIcon(zaslepkaII);
                    l.setToolTipText("brakujcy fragment mapy");
                    if (maNieakt != null)
                        l.addMouseListener(maNieakt);
                    if (czyDuzeZmiany)
                        mapaPanel.add(l);
                }
            }//for
            
            if (lewyGornyPkt == null) {
                Point wzglCentr = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, centralnyPkt);
                lewyGornyPkt = new Point(wzglCentr.x - (ileFragmentow/2)*biezacaWarstwa.getRozmiar_x(),
                                         wzglCentr.y - (ileFragmentow/2)*biezacaWarstwa.getRozmiar_y());
            }
            revalidate();
            /* na samym kocu zapuszczamy pobieranie obrazkw.
             * nie wczeniej, eby najpierw narysowa w dobrej kolejnoci i rozmiarach
             * wszystkie skadowe panelu, a potem dopiero wypeni je mapkami
             */
            if (ileAktywnychFragmentow > 0)
                pobierzObrazkiMapy();
            czyZmianaWarstwy = false;
            przyszlyFragmentyMapy();
        }
    }
    
    /** Inicjalizuje operacj pobierania fragmentw mapy. */
    protected void pobierzFragmenty() {
        mKomSieciowa.pobierzFragmenty(biezacaWarstwa, ileFragmentow, centralnyPkt);
    }
    
    /** Wywietla nowy zestaw fragmentw mapy, tu po zmianie warstwy przez uytkownika. 
     *  @param warstwa warstwa, z ktr uytkownik zaczyna prac
     */
    private void rozpocznijPraceZWarstwa(WarstwaMapy warstwa) {
        biezacaWarstwa = warstwa;
        biezacaWarstwaId = biezacaWarstwa.getId().intValue();
        opisSkaliLabel.setText(biezacaWarstwa.getOpis());
        czyZmianaWarstwy = true;
        pobierzFragmenty();
    }
    
    /** Przelicza widok, przesuwajc mapk po obu wsprzdnych o zadan liczb fragmentw.
     *  @param x    o ile fragmentw przesun w poziomie
     *  @param y    o ile fragmentw przesun w pionie
     */
    private void przesunWidok(int x, int y) {
        Point p = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, new Point(x*biezacaWarstwa.getRozmiar_x(),y*biezacaWarstwa.getRozmiar_y()));
        centralnyPkt.x += p.x;
        centralnyPkt.y += p.y;
        pobierzFragmenty();
    }
    
    /** Przelicza widok, przesuwajc mapk do zadanego punktu.
     *  @param p punkt, ktry ma sta si centralnym punktem widoku.
     */
    protected void przesunWidok(Point p) {
        centralnyPkt = p;
        pobierzFragmenty();
    }

    /** Reakcja na nieistniejc ulic. */
    public void brakUlicy() {
        JOptionPane.showMessageDialog(this, 
                        "Podana ulica nie istnieje w systemie",
                        "B\0142\0105d",
                        JOptionPane.WARNING_MESSAGE);
    }

    /** Reakcja na pojawienie si fragmentw ulicy. */
    protected void przyszlyFragmentyUlicy() {
        //wycentrowanie mapy
            if (frUlicy.length > 0) {
            int i;
            int ktNr = 1+(Math.max(Math.max(frUlicy[frUlicy.length-1].getNr_konc(),frUlicy[frUlicy.length-1].getNr_pocz()), Math.max(frUlicy[0].getNr_konc(),frUlicy[0].getNr_pocz()))
                       -Math.min(Math.min(frUlicy[frUlicy.length-1].getNr_konc(),frUlicy[frUlicy.length-1].getNr_pocz()), Math.min(frUlicy[0].getNr_konc(),frUlicy[0].getNr_pocz())))/2;
            if (ulicaNrTextField.getText().length()>0) {
                try {
                    ktNr = Integer.parseInt(ulicaNrTextField.getText());
                } catch (NumberFormatException ne) {
                }
            }
            Point nowy = centralnyPkt;
            for (i = 0; i< frUlicy.length; i++) {
                if ((frUlicy[i].getNr_pocz() <= ktNr && frUlicy[i].getNr_konc() >= ktNr)
                    || (frUlicy[i].getNr_konc() <= ktNr && frUlicy[i].getNr_pocz() >= ktNr)) {
                    nowy = PomocnikMapy.wspolrzedneObiektu(frUlicy[i], ktNr);
                }
            }
            if (nowy != centralnyPkt)
                przesunWidok(nowy);
        } else
            repaint();
    }

    /** Przyjmuje fragmenty ulicy.
     *  @param fr odebrane z serwera fragmenty ulicy.
     */
    public void odbierzFragmentyUlicy(FragmentUlicy[] fr) {
        frUlicy = fr;
        przyszlyFragmentyUlicy();
    }
    
    /** Przyjmuje ulic.
     *  @param ul odebrana z serwera ulica
     */
    protected void przyszlaUlica(Ulica ul) {
        biezacaUlica = ul;
        frUlicy = null;
        mKomSieciowa.znajdzFragmentyUlicy(ul);
    }
    
    /** Przyjmuje list ulic.
     * @param ulice odebrana z serwera lista ulic
     */
    public void odbierzUlice(List ulice) {
        switch (ulice.size()) {
            case 0:
                brakUlicy();
                break;
                
            case 1:
                przyszlaUlica((Ulica) ulice.get(0));
                break;
                
            default:
                String[] stmp = new String[ulice.size()];
                String wybor;
                int i;
                for (i = 0;i<ulice.size();i++)
                    stmp[i] = ((Ulica)ulice.get(i)).getNazwa();
                wybor = (String)JOptionPane.showInputDialog(this,
                                "Podana nazwa ulicy jest niejednoznaczna, doprecyzuj!",
                                "Wybr ulicy",
                                JOptionPane.QUESTION_MESSAGE,
                                null, 
                                stmp,
                                stmp[0]);
                ulicaNazwaTextField.setText(wybor);
                for (i = 0;i<ulice.size();i++) 
                    if (stmp[i] == wybor) {
                        przyszlaUlica((Ulica) ulice.get(i));
                        break;
                    }
        }
    }
    
    /** Inicjalizacja komponenetw panelu.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        glownyPanel = new javax.swing.JPanel();
        nawigacjaPanel = new javax.swing.JPanel();
        gornyNawPanel = new javax.swing.JPanel();
        rozmiarMapkiSlider = new javax.swing.JSlider();
        lukrowaneGuziczkiPanel = new javax.swing.JPanel();
        NWLabel = new javax.swing.JLabel();
        NLabel = new javax.swing.JLabel();
        NELabel = new javax.swing.JLabel();
        WLabel = new javax.swing.JLabel();
        HomeLabel = new javax.swing.JLabel();
        ELabel = new javax.swing.JLabel();
        SWLabel = new javax.swing.JLabel();
        SLabel = new javax.swing.JLabel();
        SELabel = new javax.swing.JLabel();
        warstwyPanel = new javax.swing.JPanel();
        opisSkaliLabel = new javax.swing.JLabel();
        skalaSlider = new javax.swing.JSlider();
        szukajUlicyPanel = new javax.swing.JPanel();
        ulicaNazwaLabel = new javax.swing.JLabel();
        ulicaNazwaTextField = new javax.swing.JTextField();
        ulicaNrLabel = new javax.swing.JLabel();
        ulicaNrTextField = new javax.swing.JTextField();
        ulicaSzukajButton = new javax.swing.JButton();
        pomMapaPanel = new javax.swing.JPanel();
        mapaPanel = new javax.swing.JPanel();
        glownyPrawyPanel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        glownyPanel.setLayout(new javax.swing.BoxLayout(glownyPanel, javax.swing.BoxLayout.X_AXIS));

        glownyPanel.setPreferredSize(new java.awt.Dimension(137, 290));
        nawigacjaPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 0, 0));

        nawigacjaPanel.setMaximumSize(new java.awt.Dimension(135, 32767));
        nawigacjaPanel.setMinimumSize(new java.awt.Dimension(135, 265));
        nawigacjaPanel.setPreferredSize(new java.awt.Dimension(135, 265));
        gornyNawPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 3, 0));

        gornyNawPanel.setBorder(new javax.swing.border.TitledBorder("Nawigacja"));
        gornyNawPanel.setMaximumSize(new java.awt.Dimension(135, 87));
        gornyNawPanel.setMinimumSize(new java.awt.Dimension(135, 87));
        gornyNawPanel.setPreferredSize(new java.awt.Dimension(135, 115));
        rozmiarMapkiSlider.setMajorTickSpacing(2);
        rozmiarMapkiSlider.setMaximum(7);
        rozmiarMapkiSlider.setMinimum(3);
        rozmiarMapkiSlider.setMinorTickSpacing(1);
        rozmiarMapkiSlider.setOrientation(javax.swing.JSlider.VERTICAL);
        rozmiarMapkiSlider.setPaintLabels(true);
        rozmiarMapkiSlider.setPaintTicks(true);
        rozmiarMapkiSlider.setToolTipText("rozmiar mapki");
        rozmiarMapkiSlider.setValue(3);
        rozmiarMapkiSlider.setMaximumSize(new java.awt.Dimension(40, 87));
        rozmiarMapkiSlider.setMinimumSize(new java.awt.Dimension(40, 87));
        rozmiarMapkiSlider.setPreferredSize(new java.awt.Dimension(40, 87));
        rozmiarMapkiSlider.setEnabled(false);
        rozmiarMapkiSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                rozmiarMapkiSliderStateChanged(evt);
            }
        });

        gornyNawPanel.add(rozmiarMapkiSlider);

        lukrowaneGuziczkiPanel.setLayout(new java.awt.GridLayout(3, 3));

        lukrowaneGuziczkiPanel.setMaximumSize(new java.awt.Dimension(77, 69));
        lukrowaneGuziczkiPanel.setMinimumSize(new java.awt.Dimension(77, 69));
        lukrowaneGuziczkiPanel.setPreferredSize(new java.awt.Dimension(77, 69));
        NWLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        NWLabel.setText("NW");
        NWLabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        NWLabel.setBorder(new javax.swing.border.EtchedBorder());
        NWLabel.setEnabled(false);
        NWLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                NWLabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(NWLabel);

        NLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        NLabel.setText("N");
        NLabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        NLabel.setBorder(new javax.swing.border.EtchedBorder());
        NLabel.setEnabled(false);
        NLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                NLabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(NLabel);

        NELabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        NELabel.setText("NE");
        NELabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        NELabel.setBorder(new javax.swing.border.EtchedBorder());
        NELabel.setEnabled(false);
        NELabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                NELabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(NELabel);

        WLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        WLabel.setText("W");
        WLabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        WLabel.setBorder(new javax.swing.border.EtchedBorder());
        WLabel.setEnabled(false);
        WLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                WLabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(WLabel);

        HomeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        HomeLabel.setBorder(new javax.swing.border.EtchedBorder());
        HomeLabel.setEnabled(false);
        HomeLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                HomeLabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(HomeLabel);

        ELabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        ELabel.setText("E");
        ELabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        ELabel.setBorder(new javax.swing.border.EtchedBorder());
        ELabel.setEnabled(false);
        ELabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                ELabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(ELabel);

        SWLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        SWLabel.setText("SW");
        SWLabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        SWLabel.setBorder(new javax.swing.border.EtchedBorder());
        SWLabel.setEnabled(false);
        SWLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SWLabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(SWLabel);

        SLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        SLabel.setText("S");
        SLabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        SLabel.setBorder(new javax.swing.border.EtchedBorder());
        SLabel.setEnabled(false);
        SLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SLabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(SLabel);

        SELabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        SELabel.setText("SE");
        SELabel.setToolTipText("<html>przesuwanie widoku mapy<br>kliknij z shiftem aby si\u0119 przesun\u0105\u0107 o mniej ni\u017c p\u00f3\u0142 ekranu<br>a z controlem - o ca\u0142y ekran</html>");
        SELabel.setBorder(new javax.swing.border.EtchedBorder());
        SELabel.setEnabled(false);
        SELabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                SELabelMouseClicked(evt);
            }
        });

        lukrowaneGuziczkiPanel.add(SELabel);

        gornyNawPanel.add(lukrowaneGuziczkiPanel);

        nawigacjaPanel.add(gornyNawPanel);

        warstwyPanel.setBorder(new javax.swing.border.TitledBorder("Warstwy"));
        warstwyPanel.setMaximumSize(new java.awt.Dimension(135, 32767));
        warstwyPanel.setMinimumSize(new java.awt.Dimension(135, 90));
        warstwyPanel.setPreferredSize(new java.awt.Dimension(135, 90));
        opisSkaliLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        opisSkaliLabel.setMaximumSize(new java.awt.Dimension(125, 19));
        opisSkaliLabel.setMinimumSize(new java.awt.Dimension(125, 19));
        opisSkaliLabel.setPreferredSize(new java.awt.Dimension(125, 19));
        opisSkaliLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        warstwyPanel.add(opisSkaliLabel);

        skalaSlider.setMajorTickSpacing(1);
        skalaSlider.setMaximum(0);
        skalaSlider.setMinorTickSpacing(1);
        skalaSlider.setPaintTicks(true);
        skalaSlider.setToolTipText("zmiana skali");
        skalaSlider.setMaximumSize(new java.awt.Dimension(125, 30));
        skalaSlider.setMinimumSize(new java.awt.Dimension(125, 27));
        skalaSlider.setPreferredSize(new java.awt.Dimension(125, 27));
        skalaSlider.setEnabled(false);
        warstwyPanel.add(skalaSlider);

        nawigacjaPanel.add(warstwyPanel);

        szukajUlicyPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 1, 2));

        szukajUlicyPanel.setBorder(new javax.swing.border.TitledBorder("Wyszukiwanie ulic"));
        szukajUlicyPanel.setMinimumSize(new java.awt.Dimension(135, 28));
        szukajUlicyPanel.setPreferredSize(new java.awt.Dimension(135, 70));
        ulicaNazwaLabel.setFont(new java.awt.Font("Dialog", 0, 10));
        ulicaNazwaLabel.setText("Ulica:");
        szukajUlicyPanel.add(ulicaNazwaLabel);

        ulicaNazwaTextField.setFont(new java.awt.Font("Dialog", 0, 10));
        ulicaNazwaTextField.setText("Pasteura");
        ulicaNazwaTextField.setToolTipText("podaj nazw\u0119 wyszukiwanej ulicy");
        ulicaNazwaTextField.setMinimumSize(new java.awt.Dimension(99, 18));
        ulicaNazwaTextField.setPreferredSize(new java.awt.Dimension(96, 18));
        ulicaNazwaTextField.setEnabled(false);
        szukajUlicyPanel.add(ulicaNazwaTextField);

        ulicaNrLabel.setFont(new java.awt.Font("Dialog", 0, 10));
        ulicaNrLabel.setText("Nr:");
        szukajUlicyPanel.add(ulicaNrLabel);

        ulicaNrTextField.setFont(new java.awt.Font("Dialog", 0, 10));
        ulicaNrTextField.setToolTipText("podaj wyszukiwany numer domu");
        ulicaNrTextField.setMinimumSize(new java.awt.Dimension(33, 18));
        ulicaNrTextField.setPreferredSize(new java.awt.Dimension(33, 18));
        ulicaNrTextField.setEnabled(false);
        szukajUlicyPanel.add(ulicaNrTextField);

        ulicaSzukajButton.setFont(new java.awt.Font("Dialog", 0, 10));
        ulicaSzukajButton.setText("Szukaj");
        ulicaSzukajButton.setMaximumSize(new java.awt.Dimension(70, 18));
        ulicaSzukajButton.setMinimumSize(new java.awt.Dimension(70, 18));
        ulicaSzukajButton.setPreferredSize(new java.awt.Dimension(70, 18));
        ulicaSzukajButton.setEnabled(false);
        ulicaSzukajButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ulicaSzukajButtonActionPerformed(evt);
            }
        });

        szukajUlicyPanel.add(ulicaSzukajButton);

        nawigacjaPanel.add(szukajUlicyPanel);

        glownyPanel.add(nawigacjaPanel);

        pomMapaPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 0, 0));

        mapaPanel.setLayout(new java.awt.GridLayout(2, 2));

        mapaPanel.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        pomMapaPanel.add(mapaPanel);

        glownyPanel.add(pomMapaPanel);

        glownyPrawyPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 0, 0));

        glownyPanel.add(glownyPrawyPanel);

        add(glownyPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void ulicaSzukajButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ulicaSzukajButtonActionPerformed
        if (ulicaNazwaTextField.getText().length() > 0) {
            szukanaUlica = ulicaNazwaTextField.getText();
            mKomSieciowa.znajdzUlice(szukanaUlica);
        }
    }//GEN-LAST:event_ulicaSzukajButtonActionPerformed

    private void skalaSliderStateChanged(javax.swing.event.ChangeEvent evt) {
        int nv;

        nv = skalaSlider.getValue();
        if (nv < 0) return;
        opisSkaliLabel.setText(warstwy[nv].getOpis());
        if (!skalaSlider.getValueIsAdjusting()) {//tylko jeli ju koniec przesuwania
            if (warstwy[nv].getId().intValue() != biezacaWarstwaId) {
                rozpocznijPraceZWarstwa(warstwy[nv]);
            }
        }
    }

    private void rozmiarMapkiSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_rozmiarMapkiSliderStateChanged
        int nv;
        
        if (!rozmiarMapkiSlider.getValueIsAdjusting()) {//ju si nie przesuwa
            nv = rozmiarMapkiSlider.getValue();
            if (nv != ileFragmentow) {
                ileFragmentow = nv;
                rozpocznijPraceZWarstwa(biezacaWarstwa);
            }
        }
    }//GEN-LAST:event_rozmiarMapkiSliderStateChanged

    private int mnoznikPrzesuniecia(java.awt.event.MouseEvent evt) {
        return (evt.isShiftDown() ? 1 : (evt.isControlDown() ? ileFragmentow : ileFragmentow/2));
    }
    
    private void ELabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_ELabelMouseClicked
        if (ELabel.isEnabled()) przesunWidok(1*mnoznikPrzesuniecia(evt), 0);
    }//GEN-LAST:event_ELabelMouseClicked

    private void NELabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_NELabelMouseClicked
        if (NELabel.isEnabled()) przesunWidok(1*mnoznikPrzesuniecia(evt), -1*mnoznikPrzesuniecia(evt));
    }//GEN-LAST:event_NELabelMouseClicked

    private void NLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_NLabelMouseClicked
        if (NLabel.isEnabled()) przesunWidok(0, -1*mnoznikPrzesuniecia(evt));
    }//GEN-LAST:event_NLabelMouseClicked

    private void WLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_WLabelMouseClicked
        if (WLabel.isEnabled()) przesunWidok(-1*mnoznikPrzesuniecia(evt), 0);
    }//GEN-LAST:event_WLabelMouseClicked

    private void SWLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SWLabelMouseClicked
        if (SWLabel.isEnabled()) przesunWidok(-1*mnoznikPrzesuniecia(evt), 1);
    }//GEN-LAST:event_SWLabelMouseClicked

    private void SLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SLabelMouseClicked
        if (SLabel.isEnabled()) przesunWidok(0, 1*mnoznikPrzesuniecia(evt));
    }//GEN-LAST:event_SLabelMouseClicked

    private void SELabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_SELabelMouseClicked
        if (SELabel.isEnabled()) przesunWidok(1*mnoznikPrzesuniecia(evt), 1*mnoznikPrzesuniecia(evt));
    }//GEN-LAST:event_SELabelMouseClicked

    private void HomeLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_HomeLabelMouseClicked
        if (HomeLabel.isEnabled()) {
            centralnyPkt.x = 0;
            centralnyPkt.y = 0;
            pobierzFragmenty();
        }
    }//GEN-LAST:event_HomeLabelMouseClicked

    private void NWLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_NWLabelMouseClicked
        if (NWLabel.isEnabled()) przesunWidok(-1*mnoznikPrzesuniecia(evt), -1*mnoznikPrzesuniecia(evt));
    }//GEN-LAST:event_NWLabelMouseClicked

   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel ELabel;
    private javax.swing.JLabel HomeLabel;
    private javax.swing.JLabel NELabel;
    private javax.swing.JLabel NLabel;
    private javax.swing.JLabel NWLabel;
    private javax.swing.JLabel SELabel;
    private javax.swing.JLabel SLabel;
    private javax.swing.JLabel SWLabel;
    private javax.swing.JLabel WLabel;
    private javax.swing.JPanel glownyPanel;
    protected javax.swing.JPanel glownyPrawyPanel;
    private javax.swing.JPanel gornyNawPanel;
    private javax.swing.JPanel lukrowaneGuziczkiPanel;
    protected javax.swing.JPanel mapaPanel;
    private javax.swing.JPanel nawigacjaPanel;
    private javax.swing.JLabel opisSkaliLabel;
    protected javax.swing.JPanel pomMapaPanel;
    protected javax.swing.JSlider rozmiarMapkiSlider;
    private javax.swing.JSlider skalaSlider;
    private javax.swing.JPanel szukajUlicyPanel;
    private javax.swing.JLabel ulicaNazwaLabel;
    private javax.swing.JTextField ulicaNazwaTextField;
    private javax.swing.JLabel ulicaNrLabel;
    protected javax.swing.JTextField ulicaNrTextField;
    private javax.swing.JButton ulicaSzukajButton;
    protected javax.swing.JPanel warstwyPanel;
    // End of variables declaration//GEN-END:variables
    
}
