/*
 * UniKomSieciowa.java
 *
 * Created on 20 kwiecie 2004, 13:07
 */

package komponenty;

import shared.*;
import shared.branze.KatalogBranzDrzewo;
import java.net.URL;
import java.io.ObjectInputStream;
import java.rmi.Naming;
import java.awt.Image;
import java.util.List;

/** Abstrakcyjna klasa komunikacji sieciowej interfejsu z serwerem. Zawiera inicjalizacj
 *  teje komunikacji oraz dostarcza metod uruchamiania nowych zlece sieciowych. Po tej 
 *  klasie powinny dziedziczy metody implementujce specyficzne dla konkrtnych interfejsw
 *  zlecenia sieciowe.
 *
 * @author  me201258
 */
public abstract class UniKomSieciowa {
    /** Obiekt obsugujcy konta firm na serwerze. */
    public InterfejsKontaFirm kontaFirm;
    /** Obiekt obsugujcy konto administratora na serwerze. */
    public InterfejsKontoAdministratora kontoAdministratora;
    /** Obiekt obsugujcy mapy na serwerze. */
    public InterfejsMapy mapy;
    /** Obiekt obsugujcy katalog ogosze na serwerze. */
    public InterfejsOgloszenia ogloszenia;
    /** Obiekt obsugujcy ulice na serwerze. */
    public InterfejsUlice ulice;
    /** Obiekt obsugujcy katalog bran. */
    public InterfejsKataloguBranz katalogBranz;
    /** Obiekt obsugujcy katalog najpopularniejszych bran. */
    public InterfejsNajpopularniejszychBranz katalogNajpop;
    
    /** Zapamitana przy inicjalizacji nazwa serwera. */
    private String serwer;
    /** Aktualnie obsugiwane zlecenie sieciowe. */
    private Thread t = null;
    
    /** Pomocnicza funkcja wyszukujca na serwerze zadany obiekt.
     *  @param nazwa nazwa serwera
     *  @return odnaleziony sieciowy obiekt
     */
    private Object myLookup(String nazwa) throws Exception {
        return Naming.lookup("//" + serwer +"/" + nazwa);
    }
    
    /** Tworzy nowy obiekt klasy UniKomSieciowa. */
    public UniKomSieciowa() {}

    /** Inicjalizacja pocze sieciowych.
     *  @param serwer nazwa serwera
     *  @throws Wyjatek w przypadku bdu poczenia z serwerem
     */
    public void init(String serwer) throws Wyjatek {
        this.serwer = serwer;
        try {
            kontaFirm = (InterfejsKontaFirm) myLookup("kontaFirm");
            kontoAdministratora = (InterfejsKontoAdministratora) myLookup("kontoAdministratora");
            mapy = (InterfejsMapy) myLookup("mapy");
            ogloszenia = (InterfejsOgloszenia) myLookup("katalogOgloszen");
            ulice = (InterfejsUlice) myLookup("ulice");
            katalogBranz = (InterfejsKataloguBranz) myLookup("katalogBranz");
            katalogNajpop = (InterfejsNajpopularniejszychBranz) myLookup("katalogNajpopularniejszych");
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /**
     * Pobranie z serwera statycznie wygenerowanego katalogu bran.
     * @param niiktHttpSerwerPath adres url NIIKTa z ktrego zostanie pobrany katalog
     * @return Pobrany Katalog Bran
     * @throws Wyjatek Wyrzucany, gdy nie uda si pobra katalogu bran
     */
    public KatalogBranzDrzewo pobierzKatalogBranz(String niiktHttpSerwerPath) throws Wyjatek {
        URL url = null;
        KatalogBranzDrzewo ret = null;
        try {
            url = new URL(niiktHttpSerwerPath + "/katalog_branz/katalog_branz.ser");
            ObjectInputStream in = new ObjectInputStream(url.openStream());
            ret = (KatalogBranzDrzewo) in.readObject();
            in.close();
    
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        return ret;
    }
    
     /**
     * Pobranie z serwera statycznie wygenerowanego katalogu najpopularniejszych bran.
     * @param niiktHttpSerwerPath adres url NIIKTa z ktrego zostanie pobrany katalog
     * @return Pobrany Katalog Najpopularniejszych Bran
     * @throws Wyjatek Wyrzucany, gdy nie uda si pobra Katalogu Najpopularniejszych Bran
     */
    public List pobierzKatalogNajBranz(String niiktHttpSerwerPath) throws Wyjatek {
        URL url = null;
        List ret = null;
        try {
            url = new URL(niiktHttpSerwerPath + "/katalog_naj_branz/katalog_naj_branz.ser");
            ObjectInputStream in = new ObjectInputStream(url.openStream());
            ret = (List) in.readObject();
            in.close();
    
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        return ret;
    }
    
    /** Pobranie logo z serwera.
     * @param httpPath Adres, pod ktrym znajduje si logo
     * @return pobrane logo
     * @throws Wyjatek Wyrzucany, gdy nie uda si pobra logo
     */
    public Image pobierzLogo(String httpPath) throws Wyjatek {
        Image ret = null;
        try {
            // Ela: sugeruje zrobic tak:
            URL url = new URL(httpPath);
            javax.swing.ImageIcon ii = new javax.swing.ImageIcon(url);
            ret = ii.getImage();
            // InputStream is = url.openStream();
            //ObjectInputStream in = new ObjectInputStream(is);
            //ret = (Image) in.readObject();
            //in.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        return ret;
    }
    
 
    /** Przygotowuje i uruchamia wtek do obsugi zdarzenia zdefiniowanego w podanym parametrze.
     *  @param noweR obiekt typu Runnable, ktry chcemy wykona w osobnym wtku.
     */
    protected synchronized void odpalWatek(Runnable noweR) {
        if (t != null) {
            try {
                t.interrupt();
            } catch (Exception e) {
                //na razie po prostu tumimy wyjtek. moe trzeba powiadomi uytkownika i nic wicej nie robi
            }
        }
        t = new Thread(noweR);
        t.start();
    }
    
    /** Sprzta po koczcym si wtku. */
    protected void zamknijWatek(){
        //by moze wymaga to bdzie jakiego semafora, albo co..
        t = null;
    }
}
