/*
 * NajpopListItem.java
 *
 * Created on 17 maj 2004, 11:40
 */

package komponenty.models;
import shared.NajpopularniejszaBranza;

/**
 * Model Najpopularniejszej Brany sucy do wywietlania
 * w JListach w interfejsie
 * @author  witus
 * @version %I% %G%
 */
public class NajpopListItem {
    private NajpopularniejszaBranza nb;
    
    /** Tworzy nowy obiekt klsy NajpopListItem 
     * @param nb Najpopularniejsza Brana, z ktr bdzie zwizany obiekt
     */
    public NajpopListItem(NajpopularniejszaBranza nb) {
        this.nb = nb;
    }
    
    /** 
     * Zwraca napis ktry bd mogy wywietla komponenty interfejsu
     * @return napis reprezentujcy Najpopularniejsz Bran zwizan z obiektem
     */
    public String toString() {
        return (this.nb.getRanking() + " :: " + this.nb.getBranza().getNazwa() + 
                " :: " + this.nb.getOpis());
    }
    
    /**
     * Zwraca Najpopularniejsz bran zwizan z obiektem 
     * @return Najpopularnijesza Brana zwizana z obiektem
     */
    public NajpopularniejszaBranza getNb() {
        return this.nb;
    }
}
