/*
 * OgloszenieListModel.java
 *
 * Created on 24 maj 2004, 13:14
 */

package komponenty.models;

import shared.Ogloszenie;

/**
 * Model Ogloszenia sucy do wywietlania
 * w JListach w interfejsie
 * @author  witus
 * @version %I% %G%
 */
public class OgloszenieListModel {
    private shared.Ogloszenie ogloszenie;
    
    /** Tworzy nowy obiekt klasy OgloszenieListModel 
     * @param ogloszenie Ogoszenie, z ktrym bdzie zwizany tworzony
     * obiekt
     */
    public OgloszenieListModel(Ogloszenie ogloszenie) {
        this.ogloszenie = ogloszenie;
    }
    
    /** Konstuuje napis, ktry bdzie mg by wywietlany w interfejsie
     * @return Napis, ktry moe by wywietlany w komponentach interfejsu
     */
    public String toString() {
        return (this.ogloszenie.getNazwa() + " :: " + this.ogloszenie.getEkontakt());
    }
    
    /** Akcesor do Ogoszenia zwizanego z obiektem
     * @return Ogoszenie zwizane z obiektem
     */
    public shared.Ogloszenie getOgloszenie() {
        return this.ogloszenie;
    }
}
