/*
 * Hibcio.java
 *
 */

package serwer;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Session;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import java.sql.SQLException;

import shared.*;

/**
 * Kocwka Hibernata w logice. Konfiguruje Hibernata i udostpnia
 * interfejs do pobierania i oddawania sesji.
 *
 * @author ek197882
 */
public class Hibcio {
    
    /** Konfiguracja Hibernate'a. */
    private static Configuration cfg;
    
    /** Zbir, klass, ktre zostan zaadowane. */
    private static final Class[] classes = new Class[] {
        Branza.class,
        DrzewoBranz.class,
        NajpopularniejszaBranza.class,
        Telefon.class,
        Ogloszenie.class,
        OgloszeniePlatne.class,
        WarstwaMapy.class,
        FragmentMapy.class,
        Ulica.class,
        FragmentUlicy.class,
        HasloAdmina.class
    };
    
    /** Zarzdza przydziaem i zwalnianiem sesji z baz danych. */
    private static SessionFactory sf;
    
    /** Inicjalizuje konfiguracj Hibernate'a. */
    private static void initConfiguration() {
        cfg = new Configuration();
    }
    
    /** Konfiguruje Hibernate adujc zmapowane klasy. */
    private static void loadClasses() throws HibernateException {
        for (int i = 0; i < classes.length; i++)
            cfg.addClass(classes[i]);
    }
    
    /** Inicjalizuje fabryk sesji dla skonfigurowanego Hibernata. */
    private static void initSessionFactory() throws HibernateException {
        sf = cfg.buildSessionFactory();
    }
    
    /** Inicjalizuje Hibernate'a. */
    static {
        System.out.println("->inicjalizacja Hibernate");
        initConfiguration();
        try {
            loadClasses();
            initSessionFactory();
            /* eksport bazy danych (utworzenie jej na nowo) */
            /* new SchemaExport(cfg).create(true,true); */
        } catch (HibernateException e) {
            e.printStackTrace();
        }
    }
    
    /** Nieuywany konstruktor. */
    private Hibcio() {
    }
    
    /**
     * Zatwierdza oczekujce operacje.
     * Przy jawnym wykorzystaniu wsparcia transakcji, nie naley uywa tej metody.
     *
     * @param s Zatwierdzana sesja
     * @throws SQLException gdy nastpi bld bazodanowy
     * @throws HibernateException gdy nastpi bd warstwy Hibernate'a
     */
    public static void commit(Session s) throws HibernateException, SQLException {
        if (s != null) {
            s.flush();
            s.connection().commit();
        }
    }
    
    /**
     * Anuluje oczekujace operacje.
     * Przy jawnym wykorzystaniu wsparcia transakcji, nie naley uywa tej metody.
     *
     * @param s Anulowana sesja
     * @throws SQLException gdy nastpi bld bazodanowy
     * @throws HibernateException gdy nastpi bld warstwy Hibernate'a
     */
    public static void rollback(Session s) throws HibernateException, SQLException {
        if (s != null) {
            s.connection().rollback();
        }
    }
    
    
    /**
     * Przydziela sesj z baz danych.
     *
     * @return Otwarta sesja.
     * @throws HibernateException gdy nastpi bld warstwy Hibernate'a
     */
    public static Session openSession() throws HibernateException {
        Session s;
        s = sf.openSession();
        return s;
    }
    
    /**
     * Zwalnia sesj z baz danych. Bldy zamykania sesji ignorujemy.
     *
     * @param s Zamykana sesja
     */
    public static void closeSession(Session s) {
        try {
            if (s != null) {
                commit(s);
                s.close();
            }
        } catch (Exception e) {
            //wyjtki zamykania sesji po prostu ignorujemy
            //nie chcia Hibcio zamkn sesji - jego strata!
        }
    }
}
