/*
 * Serwer.java
 *
 * Created on 21 marzec 2004, 01:21
 */

package serwer;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;

import serwer.mapa.Mapy;
import serwer.mapa.Ulice;
import serwer.Jadro;
import serwer.ogloszenia.KatalogOgloszen;
import serwer.konto.*;
import serwer.branze.*;

/** Odpowiedzialna za rozruch caej aplikacji serwerowej. W klasie znajduje si 
 * jedynie metoda main, ktra inicjalizuje prac aplikacji serwerowej.
 *
 * @author  me201258
 */
public class Serwer {
    
    /** Tworzy nowy obiekt klasy Serwer.*/
    public Serwer() {
    }
    
    /** Metoda wykonywalna caej aplikacji serwerowej.
     *  @param args argumenty linii polece
     */
    public static void main(String[] args) {
        
        try {
            System.out.println("Serwer NIIKT rozpoczyna prac");
            Jadro.mapy = new Mapy();
            Jadro.ulice = new Ulice();
            Jadro.katalogOgloszen = new KatalogOgloszen();
            Jadro.kontaFirm = new KontaFirm();
            Jadro.kontoAdministratora = new KontoAdministratora();
            Jadro.katalogBranz = new KatalogBranz();
            Jadro.katalogNajpopularniejszych = new KatalogNajpopularniejszych();

            System.out.println("->inicjalizacja RMI-registry");
            if (System.getSecurityManager() == null)
                System.setSecurityManager(new RMISecurityManager());
            Naming.rebind("//localhost/mapy", Jadro.mapy);
            Naming.rebind("//localhost/ulice", Jadro.ulice);
            Naming.rebind("//localhost/katalogOgloszen", Jadro.katalogOgloszen);
            Naming.rebind("//localhost/kontaFirm", Jadro.kontaFirm);
            Naming.rebind("//localhost/kontoAdministratora", Jadro.kontoAdministratora);
            Naming.rebind("//localhost/katalogBranz", Jadro.katalogBranz);
            Naming.rebind("//localhost/katalogNajpopularniejszych", Jadro.katalogNajpopularniejszych);

        } catch (Exception e) {
            e.printStackTrace();
            return;
        }

        System.out.println("Serwer uruchomiony.");
    }
}
