/*
 * KatalogBranz.java
 *
 * Created on 21 marzec 2004, 22:57
 */

package serwer.branze;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import shared.*;
import shared.branze.*;
import serwer.*;
import java.util.*;
import net.sf.hibernate.*;
import java.io.File;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.FileOutputStream;

/**
 * Pozowala na zarzdzanie katalogiem bran znajdujcym si w bazie danych
 * @author witus
 */
public class KatalogBranz
     extends UnicastRemoteObject implements shared.InterfejsKataloguBranz {
    /** Zawiera wspolne dane przekazywane wszystkim obiektom */
    
    /** Tworzy nowy obiekt klasy KatalogBranz
     * @throws RemoteException potrzebny aby klasa implementowaa interfejs 
     * @throws Wyjatek potrzebny aby klasa implementowaa interfejs
     */
    public KatalogBranz() throws Wyjatek, java.rmi.RemoteException {
    }
    
    /**
     * Usuwanie zadanej brany z bazy danych
     * @param branza brana, ktra zostanie usunita z bazy danych
     * @throws Wyjatek wyjtek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public void usunBranze(Branza branza) throws Wyjatek {
        Session sesja = null;
        
        try {
            sesja = Hibcio.openSession();
            /* Chc usun branze z bazy danych */
            Transaction tn = sesja.beginTransaction();
            sesja.delete("from shared.DrzewoBranz as db where db.syn = ?", branza, Hibernate.entity(Branza.class));
            sesja.delete("from shared.Branza as b where b = ?", branza, Hibernate.entity(Branza.class));
            tn.commit();
            Hibcio.closeSession(sesja);
        } catch (Exception e) {
            try {
                Hibcio.rollback(sesja);
            } catch (Exception e1) {}
            Hibcio.closeSession(sesja);
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /**
     * Usuwanie zadanej brany z bazy danych
     * @param branza Brana, ktra zostanie usunita z bazy danych
     * @param sesja Sesja hibernate'a, ktra zostanie uyta do usunicia Brany 
     * @throws Exception wyjtek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    private void usunBranze(Branza branza, Session sesja) throws Exception {        
        try {
            /* Chc usun branze z bazy danych */
            sesja.delete("from shared.Branza as b where b = ?", branza, Hibernate.entity(Branza.class));
        } catch (Exception e) {
            throw e;
        }
    }
    
    /**
     * Usuwanie zadanej brany z bazy danych
     * @param branza Brana, ktra zostanie usunita z bazy danych
     * @param matka Brana, ktra jest nadwzem usuwanej brany
     * @throws Wyjatek wyjtek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */  
    public void usunPodczepionaBranze(Branza branza, Branza matka) throws Wyjatek {
        Session s = null;
        try {
            s = Hibcio.openSession();
            Transaction tn = s.beginTransaction();
            Object[] tab1 = new Object[2];
            net.sf.hibernate.type.Type[] tab2 = new net.sf.hibernate.type.EntityType[2];
            
            // tab1[0] = branza; tab1[1] = matka;
            // tab2[0] = Hibernate.entity(Branza.class);
            // tab2[1] = Hibernate.entity(Branza.class);
            // s.delete("from shared.DrzewoBranz as db where db.syn = ? and db.matka = ?", tab1, tab2);
            
            Query query = s.createQuery("from shared.DrzewoBranz as db where db.syn = :param1 and db.matka = :param2");
            query.setParameter("param1", branza);
            query.setParameter("param2", matka);
            DrzewoBranz wynik = (DrzewoBranz) query.uniqueResult();
            s.delete(wynik);
            query = s.createQuery("from shared.DrzewoBranz as db where db.syn = :param");
            query.setParameter("param", branza);
            
            if (query.list().isEmpty()) {
                usunBranze(branza, s);
            }
            Hibcio.commit(s);
        } catch (Exception e) {
            try {
                Hibcio.rollback(s);
            } catch (Exception e1) {}
            e.printStackTrace();
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        
    }
    
   /**
     * Zmiania Bran w Katalogu Branz
     * @param nowa Brana, ktra znajdzie si w Katalogu Bran
     * @param stara Brana, ktra zostanie zamieniona na now
     * @return Brana, ktra znalaza si w Katalogu
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */
    public Branza zmienBranze(Branza stara, Branza nowa) throws Wyjatek {
        Session sesja = null;
        /* rozpoczynam now sesj z hibernatem */
        try {
            sesja = Hibcio.openSession();
            /* Usuwam jedn brane i wstawiam now */
            Transaction tn = sesja.beginTransaction();
 
            nowa.setId(stara.getId());
            sesja.saveOrUpdate(nowa);
            
            Hibcio.commit(sesja);
            Hibcio.closeSession(sesja);
            return nowa;
        } catch (Exception e) {
            try {
                Hibcio.rollback(sesja);
            } catch (Exception e1) {}
            Hibcio.closeSession(sesja);
            throw new Wyjatek();
        }
    }
    
    /**
     * Odnajduje brae na podstawie zadanego sowa kluczowego
     * @param klucz sowo kluczowe, na podstawie ktrego bdziemy szuka brany
     * @return lista bran zwiazana z zadanym sowem kluczowym
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public static List znajdzBranze(String klucz) throws Wyjatek {
        Session sesja;
        
        /* rozpoczynam now sesj z hibernatem */
        try {
            sesja = Hibcio.openSession();
        } catch (Exception e) {
            throw new Wyjatek();
        }
        
        List list;
        Query query;
        
        try {
            /* Tu chc wyciagn z bazy te rekordy, ktre
             * w polu SLOWO_KLUCZOWE (SlowoKluczowe) maj klucz
             */
            query = sesja.createQuery("select b from shared.Branza " +
                                      "where b.SlowoKluczowe like :slowo");
            query.setParameter("slowo", '%'+klucz+'%');
            list = query.list();
            
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(sesja);
        }
        return list;
    }
    
    /**
     * wyszukanie korzenia katalogu bran
     * @return grup do ktrej podpite s porednio lub bezporednio
     * pozostae grupy i brane
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public Branza korzenKatalogu() throws Wyjatek {
        Session sesja;
        
        /* rozpoczynam now sesj z hibernatem */
        try {
            sesja = Hibcio.openSession();
        } catch (Exception e) {
            throw new Wyjatek();
        }
        
        List list;
        Query query;
        
        /* Najpierw wycign z bazy wszystkie brane
         * (zapominam na chwil o efektywnoci)
         */
        try {
            query = sesja.createQuery("from shared.Branza ");
            list = query.list();
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        
        Iterator iterator = list.iterator();
        List list1;

        /* Teraz znajd tak bran, ktra nie jest niczyim synem 
         * (te lepiej zapomnie o efektywnoci)
         */
        for (;iterator.hasNext();) {
            Branza b;
            try {
                query = sesja.createQuery("from shared.DrzewoBranz as d " +
                                          " where d.syn = :klucz");
                b = (Branza) iterator.next();
                query.setParameter("klucz", b);
                list1 = query.list();
            } catch (Exception e) {
                e.printStackTrace();
                throw new Wyjatek();
            }
            
            if (list1.isEmpty())
                return b;
        }
        
        /* Nie ma korzenia, niedobrze */
        throw new Wyjatek();
    }
    
    /**
     * Wyszukanie w bazie danych bran speniajcych zadane kryterium popularnoci
     * @param kryteria kryterium, ktre musi speniac brana, aby znale si w wyniku dziaania metody
     * @return list bran speniajcych zadane kryterium popularnoci
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public Statystyka najpopularniejszeBranze(KrytStat kryteria) throws Wyjatek {
        Session sesja;
        
        try {
            sesja = Hibcio.openSession();
        } catch (Exception e) {
            throw new Wyjatek();
        }
        
        List list;
        Query query;
        
        try {
            /* Tu chc wyciagn z bazy te rekordy, ktre
             * speniaj zadane kryterium
             */
            
            query = sesja.createQuery("select nb from shared.Branza");
            list = query.list();
        } catch (Exception e) {
            throw new Wyjatek();
        }
        
        Iterator iterator = list.iterator();
        Branza branza;
        
        Statystyka stat = new Statystyka();
        
        /* dla kadego uzyskanego elementu przez id przechodz do gownej tabeli */
        for (; iterator.hasNext();) {
            branza = (Branza) iterator.next();
            int i = 0;
            List ogloszenia;
                  
            try {
                query = sesja.createQuery("select o from shared.Ogloszenie where o.branza = :ident");
                query.setParameter("ident", branza.getId());
                ogloszenia = query.list();
            } catch (Exception e) {
                throw new Wyjatek();
            }
            
            Iterator iteratorOgl;
            
            iteratorOgl = ogloszenia.iterator();
            
            for (;iteratorOgl.hasNext();) {
                i += ((Ogloszenie) iteratorOgl.next()).getPopularnosc();
            }
            
            if (i >= kryteria.getKryterium().intValue())
                stat.dodajPare(new ParaBranzaPop(branza, i));
        }
        
        Hibcio.closeSession(sesja);
        return stat;
    }
    
    /**
     * Wydobycie z bazy poddrzewa, ktrego korzeniem jest zadana brana
     * @param branza {@see Branza}, ktra znajdzie si w korzeniu zwracanego drzewa
     * @return Poddrzewo ktrego korzeniem jest zadana brana
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public static EltKatBranz dajPoddrzewo(Branza branza) throws Wyjatek {
        Session sesja;
        Query query;
        List list;
        
        /* Wydobywam z bazy pary (syn, matka), aby dobra si 
         * do potomkw brany 
         */
        try {
            sesja = Hibcio.openSession();
            query = sesja.createQuery("select from shared.DrzewoBranz as d" +
                                          " where d.matka = :klucz");
                query.setParameter("klucz", branza);
                list = query.list();
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        List poddrzewa = new ArrayList();
        Iterator iterator = list.iterator();
        /* Przegladam potomkw i dla kadego tworz poddrzewo 
         * ktrego jest on korzeniem i dodaj otrzymane poddrzewo
         * do listy zwierajcej poddrzewa potomkw
         */
        for (;iterator.hasNext();) {
            Branza syn = ((DrzewoBranz) iterator.next()).getSyn();
            try {
                poddrzewa.add(KatalogBranz.dajPoddrzewo(syn));
            } catch (Wyjatek w) {
                throw w;
            }
        }
        return new EltKatBranz(branza, poddrzewa);     
    }
       
    /**
     * Dostp do penego katalogu bran
     * @return wszystkie grupy, brane i powizania midzy nimi w obiekcie klasy {@link ZawKataloguBranz}
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public KatalogBranzDrzewo dajZwartoscKataloguBranz() throws Wyjatek {
        Session sesja = null;
        Branza korzen;
        EltKatBranz drzewo;
        
        try {
            sesja = Hibcio.openSession();
       
            korzen = korzenKatalogu();
            drzewo = dajPoddrzewo(korzen);
            
            sesja.close();
            return new KatalogBranzDrzewo(drzewo);
        } catch (Exception w) {
            w.printStackTrace();
            try {
                sesja.close();
            } catch (Exception e1) {};
            throw new Wyjatek();
        }
    }
    
    /**
     * Dodaje do Katalogu Bran Brane z poddrzewa zadanego
     * jako parametr i zalenoci midzy nimi
     * @param nowy Poddrzewo z ktrego Brane zostan dodane do Katalogu Bran
     * @param matka Nadbrana poddrzewa zadanego parametrem nowy (null jeli jest to korze)
     * @param sesja Hibernatowa sesja w ktrej bd wykonywane operacje na bazie danych.
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public static void dodajDoKatalogu(EltKatBranz nowy, Object matka, Session sesja) throws Wyjatek {
        try {
            /* Wrzucam sam bran do bazy */
            sesja.saveOrUpdate(nowy.getBranza());
            /* Jeli to nie by korze to wrzucam par (syn, mataka) do bazy */
            if (matka != null)
                sesja.saveOrUpdate(new DrzewoBranz(nowy.getBranza(), (Branza) matka));
            /* Przegldam poddrzewa dzieci i zlecam wrzucenie ich do bazy */
            Iterator iterator = nowy.getDzieci().iterator();
            for (;iterator.hasNext();) 
                KatalogBranz.dodajDoKatalogu((EltKatBranz) iterator.next(), nowy.getBranza(), sesja);
        } catch (Exception e) {
            throw new Wyjatek();
        }
    }
    
    /**
     * Usunicie biecego Katalogu Bran i zastpienie go nowym ktry zostanie
     * stworzony z drzewa Bran zadanego jako parametr
     * @param nowy Drzewo bran, ktre znajdzie si zamiast biecego w bazie danych
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public static void zastapKatalogBranz(KatalogBranzDrzewo nowy) throws Wyjatek {
        Session sesja = null;
        
        try {
            sesja = Hibcio.openSession();
            sesja.beginTransaction();
            /* Usuwam biecy Katalog Bran */
            sesja.delete("from shared.DrzewoBranz");
            sesja.delete("from shared.Branza");
            /* Wrzucam do bazy nowy katalog, ktry zostanie utworzony z drzewa
             * zadanego przez parametr */
            KatalogBranz.dodajDoKatalogu(nowy.getKorzen(), null, sesja);
            Hibcio.commit(sesja);
        } catch (Exception e) {
            try {
                Hibcio.rollback(sesja);
            } catch (Exception e1) {}
            throw new Wyjatek();
        } finally {
            try {
                sesja.close();
            } catch (Exception e) {}
        }
    }
    
    /** 
     * Wygenerowanie pliku zawierajcego katalog bran w katalogu,
     * z ktrego bd mogy go pobra aplety i aplikacja administratora
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     */
    public void generujStatycznyKatalogBranz() throws Wyjatek {
        File dir;
        String nazwaKatalogu;
        KatalogBranzDrzewo katalogBranz = null;
        
        try {
            
            katalogBranz = dajZwartoscKataloguBranz();
            
            nazwaKatalogu = Jadro.getParametr("NIIKT_WWW") + File.separator + "katalog_branz";
            dir = new File(nazwaKatalogu);
            
            if (!dir.exists())
                if (!dir.mkdirs())
                    throw new Wyjatek();
            
            ObjectOutput out = 
                new ObjectOutputStream(
                    new FileOutputStream(nazwaKatalogu + File.separator + "katalog_branz.ser"));
            
            out.writeObject(katalogBranz);
            out.close();
            
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /**
     * Dodaje do Katalogu Bran now Bran
     * jako parametr i zalenoci midzy nimi
     * @param nowa Brana, ktra zostanie dodana do Katalogu Bran
     * @param matka Nadbrana dodawanej brany
     * @return Dodana do katalogu Brana
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public Branza dodajDoKatalogu(Branza nowa, Branza matka) throws Wyjatek {
        Session sesja = null;
        Transaction tx = null;
        try {
            sesja = Hibcio.openSession();
            tx = sesja.beginTransaction();
            sesja.save(nowa);
            if (matka != null) {
                sesja.save(new DrzewoBranz(nowa, matka));
            }
            tx.commit();
            return nowa;
        } catch (Exception e) {
            e.printStackTrace();
            try {
                tx.rollback();
            } catch (Exception e1) {}
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(sesja);
        }
    }
    
    /**
     * Dodaje now ga do Katalogu bran
     * @param nowa podbrana w gazi
     * @param matka nadbrana w gazi
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */
    public void dodajDoKataloguZaleznosc(Branza nowa, Branza matka) throws Wyjatek {
        Session sesja = null;
        try {
            sesja = Hibcio.openSession();
            sesja.save(new DrzewoBranz(nowa, matka));
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            Hibcio.closeSession(sesja);
        }
    }
    
    /** Wyszukanie w bazie bran o zadanej nazwie i sowie kluczowym
     * @param nazwa Nazwa poszukiwanej brany, null jeli nie jest istotna
     * @param klucz Sowo kluczowe opisujce poszukiwan bran, null jeli nie
     * jest istotne
     * @return List bran speniajcych zadane parametrami kryteria
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */
    public List wyszukajBranze(String nazwa, String klucz) throws Wyjatek {
        Session s;
        Query q;
        List ret = new ArrayList();
        try {
            s = Hibcio.openSession();
            
            StringBuffer sb = new StringBuffer("from shared.Branze as b");
            
            if ((nazwa != null) || (klucz != null)) {
                sb.append(" where ");
                
                if (nazwa != null) {
                    sb.append("(upper(b.nazwa) like upper('%" + nazwa + "%')");
                    if (klucz != null)
                        sb.append(" and ");
                }
                
                if (klucz != null) {
                    sb.append("(upper(b.slowokluczowe) like upper('%" + klucz + "%')");
                }
            }
            
            q = s.createQuery(sb.toString());
            ret = q.list();   
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        return ret;
    }
}
        