/*
 * KatalogNajpopularniejszych.java
 *
 * Created on 27 marzec 2004, 12:33
 */

package serwer.branze;
import shared.*;
import serwer.*;
import java.util.*;
import net.sf.hibernate.*;
import java.rmi.server.UnicastRemoteObject;

import java.io.File;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.FileOutputStream;


/**
 * Reprezentacja katalogu najpopularniejszych bra przechowywanego
 * w bazie danch
 * @author witus
 */
public class KatalogNajpopularniejszych 
    extends UnicastRemoteObject implements shared.InterfejsNajpopularniejszychBranz {
    
    /**
     * Zwraca katalog bran, ktry znajduje si w bazie dancy systemu
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */    
    public List katalog() throws Wyjatek {
        Session sesja;
        
        try {
            sesja = Hibcio.openSession();
        } catch (Exception e) {
            throw new Wyjatek();
        }
        
        List list;
        
        try {
            /* Chc wycign cay katalog najpopularniejszych branz
             * i byc moze polaczyc go z tabela zawierajaca wszystkie
             * branze
             */
            
            Query q = sesja.createQuery("select from shared.NajpopularniejszaBranza");
            list = q.list();
            
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(sesja);
        }
        
        return list;
    }
    
    /**
     * Tworzy nowy obiekt zarzdzajcy Katalogiem Bran
     * @throws java.rmi.RemoteException Potrzebny aby klasa implementowaa interfejs
     */        
    public KatalogNajpopularniejszych() throws java.rmi.RemoteException {
    }
    
    /**
     * Sprawdzenie czy Brana naley do Najpopularaniejszych Bran
     * @param branza Sprwadzana Brana
     * @param sesja Sesja Hibernate'a ktrej w ktrej dokonane zostanie
     * spawdzenie
     * @return True jeli Brana jest w Najpopularniejszych, false w przeciwnym
     * przypadku
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */ 
    public boolean jestNajpop(Branza branza, Session sesja) throws Wyjatek {
        
        try {
            Query q = sesja.createQuery("from shared.NajpopularniejszaBranza as nb" +
                                        " where nb.branza = :param");
            q.setParameter("param", branza);
            return (!q.list().isEmpty());
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /**
     * Pobranie z bazy listy bran wraz z ich popularnoci
     * @return Posortowan list zawierajc brane i ich popularnoci
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */ 
    public List getListaPopularnosci() throws Wyjatek {
        Session sesja = null;
        List listaWszystkich;
        List listaOgloszen;
        List ret = new ArrayList();
        
        try {
            sesja = Hibcio.openSession();
            Query q = sesja.createQuery("from shared.Branza ");
            listaWszystkich = q.list();
            Iterator iter = listaWszystkich.iterator();
            
            for (; iter.hasNext();) {
                Branza branza = (Branza) iter.next();
                if (jestNajpop(branza, sesja))
                    continue;
                NajpopularniejszaBranza nb = new NajpopularniejszaBranza();
                nb.setOpis(branza.getOpis());
                nb.setBranza(branza);
                nb.setRanking(0);
                Query q1 = sesja.createQuery("from shared.Ogloszenie as o where o.branza = :param");
                q1.setParameter("param", branza);
                listaOgloszen = q1.list();
                Iterator iter1 = listaOgloszen.iterator();
                
                for (; iter1.hasNext();) {
                    Ogloszenie ogloszenie = (Ogloszenie) iter1.next();
                    nb.setRanking(nb.getRanking() + ogloszenie.getRanking());
                }
                
                ret.add(nb);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
             
        Collections.sort(ret);
        return ret;
    }
    
    /** 
     * Wygenerowanie na serwerze pliku zawierajcego Katalog Najpopularniejszych
     * Bran, eby uytkownicy nie musieli za kadym razem odwoywa si do bazy
     * danych. Poza tym istnieje szansa, e przegldarka przechowa taki plik w
     * swoim cache'u.
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     * lub zapisywaniu pliku
     */
    public void wygenerujStatycznyKatalogNajpop() throws Wyjatek {
        File dir;
        String nazwaKatalogu;
        List katalogNajpopBranz = null;
        
        try {
            
            katalogNajpopBranz = katalog();
            
            nazwaKatalogu = Jadro.getParametr("NIIKT_WWW") + File.separator + "katalog_naj_branz";
            dir = new File(nazwaKatalogu);
            
            if (!dir.exists())
                if (!dir.mkdirs())
                    throw new Wyjatek();
            
            ObjectOutput out = 
                new ObjectOutputStream(
                    new FileOutputStream(nazwaKatalogu + File.separator + "katalog_naj_branz.ser"));
            
            out.writeObject(katalogNajpopBranz);
            out.close();
            
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /**
     * Usunicie starego Katalogu najpopularniejszych Bran i wstawienie nowego
     * @param nowyKatalog Katalog, ktry znajdzie si w bazie danych
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     */
    public void zamienKatalog(List nowyKatalog) throws Wyjatek {
        Session sesja = null;
        Transaction tn = null;
        try {
            sesja = Hibcio.openSession();
            tn = sesja.beginTransaction();
            
            sesja.delete("from shared.NajpopularniejszaBranza");
            
            Iterator iter = nowyKatalog.iterator();
            for (; iter.hasNext();) {      
                NajpopularniejszaBranza nb = (NajpopularniejszaBranza) iter.next();
                sesja.save(nb);
            }
            
            Hibcio.commit(sesja);
            sesja.close();
        } catch (Exception e) {
            e.printStackTrace();
            try {
                sesja.close();
            } catch (Exception e1) {}
            throw new Wyjatek();
        }
    }
    
}
 