/*
 * KontoAdministratora.java
 *
 * Created on 25 marzec 2004, 22:37
 */

package serwer.konto;

//import java.util.*;
import net.sf.hibernate.*;

import serwer.Jadro;
import shared.*;

import java.lang.String;
import serwer.Hibcio;

import java.rmi.server.UnicastRemoteObject;

/** KontoAdministratora udostpnia metody do obsugi konta (w szczeglnoci
 * hasa) administratora systemu.
 *
 * @author  ula
 */
public class KontoAdministratora 
    extends UnicastRemoteObject implements InterfejsKontoAdministratora {
    
    /** Tworzy nowy obiekt klasy KontoAdministratora. 
     *  @throws java.rmi.RemoteException przy problemie konstruowania interfejsu RMI
     */
    public KontoAdministratora() throws java.rmi.RemoteException {
    }
    
    /** Sprawdza poprawno hasa administratora.
     * @param haslo      sprawdzane haso
     *@return true, jeli haso jest poprawne
     *@throws Wyjatek gdy nie uda si wydoby hasa z bazy
     */
    public boolean autoryzacja(String haslo) throws Wyjatek {
        Session s = null;
        Query q;
        HasloAdmina h;
        
        try {
            s = Hibcio.openSession();
            //znajdz haslo admina
            q = s.createQuery("from shared.HasloAdmina ");
            h = (HasloAdmina) q.uniqueResult();
        } catch (Exception e) {       
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        if ((h.getHaslo().compareTo(haslo)) != 0)
            return false;
        else
            return true;
    }
    
    /** Zmienia haso administratora.
     * @param stare     stare haso
     * @param nowe      nowe haso
     *@throws Wyjatek gdy nie uda si wydoby hasa z bazy
     */
    public void zmienHaslo(String stare, String nowe) throws Wyjatek {
        Session s = null;
        Query q;
        HasloAdmina h;
        
        try {
            s = Hibcio.openSession();
            //znajdz haslo admina
            q = s.createQuery("from shared.HasloAdmina ");
            h = (HasloAdmina) q.uniqueResult();
        } catch (Exception e) {       
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        
        //spr czy stare haslo dobrze podane
        if ((h.getHaslo().compareTo(stare)) != 0)
            throw new Wyjatek();
        else {
            // stare=OK wstawiamy nowe do bazy
            h.setHaslo(nowe);
            try {
                s = Hibcio.openSession();
                s.saveOrUpdate(h);
            } catch (Exception e) {       
                throw new Wyjatek();
            } finally {
                Hibcio.closeSession(s);
            }
        };    
    }
    
}
