/*
 * Mail.java
 *
 * Created on 9 kwiecie 2004, 15:00
 */

package serwer.mail;

import serwer.Jadro;
import javax.mail.*;
import javax.mail.internet.*;
import java.util.*;
import java.io.*;


/** Obiekty klasy Mail su do automatycznego wysyania maili do klientw
 * aplikacji.
 *
 * @author  ula
 */
public class Mail {
    
    /** Tworzy nowy obiekt klasy Mail. */
    public Mail() {
    }
    
    /** Metody zwiazane z wysylaniem maili na konkretny adres;
     * zrodlo: http://www.javacommerce.com/articles/sendingmail.htm.
     *
     *@param recipients     lista odbiorcw
     *@param subject        temat wiadomoci
     *@param message        tekst wiadomoci
     *@param from           adres nadawcy
     *
     *@throws MessagingException gdy nie uda si wysa wiadomoci
     */
    
    
    public void postMail( String recipients[], String subject, String message, String from) throws MessagingException {
        boolean debug = false;
        
        //Set the host smtp address
        Properties props = new Properties();
        //props.put("mail.smtp.host", "smtp.jcom.net");
        props.put("mail.smtp.host", Jadro.getParametr("NIIKT_SMTP"));
        
        // create some properties and get the default Session
        Session session = Session.getDefaultInstance(props, null);
        session.setDebug(debug);
        
        // create a message
        Message msg = new MimeMessage(session);
        
        // set the from and to address
        InternetAddress addressFrom = new InternetAddress(from);
        msg.setFrom(addressFrom);
        
        InternetAddress[] addressTo = new InternetAddress[recipients.length];
        for (int i = 0; i < recipients.length; i++) {
            addressTo[i] = new InternetAddress(recipients[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, addressTo);
        
        
        // Optional : You can also set your custom headers in the Email if you Want
        // msg.addHeader("myHeaderName", "myHeaderValue");
        
        // Setting the Subject and Content Type
        msg.setSubject(subject);
        msg.setContent(message, "text/plain; charset=iso-8859-2;");
        Transport.send(msg);
        
    }
    
}
