/*
 * SendMailUsingAuthentication.java
 *
 * Created on 30 kwiecie 2004, 14:20
 */

package serwer.mail;

import serwer.Jadro;
import javax.mail.*;
import javax.mail.internet.*;
import java.util.*;
import java.io.*;

/**Obiekty klasy SendMailUsingAuthentication su do automatycznego wysyania maili do klientw
 * aplikacji, jeli wymagane jest haso do autoryzacji.
 *
 * @author  ula
 */
public class SendMailUsingAuthentication {
    
    /** Creates a new instance of SendMailUsingAuthentication. */
    public SendMailUsingAuthentication() {
    }
    
    /** Metody zwiazane z wysylaniem maili na konkretny adres;
     * zrodlo: http://www.javacommerce.com/articles/sendingmail.htm.
     *
     *@param recipients     lista odbiorcw
     *@param subject        temat wiadomoci
     *@param message        tekst wiadomoci
     *@param from           adres nadawcy
     *
     *@throws MessagingException gdy nie uda si wya wiadomoci
     */
  public void postMail( String recipients[ ], String subject,
                            String message , String from) throws MessagingException
  {
    boolean debug = false;

     //Set the host smtp address
     Properties props = new Properties();
     //props.put("mail.smtp.host", SMTP_HOST_NAME);
     props.put("mail.smtp.host", Jadro.getParametr("NIIKT_SMTP"));
     props.put("mail.smtp.auth", "true");

    Authenticator auth = new SMTPAuthenticator();
    System.out.println("MAIL mamy autenticator");
    Session session = Session.getDefaultInstance(props, auth);

    session.setDebug(debug);
    System.out.println("MAIL session utworzona");
    // create a message
    Message msg = new MimeMessage(session);
    System.out.println("MAIL msg utworzona");
    // set the from and to address
    InternetAddress addressFrom = new InternetAddress(from);
    msg.setFrom(addressFrom);

    InternetAddress[] addressTo = new InternetAddress[recipients.length];
    for (int i = 0; i < recipients.length; i++)
    {
        addressTo[i] = new InternetAddress(recipients[i]);
    }
    msg.setRecipients(Message.RecipientType.TO, addressTo);

    System.out.println("MAIL ustaleni adresaci");
    // Setting the Subject and Content Type
    msg.setSubject(subject);
    msg.setContent(message, "text/plain");
    System.out.println("MAIL ustalona cala wiadomosc");
    Transport.send(msg);
    System.out.println("MAIL wyslana");
 }

/**
* SimpleAuthenticator is used to do simple authentication
* when the SMTP server requires it.
 *
 *@author  ula
*/
private class SMTPAuthenticator extends javax.mail.Authenticator
{

    public PasswordAuthentication getPasswordAuthentication()
    {
        String username = Jadro.getParametr("NIIKT_AUTH_USER");
        String password = Jadro.getParametr("NIIKT_AUTH_PWD");
        return new PasswordAuthentication(username, password);
    }
}  
  
}
