/*
 * Mapy.java
 *
 * Created on 20 marzec 2004, 14:01
 */

package serwer.mapa;

import java.util.*;
import net.sf.hibernate.*;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.awt.Point;
import java.io.File;

import serwer.Hibcio;
import serwer.Jadro;
import serwer.mapa.*;
import shared.*;

/** Mapy dostarcza operacji na warstwach mapy. Celem drobnej optymalizacji obiekt 
 *  przy inicjalizacji wczytuje z bazy danych zapamitane w niej warstwy.
 *
 * @author  me201258
 */
public class Mapy
  extends UnicastRemoteObject implements InterfejsMapy {
    
    /** Warstwy mapy w systemie. 
     */
    private WarstwaMapy[] warstwy;
    
    /** Wczytuje z bazy danych wszystkie warstwy.
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    private void pobierzWarstwy() throws Wyjatek {
        Session sesja = null;
        List w;

        try {
            sesja = Hibcio.openSession();
            w = sesja.find("from shared.WarstwaMapy as wm order by wm.skala asc");
            warstwy = (WarstwaMapy[]) w.toArray(new WarstwaMapy[w.size()]);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(sesja);
        }
    }
    
    /** Tworzy now instancj klasy i wczytuje obiekty typu {@link WarstwaMapy} z bazy.
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException w przypadku bdy inicjalizacji struktur sieciowych
     */
    public Mapy() throws Wyjatek, RemoteException {
        pobierzWarstwy();
    }

    /** Zwraca posortowan wzgldem skali list wszystkich znanych obiektw typu {@link WarstwaMapy}.
     *  @return lista wszystkich warstw */
    public WarstwaMapy[] warstwy() {
        return warstwy;
    }

    /** Przygotowuje i zwraca obiekt zarzdzania warstw mapy {@link ZarzWarstwaMapy}. 
     *  @param warstwa warstwa, ktr chcemy zarzdza 
     *  @return obiekt zarzdzania warstw mapy
     */
    public ZarzWarstwaMapy zarzWarstwaMapy(WarstwaMapy warstwa) {
        ZarzWarstwaMapy zarz = new ZarzWarstwaMapy();

        zarz.setWarstwa(warstwa);
        return zarz;
    }
    
    /** Zapamituje w bazie danych warstw mapy. 
     *  @param warstwa warstwa mapy 
     *  @throws Wyjatek w przypadku bdu tworzenia katalogu warstwy lub bdu bazy danych
     */
    public void zapiszWarstwe(WarstwaMapy warstwa) throws Wyjatek {
        Session s = null;
        Transaction tx = null;
        File dir;
        int i;
        String poczNazwy;
        
        if (warstwa.getOpis() == "" || warstwa.getSkala() == 0)
            throw new Wyjatek();
        try {
            s = Hibcio.openSession();
            tx = s.beginTransaction();
            s.saveOrUpdate(warstwa);
            poczNazwy = Jadro.getParametr("NIIKT_WWW") + File.separator + "mapy" + File.separator + warstwa.getId();
            dir = new File(poczNazwy);
            if (!dir.exists())
                if (!dir.mkdirs())
                    throw new Wyjatek();
            for (i=0;i<=9;i++) {
                dir = new File(poczNazwy + File.separator + i);
                if (!dir.exists())
                    if (!dir.mkdirs())
                        throw new Wyjatek();
            }
            tx.commit();
        } catch (Exception e) {
            try {
                tx.rollback();
            } catch (Exception e2) {
            }
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        warstwy = null;
        pobierzWarstwy();
    }

    /** Do zadanego zestawu ogosze dobiera fragment mapy (i tym samym odpowiedni warstw),
     *  ktry bdzie najwaciwszy do zaprezentowania tego zestawu.
     *  @param ogloszenia lista ogosze, dla ktrych szukamy fragmentu 
     *  @return najwaciwszy fragment mapy
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public FragmentMapy wybierzNajlepszyFragment(List ogloszenia) throws Wyjatek {
        ListIterator oli = ogloszenia.listIterator();
        int wli;
        Ogloszenie ogl;
        Point lg,pd;
        WarstwaMapy biez, najlepsza = null;
        ZarzWarstwaMapy zarz;
        int ilePotrzebaFr=999, tmp;
        Point pkt;
        FragmentMapy ret;
        
//        System.out.println("-------------------Wybierz najlepszy fragment");
        if (oli.hasNext() && warstwy.length > 0) {
//            System.out.println(" -wyliczamy kwadrat");
            //najpierw znajdziemy kwadrat, w ktrym siedz wszystkie przekazane ogoszenia
            ogl = (Ogloszenie) oli.next();
            lg = new Point(ogl.getWspolrzedna_x(),ogl.getWspolrzedna_y());
            pd = new Point(lg);
//            System.out.println("  -ogoszenie ["+ogl.getId()+"]:"+ogl.getWspolrzedna_x()+","+ogl.getWspolrzedna_y()+"   ->"+lg+","+pd);
            while (oli.hasNext()) {
                ogl = (Ogloszenie) oli.next();
                if (ogl.getWspolrzedna_x() < lg.getX())
                    lg.x = ogl.getWspolrzedna_x();
                if (ogl.getWspolrzedna_x() > pd.getX())
                    pd.x = ogl.getWspolrzedna_x();
                if (ogl.getWspolrzedna_y() < lg.getY())
                    lg.y = ogl.getWspolrzedna_y();
                if (ogl.getWspolrzedna_y() > pd.getY())
                    pd.y = ogl.getWspolrzedna_y();
//                System.out.println("  -ogoszenie ["+ogl.getId()+"]:"+ogl.getWspolrzedna_x()+","+ogl.getWspolrzedna_y()+"   ->"+lg+","+pd);
            }
            //znajdujemy najfajniejsz warstw dla wyliczonego kwadratu
            for (wli=0;wli<warstwy.length;wli++) {
//                System.out.println("iterujemy po warstwach");
                biez = warstwy[wli];
                zarz = zarzWarstwaMapy(biez);
                
                //wyliczamy jaki kwadrat ma rozmiar w skali tej warstwy
                pkt = zarz.bezwzgledneNaWzgledne(new Point((int) (pd.x-lg.x),(int) (pd.y-lg.y)));
//                System.out.println(" warstwa #"+wli+", id:"+biez.getId()+", skala:"+biez.getSkala());
//                System.out.println(" wielk. kwadr. ->"+pkt);
                //przeliczamy to na potrzebn liczb fragmentw mapy
                pkt = new Point((int) (pkt.x/biez.getRozmiar_x() + 1),(int) (pkt.y/biez.getRozmiar_x()));
//                System.out.println(" potrzeba tym samym: "+pkt);
                //bierzemy wiksz wsprzdn
                tmp = Math.max(pkt.x, pkt.y);
                //jeli to lepiej ni mamy, poprawiamy
                if (najlepsza == null) {
                    najlepsza = biez;
                    ilePotrzebaFr = tmp;
//                    System.out.println("->wzilimy!");
                } else {
                    //lepiej <=> mniej fragmentw (o ile byo wicej ni 3)
                    if ((ilePotrzebaFr > tmp) && (ilePotrzebaFr > 2)) {
                        najlepsza = biez;
                        ilePotrzebaFr = tmp;
//                        System.out.println("->wzilimy!");
                    }
                }
            }
            //znajdujemy na wybranej warstwie najlepszy fragment
            //najlepszy = zawierajcy rodek wyszukanego kwadratu opinajcego wszystkie ogoszenia
            zarz = (ZarzWarstwaMapy) zarzWarstwaMapy(najlepsza);
//            System.out.println("znajdziemy fragment dla wsp."+new Point((lg.x+pd.x)/2, (lg.y+pd.y)/2));
//            System.out.println("   czyli wzgl.: "+ zarz.bezwzgledneNaWzgledne(new Point((lg.x+pd.x)/2, (lg.y+pd.y)/2)));
            try {
                ret = zarz.znajdzFragment(new Point((lg.x+pd.x)/2, (lg.y+pd.y)/2));
            } catch (Wyjatek w) {
                ret = null;
            }
        } else { //przysza pusta lista ogosze lub nie mamy adnych warstw
            throw new Wyjatek();
        }
        return ret;
    }
    
    /** Znajduje zadan liczb ssiadujcych fragmentw mapy takich, e zadany 
     *  punkt centralny wypada mniej wicej centralnie zestawu.
     *  @param warstwa warstwa mapy, ktrej rzecz dotyczy
     *  @param ile pierwiastek z liczby fragmentw do znalezienia
     *  @param centralnyPkt centralny punkt w szukanym zestawie fragmentw mapy
     *  @return tablica fragmentw mapy
     */
    public FragmentMapy[] pobierzFragmenty(WarstwaMapy warstwa, int ile, Point centralnyPkt) {
        return zarzWarstwaMapy(warstwa).pobierzFragmenty(ile, centralnyPkt);
    }

    /** Zapamituje w bazie danych fragmenty mapy wygenerowane z podanego obrazka.
     *  @param warstwa  warstwa, na ktrej ma by dodany fragment
     *  @param bazowy   okrela fragment, z ktrym ssiaduje nowy (moe by null, jeli gdzieX == gdzieY == 0)
     *  @param gdziex   przesunicie na wsprzdnej x mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param gdziey   przesunicie na wsprzdnej y mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param offsetx  przesunicie w pikselach na wsprzdnej x wzgldem lewego grnego rogu obrazka. okrela punkt, z ktrego naley zacz wycinanie fragmentw mapy
     *  @param offsety  przesunicie w pikselach na wsprzdnej y wzgldem lewego grnego rogu obrazka. okrela punkt, z ktrego naley zacz wycinanie fragmentw mapy
     *  @param obraz    obrazek reprezentujcy mapk
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @return liczba wyuskanych z obrazka fragmentw mapy
     */
    public int zapiszFragment(WarstwaMapy warstwa, FragmentMapy bazowy, int gdziex, int gdziey, int offsetx, int offsety, PlikGraficzny obraz) throws Wyjatek {
    	return zarzWarstwaMapy(warstwa).zapiszFragment(bazowy, gdziex, gdziey, offsetx, offsety, obraz);
    }
    
    /** Przesuwa na podanej warstwie lokalizacj punktu 0,0, uaktualniajc informacj o
     *  wszystkich fragmentach mapy na warstwie.
     *  @param warstwa warstwa, na ktrej przesuwamy 0,0
     *  @param offsetx przesunicie w punktach wzgldnych na osi x
     *  @param offsety przesunicie w punktach wzgldnych na osi y
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void przesun00(WarstwaMapy warstwa, int offsetx, int offsety) throws Wyjatek {
        zarzWarstwaMapy(warstwa).przesun00(offsetx, offsety);
    }
    
}
