/*
 * Ulice.java
 *
 * Created on 20 marzec 2004, 14:45
 */

package serwer.mapa;

import shared.*;
import serwer.Hibcio;

import net.sf.hibernate.*;
import java.util.List;
import java.awt.Point;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;

/** Ulice dostarczaj zestawu operacji operujcych na zbiorze wszystkich ulic
 *  pamitanych przez system.
 *
 * @author  me201258
 */

public class Ulice 
    extends UnicastRemoteObject implements InterfejsUlice {

    /** Tworzy nowy obiekt tej klasy. 
     *  @throws RemoteException w przypadku bdy inicjalizacji struktur sieciowych
     */
    public Ulice() throws java.rmi.RemoteException {
    }
    
    /** Zwraca obiekt umoliwiajcy wykonywanie operacji na ulicy. 
     *  @param ulica ulica, ktr chcemy zarzdza
     *  @return obiekt zarzdzania ulic
     */
    public ZarzUlica zarzUlica(Ulica ulica) {
        ZarzUlica zarz = new ZarzUlica();
        
        zarz.setUlica(ulica);
        return zarz;
    }
    
    /** Wyszukuje i zwraca ulice odpowiadajce podanej nazwie. 
     *  @param nazwa nazwa ulicy, ktrej szukamy 
     *  @return lista znalezionych ulic 
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public List znajdzUlice(String nazwa) throws Wyjatek {
        Session s = null;
        Query q;
        List ret;
        String dNazwa;
        
        dNazwa = nazwa.toLowerCase(); //pozbywamy si duych polskich liter, ktrych postgres nie obsuguje w upper()
        if (nazwa.length() == 0)
                throw new Wyjatek();
        try {
            s = Hibcio.openSession();
            ret = s.find("from shared.Ulica as u " +
                        "where upper(u.nazwa) = upper('"+dNazwa+"')");
            if (ret.size() == 0) //sprbujemy szuka w przyblieniu
                ret = s.find("from shared.Ulica as u " +
                            "where upper(u.nazwa) like upper('%"+dNazwa+"%') order by u.nazwa asc");
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        return ret;
    }
    
    /** Usuwa podan ulic oraz wszystkie waciwe jej fragmenty ulic.
     *  @param ulica ulica do usunicia 
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void usunUlice(Ulica ulica) throws Wyjatek {
        Session s = null;
        Transaction tx = null;
        
        try {
            s = Hibcio.openSession();
            tx = s.beginTransaction();
            ulica = (Ulica) (s.find("from shared.Ulica as ul where ul.id = "+ulica.getId())).get(0);
            s.delete("from shared.FragmentUlicy as fu where fu.idUlicy = ?", ulica, Hibernate.entity(Ulica.class));
            s.delete(ulica);
            tx.commit();
            Hibcio.closeSession(s);
        } catch (Exception e) {
            e.printStackTrace();
            try {if (tx!= null) tx.rollback();} catch (Exception e2) {}
            Hibcio.closeSession(s);
            throw new Wyjatek();
        }
    } 
    
    /** Dodaje do bazy danych now ulic.
     *  @param ulica ulica do dodania 
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void dodajUlice(Ulica ulica) throws Wyjatek {
        Session s = null;
        
        try {
            s = Hibcio.openSession();
            s.save(ulica);
            Hibcio.commit(s);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
    }
    
    /** Wyszukuje wszystkie ulice, ktre przechodz przez obszar ograniczony zadanymi wsprzdnymi.
     *  @param  gl   wsprzdne lewego grnego rogu obszaru
     *  @param  dp   wsprzdne dolnego prawego rogu obszaru 
     *  @return lista znalezionych ulic 
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public List znajdzUliceWOkolicy(Point gl, Point dp) throws Wyjatek {
        Session s = null;
        Query q;
        List ret;
        
        try {
            s = Hibcio.openSession();
            //wymaga dopieszczenia - nie uwzgldnia ulic, ktre nie maj punktw przeamania wewntrz obszaru
            q = s.createQuery("select distinct ul " +
                              "from shared.FragmentyUlicy fu inner join fu.idUlicy " +
                              " where ( (fu.wsp_konc_x between :glx and :dpx and fu.wsp_konc_y between :gly and :dpy) " + //koniec wewntrz
                              "  or (fu.wsp_pocz_x between :glx and :dpx and fu.wsp_pocz_y between :gly and :dpy) "+ //pocztek wenrz
                              " )");
            q.setParameter("glx", new Integer(gl.x));
            q.setParameter("gly", new Integer(gl.y));
            q.setParameter("dpx", new Integer(dp.x));
            q.setParameter("dpy", new Integer(dp.y));
            ret = q.list();
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        return ret;
    }
    
    /** Pobiera wszystkie fragmenty ulicy.
     *  @param ulica ulica, ktrej fragmentw szukamy
     *  @return tablcia fragmentw ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public FragmentUlicy[] znajdzFragmentyUlicy(Ulica ulica) throws Wyjatek {
        return zarzUlica(ulica).getFragmenty();
    }
    
    /** Zmienia nazw ulicy.
     *  @param ulica ulica, ktrej nazw zmieniamy
     *  @param nazwa nowa nazwa dla ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void zmienNazweUlicy(Ulica ulica, String nazwa) throws Wyjatek {
        zarzUlica(ulica).zmienNazwe(nazwa);
    }
    
    /** Zapamituje nowy przebieg ulicy, kasujc dotychczasowy.
     *  @param ulica zmieniana ulica
     *  @param fr tablica nowych fragmentw podanej ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void zapiszPrzebiegUlicy(Ulica ulica, FragmentUlicy[] fr) throws Wyjatek {
        zarzUlica(ulica).zmienPrzebiegUlicy(fr);
    }
    
}
