/*
 * ZarzFragmentMapy.java
 *
 * Created on 20 marzec 2004, 14:45
 */

package serwer.mapa;

import java.util.List;
import java.awt.Point;

import shared.*;
import serwer.Jadro;

/** ZarzFragmentMapy to jedyny obiekt umoliwiajcy wykonywanie wszelkich czynnoci
 *  administracyjnych zwizanych z fragmentem mapy ({@link FragmentMapy}).
 *
 * @author  me201258
 */
public class ZarzFragmentMapy {
    
    private FragmentMapy fragment;
    
    /** Tworzy nowy obiekt tej klasy. */
    public ZarzFragmentMapy() {
    }
    
    /** Zapamituje fragment mapy. 
     *  @param frm fragment mapy do zapamitania
     *  @see #getFragment
     */
    public void setFragment(FragmentMapy frm) {
        fragment = frm;
    }
    
    /** Podaje zapamitany fragment mapy. 
     *  @return zapamitany fragment mapy
     *  @see #setFragment
     */
    public FragmentMapy getFragment() {
        return fragment;
    }
    
    /** Wyszukuje wszystkie ulice, ktre przechodz przez ten fragment mapy.
     *  @return lista ulic
     *  @throws Wyjatek w przypadku bdy bazy danych
     */
    public List znajdzUlice() throws Wyjatek {
        ZarzWarstwaMapy zarz = new ZarzWarstwaMapy();
        zarz.setWarstwa(fragment.getIdWarstwy());
        return Jadro.ulice
            .znajdzUliceWOkolicy(
                zarz.wzgledneNaBezwzgledne(new Point(fragment.getWsp_lg_x(), fragment.getWsp_lg_y())),
                zarz.wzgledneNaBezwzgledne(new Point(fragment.getWsp_pd_x(), fragment.getWsp_pd_y()))
            );
    }
}
