/*
 * ZarzUlica.java
 *
 * Created on 20 marzec 2004, 14:45
 */

package serwer.mapa;

import java.awt.Point;
import net.sf.hibernate.*;
import java.util.*;

import shared.*;
import serwer.Hibcio;

/** ZarzUlica to jedyny obiekt umoliwiajcy wykonywanie wszelkich czynnoci
 *  administracyjnych zwizanych z pojedyncz ulic ({@link Ulica}).
 *
 * @author  me201258
 */

public class ZarzUlica {
    
    private Ulica ulica;
    
    /** Tworzy nowy obiekt tej klasy. */
    public ZarzUlica() {
    }
    
    /** Zapamituje ulic.
     *  @param nowa ulica do zapamitania
     *  @see #getUlica
     */
    public void setUlica(Ulica nowa) {
        ulica = nowa;
    }
    
    /** Podaje zapamitan ulic. 
     *  @return zapamitana ulica
     *  @see #setUlica
     */
    public Ulica getUlica(){
        return ulica;
    }
    
    
    /** Wyszukuje wsprzdne zadanego numeru na danej ulicy (jeli podany numer jest zerem,
     *  to metoda zwraca wsprzdne rodka ulicy.
     *  @param nrDomu numer domu do wyszukania lub zero, jeli szukamy rodka ulicy
     *  @return wsprzdne obiektu lub null, gdy ulica nie zawiera podanego numeru
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public Point wspolrzedneObiektu(int nrDomu) throws Wyjatek {
        if (nrDomu<0) return null;
        
        if (nrDomu>0) {
            FragmentUlicy fr;

            fr = znajdzFragment(nrDomu);

            return (fr != null ? PomocnikMapy.wspolrzedneObiektu(fr, nrDomu) : null);
        } else { //nrDomu ==0 szukamy rodka ulicy
            FragmentUlicy[] frs;
            int wybrany = -1;
            frs = getFragmenty();
            if (frs.length == 0) return null;
            int i;
            nrDomu = 1+(Math.max(Math.max(frs[frs.length-1].getNr_konc(),frs[frs.length-1].getNr_pocz()), Math.max(frs[0].getNr_konc(),frs[0].getNr_pocz()))
                       -Math.min(Math.min(frs[frs.length-1].getNr_konc(),frs[frs.length-1].getNr_pocz()), Math.min(frs[0].getNr_konc(),frs[0].getNr_pocz())))/2;
            for (i = 0; i< frs.length; i++) {
                if ((frs[i].getNr_pocz() <= nrDomu && frs[i].getNr_konc() >= nrDomu)
                    || (frs[i].getNr_konc() <= nrDomu && frs[i].getNr_pocz() >= nrDomu)) {
                    return PomocnikMapy.wspolrzedneObiektu(frs[i], nrDomu);
                }
            }
            //to raczej nie nastpi
            return null;
        }
    }
    
    /** Dodaje do systemu nowy fragment ulicy. 
     *  @param fragment fragment do dodania 
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void dodajFragment(FragmentUlicy fragment) throws Wyjatek{
        Session s = null;
        
        try {
            s = Hibcio.openSession();
            s.saveOrUpdate(fragment);
            Hibcio.commit(s);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
    }
    
    /** Usuwa z systemu zadany fragment ulicy. 
     *  @param fragment fragment do usunicia
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public synchronized void usunFragment(FragmentUlicy fragment) throws Wyjatek {
        Session s = null;
        
        try {
            s = Hibcio.openSession();
            s.delete(fragment);
            Hibcio.commit(s);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
    }
    
    /** Odnajduje fragment ulicy, na ktrym znajduje si zadany numer domu. 
     *  @param nrDomu poszukiwany numer domu
     *  @return waciwy fragment ulicy lub null, gdy ulica nie zawiera podanego numeru
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public FragmentUlicy znajdzFragment(int nrDomu) throws Wyjatek{
        Session s = null;
        FragmentUlicy fr = null;
        List l;
        
        try {
            s = Hibcio.openSession();
            l = s.find("from shared.FragmentUlicy as fu " +
                        "where fu.idUlicy = ? " +
                        " and (("+nrDomu+" between fu.nr_pocz and fu.nr_konc) or " +
                        " ("+nrDomu+" between fu.nr_konc and fu.nr_pocz))", ulica, Hibernate.entity(Ulica.class));
            if (l.size() > 0)
                fr = (FragmentUlicy) l.get(0);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally { 
            Hibcio.closeSession(s);
        }
        return fr;
    }
    
    /** Zmienia nazw tej ulicy na zadan.
     *  @param nazwa nowa nazwa ulicy
     *  @return obiekt ulicy z now nazw 
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public synchronized Ulica zmienNazwe(String nazwa) throws Wyjatek {
        Session s = null;
        ulica.setNazwa(nazwa);
        
        try {
            s = Hibcio.openSession();
            s.saveOrUpdate(ulica);
            Hibcio.commit(s);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        return ulica;
    }

    /** Odnajduje wszystkie fragment ulicy, zwizane z t ulic. 
     *  @return znalezione fragmenty ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public FragmentUlicy[] getFragmenty() throws Wyjatek{
        Session s = null;
        FragmentUlicy[] ret;
        List l;
        
        try {
            s = Hibcio.openSession();
            Query q = s.createQuery("from shared.FragmentUlicy as fu " +
                                "where fu.idUlicy = :idu order by fu.nr_pocz asc");
            q.setParameter("idu", ulica);
            l = q.list();
            ret = (FragmentUlicy[]) l.toArray(new FragmentUlicy[l.size()]);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        } finally { 
            Hibcio.closeSession(s);
        }
        return ret;
    }
    
    /** Zapamituje nowy przebieg ulicy, kasujc dotychczasowy.
     *  @param fr tablica nowych fragmentw podanej ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void zmienPrzebiegUlicy(FragmentUlicy[] fr) throws Wyjatek {
        //TODO: zaktualizowa lokalizacj firm z katalogu, mieszczcych si pod zmienian ulic
        Session s = null;
        int i;
        Transaction tx = null;
        
        try {
            s = Hibcio.openSession();
            tx = s.beginTransaction();
            s.delete("from shared.FragmentUlicy as fu where fu.idUlicy = ?", ulica.getId(), Hibernate.INTEGER);
            for (i = 0; i<fr.length; i++)
                s.save(fr[i]);
            tx.commit();
        } catch (Exception e) {
            try {if (tx != null) tx.rollback();} catch (Exception e2) {e2.printStackTrace();};
            e.printStackTrace();
            throw new Wyjatek();
        } finally {
            try {Hibcio.commit(s);} catch (Exception e2) {}
            Hibcio.closeSession(s);
        }
    }
}
