/*
 * ZarzWarstwaMapy.java
 *
 * Created on 20 marzec 2004, 14:02
 */

package serwer.mapa;

import net.sf.hibernate.*;
import java.awt.Point;
import java.io.File;
import java.awt.image.*;

import shared.*;
import serwer.Hibcio;
import serwer.Jadro;

/** ZarzWarstwaMapy to jedyny obiekt umoliwiajcy wykonywanie wszelkich czynnoci
 *  administracyjnych zwizanych z warstw mapy ({@link WarstwaMapy}).
 *
 * @author  me201258
 */
public class ZarzWarstwaMapy {

    private WarstwaMapy warstwa;
    
    /** Pobiera zapamitany obiekt klasy {@link WarstwaMapy}.
     *  @return warstwa
     *  @see #setWarstwa
     */
    public WarstwaMapy getWarstwa() {
        return warstwa;
    }
    
    /** Zapamituje przekazany obiekt klasy {@link WarstwaMapy}.
     *  @param nowa warstwa mapy do zapamitania 
     *  @see #getWarstwa
     */
    public void setWarstwa(WarstwaMapy nowa) {
        warstwa = nowa;
    }

    /** Tworzy nowy obiekt ZarzWarstwaMapy. */
    public ZarzWarstwaMapy() {
    }
    
    /** Tworzy nazw pliku, pod ktrym bdzie zapamietany obazek fragmentu mapy.
     *  @param frm fragment mapy, ktry chcemy zapisa
     *  @return nazwa pliku
     */
    private String skonstruujNazwePlikuFrMapy(FragmentMapy frm) {
        return Jadro.getParametr("NIIKT_WWW") + File.separator + 
                PomocnikMapy.wzglednaNazwaFrMapy(frm, File.separator);
    }
    
    /** Zapisuje na serwerze plik graficzny skojarzony z podanym fragmentem mapy.
     *  @param fr fragment mapy, ktrego dotyczy operacja
     *  @param pg plik graficzny do zapamitania */
    private void umiescPlikSieciowy(FragmentMapy fr, PlikSieciowy pg) throws Wyjatek {
        pg.zapiszSie(skonstruujNazwePlikuFrMapy(fr));
    }
    
    /** Przelicza bezwzgldne wsprzdne na wsprzdne zwizane z warstw mapy ({@link WarstwaMapy}).
     *  @param p   wsprzdne bezwzgldne
     *  @return    wsprzdne wzgldne (na warstwie)
     */
    public Point bezwzgledneNaWzgledne(Point p) {
        return PomocnikMapy.bezwzgledneNaWzgledne(warstwa, p);
    }
    
    /** Przelicza wzgldne wsprzdne (zwizane z warstw mapy) na wsprzdne bezwzgldne.
     *  @param p   wsprzdne wzgldne (na warstwie)
     *  @return    wsprzdne bezwzgldne
     */
    public Point wzgledneNaBezwzgledne(Point p) {
        return PomocnikMapy.wzgledneNaBezwzgledne(warstwa, p);
    }
    
    /** Na podstawie bezwzgldnych (niezalenych od skali tej warstawy mapy) odnajduje
     *  fragment mapy, na ktrym znale mona zadany punkt.
     *
     * @param p     wsprzdne (niezalene od skali) szukanego punktu
     * @return      waciwy fragment mapy
     * @throws Wyjatek w przypadku braku waciwego fragmentu lub bdu bazy danych
     */
    public FragmentMapy znajdzFragment(Point p) throws Wyjatek {
        return znajdzFragmentWzgl(bezwzgledneNaWzgledne(p));
    }
    
    /** Na podstawie wzgldnych odnajduje fragment mapy, na ktrym znale mona zadany punkt.
     *  Rzuca wyjtek, jeli wystpi bd lub nie istnieje odpowiedni fragment.
     *
     * @param pwzgl    wzgldne wsprzdne szukanego punktu
     * @return      waciwy fragment mapy
     * @throws Wyjatek w przypadku braku waciwego fragmentu lub bdu bazy danych
     */
    public FragmentMapy znajdzFragmentWzgl(Point pwzgl) throws Wyjatek {
        FragmentMapy ret = null;
        Session s = null;
        java.util.List l;
        
        try {
            s = Hibcio.openSession();
            l = s.find("from shared.FragmentMapy as fm " +
                                "where fm.idWarstwy = ? " +
                                " and ("+pwzgl.getX()+" between wsp_lg_x and wsp_pd_x)" +
                                " and ("+pwzgl.getY()+" between wsp_lg_y and wsp_pd_y)",
                                warstwa, Hibernate.entity(WarstwaMapy.class));
            if (l.size() == 0)
                throw new Wyjatek();
            ret = (FragmentMapy) l.get(0);
        } catch (Exception e){
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
        return ret;
    }
    
    /** Tworzy i dodaje do bazy danych nowy fragment mapy na tej warstwie. Metoda sama wylicza i ustawia
     *  wszystkie atrybuty dodawanego fragmentu mapy.
     *  @param bazowy   okrela fragment, z ktrym ssiaduje nowy (moe by null, jeli gdzieX == gdzieY == 0)
     *  @param gdzieX   przesunicie na wsprzdnej x mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param gdzieY   przesunicie na wsprzdnej y mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param obraz    obrazek reprezentujcy mapk
     */
    private void dodajFragment(FragmentMapy bazowy, int gdzieX, int gdzieY, PlikSieciowy obraz) throws Wyjatek {
        FragmentMapy nowy = new FragmentMapy();
        
        nowy.setIdWarstwy(warstwa);
        if (gdzieX == 0 && gdzieY == 0) { //to jest pierwszy fragment na tej warstwie
            nowy.setWsp_lg_x(0);
            nowy.setWsp_lg_y(0);
        } else {
            nowy.setWsp_lg_x(bazowy.getWsp_lg_x() + warstwa.getRozmiar_x() * gdzieX);
            nowy.setWsp_lg_y(bazowy.getWsp_lg_y() + warstwa.getRozmiar_y() * gdzieY);
        }
        nowy.setWsp_pd_x(nowy.getWsp_lg_x() + warstwa.getRozmiar_x()-1);
        nowy.setWsp_pd_y(nowy.getWsp_lg_y() + warstwa.getRozmiar_y()-1);

        Session s = null;
        Transaction tx = null;
        try {
            s = Hibcio.openSession();
            tx = s.beginTransaction();
            s.save(nowy);
            umiescPlikSieciowy(nowy, obraz);
            tx.commit();
        } catch (Exception e) {
            if (tx != null)
                try { tx.rollback(); } catch (Exception e2) {}
            e.printStackTrace();
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
    }

    /** Zapamituje w pliku na dysku obrazek fragmentu mapy.
     *  @param bi obrazek mapy
     *  @param frm fragment mapy
     *  @throws Wyjatek w przypadku bdu zapisu
     */
    private void umiescBufferedImage(BufferedImage bi, FragmentMapy frm) throws Wyjatek {
        try {
            javax.imageio.ImageIO.write(bi, "jpg", new File(skonstruujNazwePlikuFrMapy(frm)));
        } catch (Exception e) {
            throw new Wyjatek();
        }
    }
    
    /** Zapamituje w bazie danych fragmenty mapy wygenerowane z podanego obrazka.
     *  @param bazowy   okrela fragment, z ktrym ssiaduje nowy (moe by null, jeli gdzieX == gdzieY == 0)
     *  @param gdziex   przesunicie na wsprzdnej x mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param gdziey   przesunicie na wsprzdnej y mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param obraz    obrazek reprezentujcy mapk
     *  @param offsetx  przesunicie w pikselach na wsprzdnej x wzgldem lewego grnego rogu obrazka. okrela punkt, z ktrego naley zacz wycinanie fragmentw mapy
     *  @param offsety  przesunicie w pikselach na wsprzdnej y wzgldem lewego grnego rogu obrazka. okrela punkt, z ktrego naley zacz wycinanie fragmentw mapy
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @return liczba wyuskanych z obrazka fragmentw mapy
     */
    public int zapiszFragment(FragmentMapy bazowy, int gdziex, int gdziey, int offsetx, int offsety, PlikGraficzny obraz) throws Wyjatek {
        BufferedImage caly, jeden;
        FragmentMapy frm, frmpom;
        int ile = 0, ilex, iley, i, j;
        boolean czynowy;
        Transaction tx = null;
        Session s = null;

        caly = obraz.getBufferedImage();
//        System.out.println("Przyszed obrazek: " + caly.getWidth() + "x" + caly.getHeight());
        if (caly.getWidth() < offsetx + warstwa.getRozmiar_x() || caly.getHeight()<offsety + warstwa.getRozmiar_y())
            throw new Wyjatek("Obrazek za may!");
        ilex = (caly.getWidth()-offsetx) / warstwa.getRozmiar_x();
        iley = (caly.getHeight()-offsety) / warstwa.getRozmiar_y();
//        System.out.println("bedzie z tego: "+ilex+"x"+iley);
        
        for (i=0;i<ilex;i++)
            for (j=0;j<iley;j++) {
//                System.out.print("kawaek ["+i+","+j+"]: ");
                jeden = caly.getSubimage(offsetx + i*warstwa.getRozmiar_x(), 
                                         offsety + j*warstwa.getRozmiar_y(),
                                         warstwa.getRozmiar_x(),
                                         warstwa.getRozmiar_y());
                frm = new FragmentMapy();
                frm.setIdWarstwy(warstwa);
                frm.setWsp_lg_x(bazowy == null ? warstwa.getRozmiar_x()*i : bazowy.getWsp_lg_x() + warstwa.getRozmiar_x()*(gdziex+i));
                frm.setWsp_lg_y(bazowy == null ? warstwa.getRozmiar_y()*j : bazowy.getWsp_lg_y() + warstwa.getRozmiar_y()*(gdziey+j));
                frm.setWsp_pd_x(frm.getWsp_lg_x() + warstwa.getRozmiar_x()-1);
                frm.setWsp_pd_y(frm.getWsp_lg_y() + warstwa.getRozmiar_y()-1);
//                System.out.print("("+frm.getWsp_lg_x()+","+frm.getWsp_lg_y()+") - ("+frm.getWsp_pd_x()+","+frm.getWsp_pd_y()+")");
                //sprawdzamy, czy taki fragment ju istnieje
                czynowy = true;
                if (bazowy != null) {
                    s = null;
                    try {
                        s = Hibcio.openSession();
                        Query q = s.createQuery("from shared.FragmentMapy as fm where"+
                                                " fm.idWarstwy = :idw"+
                                                " and fm.wsp_lg_x = "+frm.getWsp_lg_x()+
                                                " and fm.wsp_lg_y = "+frm.getWsp_lg_y());
                        q.setParameter("idw", warstwa);
                        frmpom = (FragmentMapy) q.uniqueResult();
                        if (frmpom != null){
                            frm = frmpom;
                            czynowy = false;
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                        Hibcio.closeSession(s);
                        return ile;
                    }
                    Hibcio.closeSession(s);
                }
//                System.out.print(" czynowy? "+czynowy);
                try {
                    if (czynowy) {//umieszcamy w bazie
                        s = Hibcio.openSession();
                        tx = s.beginTransaction();
                        s.saveOrUpdate(frm);
                    } else {
                        s = null;
                        tx = null;
                    }
                    //zapisujemy na dysku
                    umiescBufferedImage(jeden, frm);
                    if (tx!=null)
                        tx.commit();
                } catch (Exception e) {
                    e.printStackTrace();
                    if (tx != null)
                        try {tx.rollback();} catch (Exception e2) {e2.printStackTrace();}
                    Hibcio.closeSession(s);
                    return ile;
                }
                Hibcio.closeSession(s);
//                System.out.println();
                ile++;
            }
        return ile;
    }
    /** Zapamituje w bazie danych now wersj okrelonego fragmentu mapy
     *  @param nowy     okrela fragment, ktrego zmiany dotycz
     *  @param obraz    nowy obrazek reprezentujcy mapk
     */
    private void podmienFragment(FragmentMapy nowy, PlikSieciowy obraz) throws Wyjatek {
        umiescPlikSieciowy(nowy, obraz);
    }

    /** Przygotowuje i zwraca obiekt zarzdzania fragmentem mapy. 
     *  @param fragment fragment, ktrym chcemy zarzdza 
     *  @return obiekt zarzdzania fragmentem mapy
     */
    public ZarzFragmentMapy zarzFragmentMapy(FragmentMapy fragment) {
        ZarzFragmentMapy zarz = new ZarzFragmentMapy();
        zarz.setFragment(fragment);
        return zarz;
    }

    /** Znajduje zadan liczb ssiadujcych fragmentw mapy takich, e zadany 
     *  punkt centralny wypada mniej wicej centralnie zestawu.
     *  @param ile pierwiastek z liczby fragmentw do znalezienia
     *  @param centralnyPkt centralny punkt w szukanym zestawie fragmentw mapy (wsprzdne bezwzgldne)
     *  @return tablica fragmentw mapy
     */
    public FragmentMapy[] pobierzFragmenty(int ile, Point centralnyPkt) {
        Point wzglCentr = bezwzgledneNaWzgledne(centralnyPkt);
        Point start, koniec;
        FragmentMapy[] ret = new FragmentMapy[ile*ile];
        FragmentMapy frm;
        int x,y;
        Session s = null;
        java.util.List l;
        java.util.ListIterator li;

        try {
            s = Hibcio.openSession();

            //wyliczamy otoczk, w ktr musz trafi poszukiwane fragmenty
            start = new Point(wzglCentr.x - ((ile-1) * warstwa.getRozmiar_x() / 2),
                        wzglCentr.y - ((ile-1) * warstwa.getRozmiar_y() / 2));
            koniec = new Point(start.x + ile * warstwa.getRozmiar_x() - 1,
                               start.y + ile * warstwa.getRozmiar_y() - 1);
//            System.out.println("otoczka::"+start+"<->"+koniec+"  wzglCentrum: "+wzglCentr);

            //wyszukujemy fragmentw, ktre prawym dolnym rogiem wpadaj w otoczk
            l = s.find("from shared.FragmentMapy as fm " +
                       "where fm.idWarstwy = ? " +
                       " and (wsp_pd_x between " + start.x + " and " + koniec.x+") " +
                       " and (wsp_pd_y between " + start.y + " and " + koniec.y+") ",
                       warstwa, Hibernate.entity(WarstwaMapy.class)
                       );
//            System.out.println("znaleziono:"+l.size());
            if (l.size() > 0) {
                li = l.listIterator();
                while (li.hasNext()) {
                    frm = (FragmentMapy) li.next();
                    //wyliczamy, w ktre miejsce w tablicy fragment trafi powinien
//                    System.out.print("* "+frm.getWsp_lg_x()+","+frm.getWsp_lg_y()+" / "+warstwa.getRozmiar_x());
                    x = ile-1 - (koniec.x - frm.getWsp_pd_x()) / warstwa.getRozmiar_x();
                    y = ile-1 - (koniec.y - frm.getWsp_pd_y()) / warstwa.getRozmiar_y();
//                    System.out.print(" x,y: ["+x+","+y+"] ");
//                    System.out.println();
                    ret[y*ile+x] = frm;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            Hibcio.closeSession(s);
        }
        return ret;
    }
    
    /** Przesuwa na podanej warstwie lokalizacj punktu 0,0, uaktualniajc informacj o
     *  wszystkich fragmentach mapy na warstwie.
     *  @param offsetx przesunicie w punktach wzgldnych na osi x
     *  @param offsety przesunicie w punktach wzgldnych na osi y
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void przesun00(int offsetx, int offsety) throws Wyjatek {
        Session s = null;
        Transaction tx = null;
        java.util.Iterator it;
        FragmentMapy fm;
        java.util.List l;
        
        try {
            s = Hibcio.openSession();
            l = s.find("from shared.FragmentMapy as fm where fm.idWarstwy = ?", warstwa, Hibernate.entity(WarstwaMapy.class));
            it = l.listIterator();
            tx = s.beginTransaction();
            while (it.hasNext()) {
                fm = (FragmentMapy) it.next();
                fm.setWsp_lg_x(fm.getWsp_lg_x()+offsetx);
                fm.setWsp_lg_y(fm.getWsp_lg_y()+offsety);
                fm.setWsp_pd_x(fm.getWsp_pd_x()+offsetx);
                fm.setWsp_pd_y(fm.getWsp_pd_y()+offsety);
                s.saveOrUpdate(fm);
            }
            tx.commit();
            Hibcio.closeSession(s);
        } catch (Exception e) {
            e.printStackTrace();
            if (tx != null) try {tx.rollback(); } catch (Exception e2){}
            Hibcio.closeSession(s);
            throw new Wyjatek();
        }
    }
}
