/*
 * ZarzOglosz.java
 *
 * Created on 25 marzec 2004, 15:29
 */

package serwer.ogloszenia;

import java.util.Date;

import net.sf.hibernate.*;

import shared.*;
import serwer.Hibcio;

/** ZarzOglosz to jedyny obiekt sucy do administrowania danym ogoszeniem.
 *
 * @author  ula
 */
public class ZarzOglosz {
    /** Ogoszenie, ktrym zarzdza dany obiekt ZarzOglosz. */
    protected Ogloszenie ogloszenie;
    
    /** Tworzy nowy obiekt ZarzOglosz. */
    public ZarzOglosz() {
    }
    
    /** Tworzy nowy obiekt ZarzOglosz. 
     *@param ogl    ogoszenie do zarzdzania
     */
    public ZarzOglosz(Ogloszenie ogl) {
        ogloszenie = ogl;
    }
    
    /** Ustala parametr ogoszenie, ktrym zarzdza.
     * @param ogl    ogoszenie do zarzdzania
     * @see #getOgloszenie
     */
    public void setOgloszenie(Ogloszenie ogl) {
        ogloszenie = ogl;
    }
    
    /** Zwraca zapamitane ogoszenie.
     * @return zarzdzane ogoszenie
     * @see #setOgloszenie
     */
    public Ogloszenie getOgloszenie() {
        return ogloszenie;
    }
    
    
    /** Potwierdza aktualno danych w ogoszeniu i przesuwa dat ostatniej
     * aktualizacji.
     *
     *@throws Wyjatek gdy nie powiedzie si operacja na bazie danych
     */
    public void potwierdzAktualnosc() throws Wyjatek {
        Session s = null;
        
        ogloszenie.setDataAktualizacji(new Date());
        try {
            s = Hibcio.openSession();
            s.saveOrUpdate(ogloszenie);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }        
    }
    
    /** Zatwierdza ogoszenie a tym samym umoliwia jego publikowanie w
     * wynikach wyszukiwania.
     *@throws Wyjatek gdy nie powiedzie si operacja na bazie danych
     */
    public void zatwierdz() throws Wyjatek {
        Session s = null;
        
        ogloszenie.setZaakceptowane(true);
        try {
            s = Hibcio.openSession();
            s.saveOrUpdate(ogloszenie);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }    
    }
    
    /** Zwraca ogoszenie.
     * @return  ogoszenie i jego pena tre
     */
    public Ogloszenie dajTresc() {
        return ogloszenie;
    }
    
    /** Zapamituje w systemie now tre ogoszenia.
     * @param nowe nowe ogoszenie
     *@throws Wyjatek gdy nie powiedzie si operacja na bazie danych
     */
    public void zmienTresc(Ogloszenie nowe) throws Wyjatek {
        Session s = null;
               
        try {
            s = Hibcio.openSession();
            s.saveOrUpdate(nowe);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }   
    }
}
