/*
 * ZarzOgloszeniePlatne.java
 *
 * Created on 25 marzec 2004, 16:53
 */

package serwer.ogloszenia;

import java.util.List;

import java.util.Date;
import serwer.Jadro;

import net.sf.hibernate.*;

import shared.*;
import serwer.Hibcio;

/** ZarzOgloszeniePlatne to podklasa ZarzOglosz, ktrej kady obiekt suy do
 * administrowania ogoszeniem. 
 *
 * @author  ula
 */
public class ZarzOgloszeniePlatne extends ZarzOglosz { 
    private OgloszeniePlatne oPlatne;
    
    /** Tworzy nowy obiekt ZarzOgloszeniePlatne. */
    public ZarzOgloszeniePlatne() {
    }
    
    /** Zapamituje ogoszenie patne. 
     *
     *@param ogloszenie     ogoszenie patne do zapamitania
     */
    public void setPlatne(OgloszeniePlatne ogloszenie) {
        oPlatne = ogloszenie;
    }
    

    /** Zmienia dane ogoszenie patne na bezpatne i usuwa z bazy dane
     * waciwe jedynie ogoszeniom patnym.
     *
     *@throws Wyjatek gdy nie powiedzie si operacja na bazie danych
     */
    public void zmienNaBezplatne() throws Wyjatek {
        Session s = null;
        Transaction tx = null;
        Query q;
        
        
        
        try {
            s = Hibcio.openSession();
            tx = s.beginTransaction();
            //wyszukaj ogloszenie zwykle odpowiadajace platnemu
            q = s.createQuery("from shared.Ogloszenie as og " +
                                " where og.platne = :id ");
            q.setParameter("id", oPlatne.getId());
            Ogloszenie ogloszenie = (Ogloszenie) q.uniqueResult();
            //ustal w zwyklym ogloszeniu ze jest bezplatne
            ogloszenie.setPlatne(null);
            //usun platne z bazy
            s.delete(oPlatne);
            //usun logo z bazy
            Jadro.kontaFirm.usunLogo(ogloszenie.getId());
            //zapisz zmiany w zwyklym
            s.saveOrUpdate(ogloszenie);
            tx.commit();
        } catch (Exception e) {
            try {
                tx.rollback();
            } catch (Exception e2) {
            }
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }
    }
    
    /** Przedua termin, do ktrego ogoszenie jest opacone.
     * @param data      data, do ktrej naley przeduy
     *@throws Wyjatek gdy nie powiedzie si operacja na bazie danych
     */
    public void przedluzTermin(Date data) throws Wyjatek {
        Session s = null;
        
        oPlatne.setDataOplacenia(data);
        try {
            s = Hibcio.openSession();
            s.saveOrUpdate(oPlatne);
        } catch (Exception e) {
            throw new Wyjatek();
        } finally {
            Hibcio.closeSession(s);
        }      
    }
    
}
