package shared;

import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/** 
 * 		    Reprezentuje struktur bran. Struktur jest pesudo-drzewo: 
 * 		    kada brana oprcz korzenia musi mie rodzica, a take
 * 		    moe mie wielu rodzicw, ale tak, by w grafie nie powsta 
 * 		    cykl.
 * 		    
 * 		    >> Dla developerw: Kod zosta wygenerowany za pomc narzdzia 
 * 		    hbm2java.CodeGenerator. Jakiekolwiek modyfikacje naley
 * 		    wprowadza bezporednio w plikach mapowania, tj. w plikach 
 * 		    o rozszerzeniu hmb.xml. Zmiany umieszczone 
 * 		    bezporednio w kodzie Javy zostan zamazane przy 
 * 		    kolejnej generacji kodu.
 * 		    
 * 		    @author ek197882
 * 		
*/
public class DrzewoBranz implements Serializable {

    /** identifier field */
    private shared.Branza syn;

    /** identifier field */
    private shared.Branza matka;

    /** full constructor */
    public DrzewoBranz(shared.Branza syn, shared.Branza matka) {
        this.syn = syn;
        this.matka = matka;
    }

    /** default constructor */
    public DrzewoBranz() {
    }

    public shared.Branza getSyn() {
        return this.syn;
    }

    public void setSyn(shared.Branza syn) {
        this.syn = syn;
    }

    public shared.Branza getMatka() {
        return this.matka;
    }

    public void setMatka(shared.Branza matka) {
        this.matka = matka;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("syn", getSyn())
            .append("matka", getMatka())
            .toString();
    }

    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof DrzewoBranz) ) return false;
        DrzewoBranz castOther = (DrzewoBranz) other;
        return new EqualsBuilder()
            .append(this.getSyn(), castOther.getSyn())
            .append(this.getMatka(), castOther.getMatka())
            .isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder()
            .append(getSyn())
            .append(getMatka())
            .toHashCode();
    }

}
