/*
 * InterfejsKataloguBranz.java
 *
 * Created on 3 maj 2004, 19:31
 */

package shared;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

import shared.branze.*;

/** Sieciowy interfejs klasy {@link serwer.branze.KatalogBranz}.
 *
 * @author  witus
 */
public interface InterfejsKataloguBranz extends Remote {
    
    /** Wydobywa z bazy i zwraca zawarto katalogu bran.
     *  @return cay katalog bran
     *  @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
    public KatalogBranzDrzewo dajZwartoscKataloguBranz() throws Wyjatek, RemoteException;
    
    /** 
     * Wygenerowanie pliku zawierajcego katalog bran w katalogu,
     * z ktrego bd mogy go pobra aplety i aplikacja administratora.
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
    public void generujStatycznyKatalogBranz() throws Wyjatek, RemoteException;
    
    /**
     * Dodaje do Katalogu Bran now bran
     * jako parametr i zalenoci midzy nimi.
     * @param nowa brana, ktra zostanie dodana do Katalogu Bran
     * @param matka nadbrana dodawanej brany
     * @return dodana brana
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */    
    public Branza dodajDoKatalogu(Branza nowa, Branza matka) throws Wyjatek, RemoteException;
    
    /**
     * Zmienia bran w Katalogu Bran.
     * @param nowa brana, ktra znajdzie si w Katalogu Bran
     * @param stara brana, ktra zostanie zamieniona na now
     * @return brana, ktra znalaza si w Katalogu
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
    public Branza zmienBranze(Branza nowa, Branza stara) throws Wyjatek, RemoteException;
    
    /**
     * Usuwanie zadanej brany z bazy danych.
     * @param branza brana, ktra zostanie usunita z bazy danych
     * @throws Wyjatek wyjtek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */    
    public void usunBranze(Branza branza) 
        throws Wyjatek, RemoteException;
    
    /**
     * Usuwanie zadanej brany z bazy danych.
     * @param branza brana, ktra zostanie usunita z bazy danych
     * @param matka nadbrana usuwanej Brany
     * @throws Wyjatek wyjtek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */    
    public void usunPodczepionaBranze(Branza branza, Branza matka) 
        throws Wyjatek, RemoteException;
    
    /**
     * Dodaje now ga do Katalogu bran.
     * @param nowa podbrana w gazi
     * @param matka nadbrana w gazi
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
    public void dodajDoKataloguZaleznosc(Branza nowa, Branza matka)
        throws Wyjatek, RemoteException;
  
}
