/*
 * InterfejsKontoAdministratora.java
 *
 * Created on 6 kwiecie 2004, 23:40
 */

package shared;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

/** Sieciowy interfejs klasy {@link serwer.konto.KontoAdministratora}.
 *
 * @author  ula
 */
public interface InterfejsKontoAdministratora extends Remote {
    /** Sprawdza poprawno hasa administratora.
     * @param haslo      sprawdzane haso
     * @return true, jeli haso jest poprawne
     * @throws Wyjatek gdy nie uda si wydoby hasa z bazy
     * @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
     public boolean autoryzacja(String haslo) throws Wyjatek,RemoteException;
     /** Zmienia haso administratora.
     * @param stare     stare haso
     * @param nowe      nowe haso
     * @throws Wyjatek gdy nie uda si wydoby hasa z bazy
     * @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
     public void zmienHaslo(String stare, String nowe) throws Wyjatek,RemoteException;
    
}
