/*
 * InterfejsMapy.java
 *
 * Created on 28 marzec 2004, 13:23
 */

package shared;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.awt.Point;

/** Sieciowy interfejs klasy {@link serwer.mapa.Mapy}.
 *
 * @author  me201258
 */
public interface InterfejsMapy extends Remote {
    /** Zwraca posortowan wzgldem skali list wszystkich znanych obiektw typu {@link WarstwaMapy}.
     *  @return lista wszystkich warstw 
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
    public WarstwaMapy[] warstwy() throws RemoteException;
    
    /** Zapamituje w bazie danych warstw mapy. 
     *  @param warstwa warstwa mapy 
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     *  @throws Wyjatek w przypadku bdu tworzenia katalogu warstwy lub bdu bazy danych
     */
    public void zapiszWarstwe(WarstwaMapy warstwa) throws RemoteException,Wyjatek;

    /** Do zadanego zestawu ogosze dobiera fragment mapy (i tym samym odpowiedni warstw),
     *  ktry bdzie najwaciwszy do zaprezentowania tego zestawu.
     *  @param ogloszenia lista ogosze, dla ktrych szukamy fragmentu 
     *  @return najwaciwszy fragment mapy 
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public FragmentMapy wybierzNajlepszyFragment(List ogloszenia) throws RemoteException,Wyjatek;

    /** Znajduje zadan liczb ssiadujcych fragmentw mapy takich, e zadany 
     *  punkt centralny wypada mniej wicej centralnie zestawu.
     *  @param warstwa warstwa mapy, ktrej rzecz dotyczy
     *  @param ile pierwiastek z liczby fragmentw do znalezienia
     *  @param centralnyPkt centralny punkt w szukanym zestawie fragmentw mapy
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @return tablica fragmentw mapy
     */
    public FragmentMapy[] pobierzFragmenty(WarstwaMapy warstwa, int ile, Point centralnyPkt) throws RemoteException;


    /** Zapamituje w bazie danych fragmenty mapy wygenerowane z podanego obrazka.
     *  @param warstwa  warstwa, na ktrej ma by dodany fragment
     *  @param bazowy   okrela fragment, z ktrym ssiaduje nowy (moe by null, jeli gdzieX == gdzieY == 0)
     *  @param gdziex   przesunicie na wsprzdnej x mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param gdziey   przesunicie na wsprzdnej y mierzone w obiektach FragmentMapy wzgldem bazowego
     *  @param offsetx  przesunicie w pikselach na wsprzdnej x wzgldem lewego grnego rogu obrazka. okrela punkt, z ktrego naley zacz wycinanie fragmentw mapy
     *  @param offsety  przesunicie w pikselach na wsprzdnej y wzgldem lewego grnego rogu obrazka. okrela punkt, z ktrego naley zacz wycinanie fragmentw mapy
     *  @param obraz    obrazek reprezentujcy mapk
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @return liczba wyuskanych z obrazka fragmentw mapy
     */
    public int zapiszFragment(WarstwaMapy warstwa, FragmentMapy bazowy, int gdziex, int gdziey, int offsetx, int offsety, PlikGraficzny obraz) throws RemoteException, Wyjatek;
    
    /** Przesuwa na podanej warstwie lokalizacj punktu 0,0, uaktualniajc informacj o
     *  wszystkich fragmentach mapy na warstwie.
     *  @param warstwa warstwa, na ktrej przesuwamy 0,0
     *  @param offsetx przesunicie w punktach wzgldnych na osi x
     *  @param offsety przesunicie w punktach wzgldnych na osi y
     *  @throws RemoteException w przypadku bdu komunikacji sieciowej
     *  @throws Wyjatek w przypadku bdu bazy danych
     */
    public void przesun00(WarstwaMapy warstwa, int offsetx, int offsety) throws RemoteException, Wyjatek;
}
