/*
 * InterfejsNajpopularniejszychBranz.java
 *
 * Created on 17 maj 2004, 11:56
 */

package shared;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

/** Sieciowy interfejs klasy {@link serwer.branze.KatalogNajpopularniejszych}.
 *
 * @author  witus
 */
public interface InterfejsNajpopularniejszychBranz extends Remote {
    
    /**
     * Zwraca katalog bran, ktry znajduje si w bazie dancy systemu
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     * @throws RemoteException w przypadku bdu komunikacji sieciowej
     */    
    public List katalog() throws Wyjatek, RemoteException;
    
    /**
     * Pobranie z bazy listy bran wraz z ich popularnoci
     * @return Posortowan list zawierajc brane i ich popularnoci
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     * @throws RemoteException w przypadku bdu komunikacji sieciowej
     */ 
    public List getListaPopularnosci() throws Wyjatek, RemoteException;
    
    /**
     * Usunicie starego Katalogu najpopularniejszych Bran i wstawienie nowego
     * @param nowyKatalog Katalog, ktry znajdzie si w bazie danych
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych
     * @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
    public void zamienKatalog(List nowyKatalog) throws Wyjatek, RemoteException;
    
     /** 
     * Wygenerowanie na serwerze pliku zawierajcego Katalog Najpopularniejszych
     * Bran, eby uytkownicy nie musieli za kadym razem odwoywa si do bazy
     * danych. Poza tym istnieje szansa, e przegldarka przechowa taki plik w
     * swoim cache'u.
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji na bazie danych 
     *                 lub zapisywaniu pliku
     * @throws RemoteException w przypadku bdu komunikacji sieciowej
     */
    public void wygenerujStatycznyKatalogNajpop() throws Wyjatek, RemoteException;
    
}
