/*
 * InterfejsUlice.java
 *
 * Created on 28 marzec 2004, 13:27
 */

package shared;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.awt.Point;

/** Sieciowy interfejs klasy {@link serwer.mapa.Ulice}.
 *
 * @author  me201258
 */
public interface InterfejsUlice extends Remote {
    /** Wyszukuje i zwraca ulice odpowiadajce podanej nazwie. 
     *  @param nazwa nazwa ulicy, ktrej szukamy 
     *  @return lista znalezionych ulic 
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException
     */
    public List znajdzUlice(String nazwa) throws Wyjatek,RemoteException;
    
    /** Usuwa podan ulic oraz wszystkie waciwe jej fragmenty ulic.
     *  @param ulica ulica do usunicia 
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException
     */
    public void usunUlice(Ulica ulica) throws Wyjatek,RemoteException;
    
    /** Dodaje do bazy danych now ulic.
     *  @param ulica ulica do dodania 
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException
     */
    public void dodajUlice(Ulica ulica) throws Wyjatek,RemoteException;

    /** Wyszukuje wszystkie ulice, ktre przechodz przez obszar ograniczony zadanymi wsprzdnymi.
     *  @param  gl   wsprzdne lewego grnego rogu obszaru
     *  @param  dp   wsprzdne dolnego prawego rogu obszaru 
     *  @return lista znalezionych ulic 
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException
     */
    public List znajdzUliceWOkolicy(Point gl, Point dp) throws Wyjatek,RemoteException;
    
    /** Pobiera wszystkie fragmenty ulicy.
     *  @param ulica ulica, ktrej fragmentw szukamy
     *  @return tablcia fragmentw ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException
     */
    public FragmentUlicy[] znajdzFragmentyUlicy(Ulica ulica) throws Wyjatek,RemoteException;
    
    /** Zmienia nazw ulicy.
     *  @param ulica ulica, ktrej nazw zmieniamy
     *  @param nazwa nowa nazwa dla ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException
     */
    public void zmienNazweUlicy(Ulica ulica, String nazwa) throws Wyjatek,RemoteException;
    
    /** Zapamituje nowy przebieg ulicy, kasujc dotychczasowy.
     *  @param ulica zmieniana ulica
     *  @param fr tablica nowych fragmentw podanej ulicy
     *  @throws Wyjatek w przypadku bdu bazy danych
     *  @throws RemoteException
     */
    public void zapiszPrzebiegUlicy(Ulica ulica, FragmentUlicy[] fr) throws Wyjatek, RemoteException;
    
}
