/*
 * Kryteria.java
 *
 * Created on 25 marzec 2004, 17:34
 */

package shared;

import java.io.Serializable;

import java.util.Date;
import java.util.Calendar;
import java.awt.Point;

/** Obiekt klasy Kryteria jest transportowanym przez sie obiektem zawierajcym
 * kryteria wyszukiwania zadane przez uytkownika. Transportowane kryteria s 
 * najczciej Stringami, ktre zostan zinterpretowane po stronie serwera.
 *
 * @author  ula
 */
public class Kryteria implements Serializable {
    //nip firmy
    //private Nip nip;
    private String nip;
    
    //nazwa firmy
    private String nazwa;
    
    //slowa kluczowe w ogloszeniach platnych
    private String slowoKluczowe;
    
    //data zalozenia firmy
    private Integer rokZalozenia;
    
    //czy firmy starsze, mlodsze czy dokladnie z podanego roku zalozenia
    //dokl z=0; mlodsze= +1; starsze= -1
    private int dataKiedy;
    
    //nazwa ulicy, jako string; zostanie zinterpretowana przez wybor ogloszen
    private String ulica;
    
    //numer na ulicy; skorzystamy z tego przy wyliczaniu bazowego pktu wyszukiwania
    private Integer nr;
    
    //promien wyszukiwania na mapie
    private int promien;
        
    //branza firmy
    private shared.Branza branza;
    
    //czy wyswietlac z mapka
    private boolean czyMapka;
    
    //ile ogloszen wyswietlic w wynikach
    private int ile;
    
    //offset, od ktorego nru wyszukanych ogloszen zaczac wyswietlac
    private int zacznijOd;
    
    /** Tworzy nowy obiekt klasy Kryteria. */
    public Kryteria() {
        nip = null;
        nazwa = null;
        slowoKluczowe = null;
        rokZalozenia = null;
        ulica = null;
        nr = null;
        branza = null;
    }
    
    /** Tworzy obiekt klasy Kryteria z podanymi parametrami. 
     *  @param nip wyszukiwane nip (z kreskami determinujcymi osobowo prawn
     *  @param nazwa wyszukiwana nazwa
     *  @param slowoKluczowe wyszukiwane sowo kluczowe
     *  @param rokZalozenia rok zaoenia firmy
     *  @param dataKiedy liczba, okrelajca, czy wyszukujemy firmy modsze, starsze, czy dokadnie z zadanego roku
     *  @param ulica ulica, na lub wok ktrej wyszukujemy
     *  @param nr numer domu, wok ktorego wyszkujemy
     *  @param promien promie wyszukiwania
     *  @param branza brana, w ktrej wyszukujemy
     *  @param czyMapka czy planujemy pokazywa wyniki na mapce
     *  @param ile ile wynikw wyszukiwania przesa
     *  @param zacznijOd od ktrego wyniku zacz
     */
    public Kryteria(String nip, String nazwa, String slowoKluczowe, Integer rokZalozenia, int dataKiedy, String ulica, Integer nr, int promien, shared.Branza branza, boolean czyMapka, int ile, int zacznijOd) {
        this.nip = nip;
        this.nazwa = nazwa;
        this.slowoKluczowe = slowoKluczowe;
        this.rokZalozenia = rokZalozenia;
        this.dataKiedy = dataKiedy;
        this.ulica = ulica;
        this.nr = nr;
        this.promien = promien;
        this.branza = branza;
        this.czyMapka = czyMapka;
        this.ile = ile;
        this.zacznijOd = zacznijOd;
    }
    
    public String getNip() {
        return this.nip;
    }
    
    public void setNip(String nip) {
        this.nip = nip;
    }
    
    public String getNazwa() {
        return this.nazwa;
    }
    
    public void setNazwa(String nazwa) {
        this.nazwa = nazwa;
    }   
    
    public String getSlowoKluczowe() {
        return this.slowoKluczowe;
    }
    
    public void setSlowoKluczowe(String slowoKluczowe) {
        this.slowoKluczowe = slowoKluczowe;
    }
    
    public Integer getRokZalozenia() {
        return this.rokZalozenia;
    }
    
    public int getDataKiedy() {
        return this.dataKiedy;
    }
    
    public void setDataKiedy(int dataKiedy) {
        this.dataKiedy = dataKiedy;
    }
    
    public void setRokZalozenia(Integer rokZalozenia) {
        this.rokZalozenia = rokZalozenia;
    }
    
    public String getUlica() {
        return this.ulica;
    }
    
    public void setUlica(String ulica) {
        this.ulica = ulica;
    }
    
    public Integer getNr() {
        return this.nr;
    }
    
    public void setNr(Integer nr) {
        this.nr = nr;
    }
    
    public int getPromien() {
        return this.promien;
    }
    
    public void setPromien(int promien) {
        this.promien = promien;
    }

    public shared.Branza getBranza() {
        return this.branza;
    }
    
    public void setBranza(shared.Branza branza) {
        this.branza = branza;
    }
    
    public int getIle() {
        return this.ile;
    }
    
    public void setIle(int ile) {
        this.ile = ile;
    }
    
    public int getZacznijOd() {
        return this.zacznijOd;
    }
    
    public void setZacznijOd(int zacznijOd) {
        this.zacznijOd = zacznijOd;
    }
    
    public boolean getCzyMapka() {
        return this.czyMapka;
    }
}
