/*
 * Nip.java
 *
 * Created on 4 kwiecie 2004, 12:14
 */

package shared;

import shared.Wyjatek;
/** Obiekty klasy Nip przechowuj nipy ogosze firm.
 *
 * @author  ula
 */
public class Nip implements java.io.Serializable {
    private String nip;
    
    /** Tworzy nowy obiekt klasy Nip. */
    public Nip() {
    }
    
    /** Ustawia nip.
     *
     * @param nip    podstawiany nip
     * @see #getNip
     */
    public void setNip(String nip) {
        this.nip = nip;
    }
    
    /** Zwraca przechowywany nip.
     *
     * @return nip jako string
     * @see #setNip
     */
    public String getNip() {
        return this.nip;
    }
    
    /** Tworzy nowy obiekt klasy Nip.
     *
     * @param nowy    nip ogoszenia
     * @throws Wyjatek  podany jako parametr string ma zy format i nie jest nipem
     */
    public Nip(String nowy) throws Wyjatek {
        nip = nowy;
        //spr czy podany format jest poprawny        
        if (nip.length() != 13)
            throw new Wyjatek();
        //os prawna albo nie, spr 2 przypadki
        if (Character.isDigit(nip.charAt(6))) {
            for (int i = 0; i < 13; i++) {
                if (i == 3 || i == 7 || i == 10) {
                    if (nip.charAt(i) != '-')
                        throw new Wyjatek();
                }
                else {
                    if (!Character.isDigit(nip.charAt(i)))
                        throw new Wyjatek();
                }
            }
        }
        else { //os prawna
            for (int i = 0; i < 13; i++) {
                if (i == 3 || i == 6 || i == 9) {
                    if (nip.charAt(i) != '-')
                        throw new Wyjatek();
                }
                else {
                    if (!Character.isDigit(nip.charAt(i)))
                        throw new Wyjatek();
                }
            }
        }        
    }
    
    /** Sprawdza czy dany nip ma osobowo prawn.
     *
     *@return true, jeli ma
     */
    public boolean czyOsPrawna () {
        //os prawna     = XXX-XX-XX-XXX
        //nie os prawna = XXX-XXX-XX-XX
        //na 6 miejscu, nracja od 0, w os prawnej jest '-' wpp cyfra
        
        return !Character.isDigit(nip.charAt(6));
    }
    
    
    /** Zwraca warto liczbow danego Nipa. 
     *
     *@return warto liczbowa nipa
     */
    public long nipToInt() {
        //w bazie i jako atrybut ogloszenia nip jest longiem
        Long liczba;
        StringBuffer sb = new StringBuffer();
        
        for (int i=0; i < 13; i++) 
            if (Character.isDigit(nip.charAt(i))) 
                sb.append(nip.charAt(i));
        
        liczba = new Long(sb.toString());
        return liczba.longValue();
    }
    
    /** Przeksztaca podany identyfikator w stringa Nip na podstawie
     * podanej wartoci osobowoci prawnej.
     *
     * @param id         nip jako long
     * @param osPrawna   true lub false, stwierdza czy dany nip ma osobowo prawn
     * @return napis, reprezentujcy zadany NIP
     * @throws Wyjatek   jeli z podanych parametrw nie mona utworzy prawidowego nipa
     */
    public static String intToNip(long id, boolean osPrawna) throws Wyjatek {
        StringBuffer sb = new StringBuffer();
        String idStr = new Long(id).toString();
        String idString = "";
        
        if (idStr.length() != 10) {            
            if (idStr.length() > 10)
                throw new Wyjatek();
            else {
                //nip np 00-000-00-100
                String str = new String();
                for (int i = 0; i < 10-idStr.length(); i++) {
                    str = str.concat("0");
                }    
                str = str.concat(idStr);
                idString = str;
            }
            
        }
        else
            idString = new Long(id).toString();        
        
        if (osPrawna)
            for (int i = 0, j = 0; i < 13; i++) {
                if (i%3 == 0 && i != 0 && i != 12)
                    sb.append('-');
                else {
                    sb.append(idString.charAt(j));
                    j++;
                }
        }
        else
            for (int i = 0, j = 0; i < 13; i++) {
                if (i == 3 || i == 7 || i == 10)
                    sb.append('-');
                else {
                    sb.append(idString.charAt(j));
                    j++;
                }
            }
        return sb.toString();
    }
}
