/*
 * PlikGraficzny.java
 *
 * Created on 30 kwiecie 2004, 12:54
 */

package shared;

import java.awt.image.*;
import javax.imageio.*;
import java.io.*;
import java.net.URL;

/** Obiekty tej klasy su do transportowania przez sie obrazkw.
 *
 * @author  me201258
 */
public class PlikGraficzny extends PlikSieciowy{
    
    /** Tworzy nowy obiekt klasy. */
    public PlikGraficzny() {
    }

    /** Tworzy nowy obiekt klasy, wczytujc obrazek z tablicy bajtw.
     *  @param dane tablica bajtw z obrazkiem
     */
    public PlikGraficzny(byte[] dane) {
        super(dane);
    }
    
    /** Tworzy nowy obiekt klasy PlikGraficzny i wczytuje obrazek z podanego pliku.
     *  @param plik plik z obrazkiem
     *  @throws Wyjatek w przypadku bdu odczytu pliku
     */
    public PlikGraficzny(File plik) throws Wyjatek {
        super(plik);
    }

    /** Tworzy nowy obiekt klasy PlikGraficzny i wczytuje dane z podanego jako URL pliku.
     *  @param url url pliku do wczytania
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */    
    public PlikGraficzny(URL url) throws Wyjatek {
        super(url);
    }
    
    
    /** Generuje z zapamitanych danych obrazek w postaci wyrenderowanej ({@link BufferedImage}).
     *  @return wyrenderowany obrazek
     *  @throws Wyjatek w przypadku bdw operacji
     */
    public BufferedImage getBufferedImage() throws Wyjatek {
        BufferedImage ret;
        try{
            ret = ImageIO.read(new ByteArrayInputStream(dane));
        } catch (IOException e) {
            throw new Wyjatek();
        }
        return ret;
    }
    
}
