/*
 * PlikSieciowy.java
 *
 * Created on 24 marzec 2004, 19:44
 */

package shared;

import java.awt.*;
import java.awt.image.*;
import java.net.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import javax.imageio.ImageIO;
import java.io.*;

/** Klasa obsugujca transportowanie obiektw graficznych przez sie. Zawiera w sobie
 *  obrazek (jako {@link ImageIcon}) i metody do wczytywania i zapisywania. Obiekty tej
 *  klasy mog by bezpiecznie przesyane przez sie.
 *
 * @author  me201258
 */
public class PlikSieciowy implements java.io.Serializable {
    
    /** wewntrzna reprezentacja pliku - tablica bajtw. */
    protected byte[] dane;
    
    /** Tworazy nowy obiekt klasy PlikSieciowy. */
    public PlikSieciowy() {
    }
    
    /** Tworzy nowy obiekt klasy PlikSieciowy z danych, ktre juz zostay 
     * umieszczone w tablicy. 
     * @param d Tablica ju wczytanych danych.
     */
    public PlikSieciowy(byte[] d) {
        dane = new byte[d.length];
        for (int i = 0; i < dane.length; i++)
            dane[i] = d[i];
    }
    
    /** Tworzy nowy obiekt klasy PlikSieciowy i wczytuje dane z podanego jako nazwa pliku.
     *  @param nazwa nazwa pliku do wczytania 
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */
    public PlikSieciowy(String nazwa) throws Wyjatek {
        wczytajSie(nazwa);
    }
    
    /** Tworzy nowy obiekt klasy PlikSieciowy i wczytuje dane z podanego pliku.
     *  @param plik plik z obrazkiem 
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */
    public PlikSieciowy(File plik) throws Wyjatek {
        wczytajSie(plik);
    }
    
    /** Tworzy nowy obiekt klasy PlikSieciowy i wczytuje dane z podanego jako URL pliku.
     *  @param url url pliku do wczytania
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */
    public PlikSieciowy(URL url) throws Wyjatek {
        wczytajSie(url);
    }
    
    /** Zapisuje zapamitany obrazek pod podan nazw.
     *  @param nazwa nazwa pliku do zapisania
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */
    public void zapiszSie(String nazwa) throws Wyjatek {
        try {
            FileOutputStream out = new FileOutputStream(nazwa);
            out.write(dane);
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /** Wczytuje obrazek z podanego pliku.
     *  @param plik plik do wczytania
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */
    public void wczytajSie(File plik) throws Wyjatek {
        try {
            FileInputStream is = new FileInputStream(plik);
            long length = plik.length();
            
            if (length > Integer.MAX_VALUE) {
                throw new Wyjatek(); // File is too large
            }
            
            dane = new byte[(int)length];
            
            // Read in the bytes
            int offset = 0;
            int numRead = 0;
            while (offset < dane.length &&
            (numRead=is.read(dane, offset, dane.length-offset)) >= 0) {
                offset += numRead;
            }
            
            if (offset < dane.length) {
                throw new Wyjatek();
            }
            
            is.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
    
    /** Wczytuje z pliku zadanego nazw.
     *  @param nazwa pliku do wczytania
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */
    public void wczytajSie(String nazwa) throws Wyjatek {
        File file;
        try {
            file = new File(nazwa);
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        wczytajSie(file);
    }
    
    /** Wczytuje z pliku zadanego URLem.
     *  @param url URL pliku do wczytania
     *  @throws Wyjatek w przypadku problemw z wczytaniem pliku
     */
    public void wczytajSie(URL url) throws Wyjatek{
        try {
            System.out.println("OPEN CONENCTION" );
            
            
            URLConnection uc = url.openConnection();
            System.out.println(" PREMISION::" + uc.getPermission().toString());
            System.out.println("CONNECT" );
            uc.connect();
            System.out.println("CONTENT" );
            Object c = uc.getContent();
            
            
            InputStream is = url.openStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            // Read in the bytes
            byte[] bufor = new byte[100];
            int numRead;
            
            while ((numRead = is.read(bufor)) != -1) {
                if (numRead > 0)
                    os.write(bufor, 0, numRead);
            }
            is.close();
            dane = os.toByteArray();
            os.close();
        } catch (Exception e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
    }
}
