/*
 * PomocnikMapy.java
 *
 * Created on 26 kwiecie 2004, 18:19
 */

package shared;

import java.awt.Point;
import java.io.File;

/** Klasa uytecznych metod obsugi mapy.
 *
 * @author  me201258
 */
public class PomocnikMapy {
    /** Gwna skala mapy (1:<SKALA_BAZOWA>). */
    public static final int SKALA_BAZOWA = 40000;
    /** Ile jest punktw we wsprzdnych bezwgldnych na jednym centymetrze mapy w skali bazowej. */
    private static final int GESTOSC_PKTOW = 140;
    
    /** Tworzy nowy obiekt klasy PomocnikMapy. */
    public PomocnikMapy() {
    }
    
    /** Konstruuje wzgldn nazw pliku zawierajcego fragment mapy. Nazw tak wystarczy poprzedzi
     *  adresem sieciowym serwera lub adresem lokalnym i gotowe.
     *  @param frm fragment mapy, ktrego nazw chcemy skonstruowa
     *  @return wzgldna nazwa pliku
     */
    public static String wzglednaNazwaFrMapy(FragmentMapy frm, String separator) {
        return "mapy" + separator + 
                frm.getIdWarstwy().getId() + separator + 
                (frm.getId().intValue()%10) + separator + 
                frm.getId() + ".jpg";
    }
    
    /** Oblicz wsprzdne obiektu o zadanym numerze na podanym fragmencie ulicy.
     *  @param fr fragment ulicy
     *  @param nrDomu poszukiwany numer domu
     *  @return wsprzdne numeru domu na ulicy.
     */
    public static Point wspolrzedneObiektu(FragmentUlicy fr, int nrDomu) {
        int xp,yp,xk,yk,nrp,nrk;
        
        //pobieramy sobie wsprzdne i numery domw
        if (fr.getNr_pocz() < fr.getNr_konc()){
            xp = fr.getWsp_pocz_x();
            yp = fr.getWsp_pocz_y();
            xk = fr.getWsp_konc_x();
            yk = fr.getWsp_konc_y();
            nrp = fr.getNr_pocz();
            nrk = fr.getNr_konc();
        } else {
            xk = fr.getWsp_pocz_x();
            yk = fr.getWsp_pocz_y();
            xp = fr.getWsp_konc_x();
            yp = fr.getWsp_konc_y();
            nrk = fr.getNr_pocz();
            nrp = fr.getNr_konc();
        }

        //jeli numer pocztkowy = numer kocowy
        if (nrk == nrp) {
            return new Point(xp + (xk - xp) / 2, yp + (yk - yp) / 2);
        } else 
            return new Point(xp + (xk - xp)*(nrDomu - nrp)/(nrk - nrp),
                             yp + (yk - yp)*(nrDomu - nrp)/(nrk - nrp));
    }
    
    /** Przelicza bezwzgldne wsprzdne na wsprzdne zwizane z warstw mapy.
     *  @param warstwa warstwa mapy
     *  @param p   wsprzdne bezwzgldne
     *  @return    wsprzdne wzgldne (na warstwie)
     */
    public static Point bezwzgledneNaWzgledne(WarstwaMapy warstwa, Point p) {
        return new Point(Math.round((float) p.getX() * SKALA_BAZOWA / warstwa.getSkala()),
                        Math.round((float) p.getY() * SKALA_BAZOWA / warstwa.getSkala()));
    }
    
    /** Przelicza podana odlegosc na odlego w punktach bezwzgldnych.
     *  @param odleglosc odlego rzeczywista (w metrach)
     *  @return odlego w punktach bezwzgldnych
     */
    public static int rzeczywisteNaBezwzgledne(int odleglosc) {
        //    odleglosc*100  -> odlego rzecz. w centymetrach
        //                 / SKALA_BAZOWA -> mamy odlego w centymetrach na mapie
        //                                * GESTOSC_PKTOW -> mamy odlego w punktach
        return Math.round((float) (odleglosc*100) / SKALA_BAZOWA * GESTOSC_PKTOW);
    }
           
    /** Przelicza wzgldne wsprzdne (zwizane z warstw mapy) na wsprzdne bezwzgldne.
     *  @param warstwa warstwa mapy
     *  @param p   wsprzdne wzgldne (na warstwie)
     *  @return    wsprzdne bezwzgldne
     */
    public static Point wzgledneNaBezwzgledne(WarstwaMapy warstwa, Point p) {
        return new Point(Math.round((float)p.getX() * warstwa.getSkala() / SKALA_BAZOWA),
                        Math.round((float) p.getY() * warstwa.getSkala() / SKALA_BAZOWA));
    }
        
}
