/*
 * EltKatBranz.java
 *
 * Created on 29 kwiecie 2004, 10:29
 */

package shared.branze;

import java.util.*;
import shared.Branza;
import shared.Wyjatek;
import net.sf.hibernate.*;
import java.io.Serializable;
import javax.swing.tree.*;

/**
 * Wze w Katalogu Bran
 * @author  witus
 * @version %I% %G%
 */
public class EltKatBranz implements Serializable {
    /** Branza, z ktora zwizany jest wze w katalogu bran */
    private Branza branza;
        
    /** Podbrane wza w katalogu bran */
    private List dzieci;
    
    /** Czy element zosta odwiedzony podczas poszukiwania cyklu */
    public boolean odwiedzony;
    
    /** Tworzy nowy obiekt klasy EltKatBranz */
    public EltKatBranz() {
    }
    
    /**
     * Tworzy nowy obiekt klay EltKatBranz z zadanymi parametrami
     * @param nowa Brana, z ktr bdzie zwizany wze w Katalogu Bran
     * @param noweDzieci Brane, ktre bd podbranami wza w Katalogu Bran
     */
    public EltKatBranz(Branza nowa, List noweDzieci) {
        this.branza = nowa;
        this.dzieci = noweDzieci;
        this.odwiedzony = false;
    }
    
    /**
     * Dodaje podrzewo do kolekcji poddrzew dzieci
     * @param noweDziecko Poddrzewo, ktre zostanie dodane do kolekcji poddrzew dzieci
     */    
    public void dodajDziecko(EltKatBranz noweDziecko) {
        this.dzieci.add(noweDziecko);
    }
    
    /**
     * Usunicie poddrzewa z kolekcji poddrzew dzieci
     * @param usuwaneDziecko Poddrzewo, ktre zostanie usunite z kolekcji poddrzew dzieci
     */    
    public void usunDziecko(EltKatBranz usuwaneDziecko) {
        this.dzieci.remove(usuwaneDziecko);
    }
    
    /**
     * Zwraca list potomkw wza w katalogu bran
     * @return Lista podbran danej grupy bran
     */    
    public List getDzieci() {
        return this.dzieci;
    }
    
    /**
     * Zwraca Bran, z ktr zwizany jest wze w Katalogu Bran
     * @return Bran, z ktr zwizany jest obiekt
     */    
    public Branza getBranza() {
        return this.branza;
    }
    
    /**
     * Ustawia zwizan z obiektem Bran
     * @param nowa Brana, z ktr obiekt bdzie zwizany
     */    
    public void setBranza(Branza nowa) {
        this.branza = nowa;
    }
       
    /**
     *  Napis zwizany z branza, nie chce przedefiniowywa toString,
     * bo ma on suy metodom Save i Load, dlatego napisaem now metod
     * i klas {@see KatTreeNode} opakowujc obiekty i wywoujc t metod
     * @return Napis reprezentujcy obiekt
     */
    public String dajNapis() {
        return this.branza.getNazwa();
    }
   
    /**
     * Konwersja drzewa bran, na model potrzebny JTree
     * @return Wze JTree, ktrego korze zwizany jest z obiektem,
     * a podwzami s drzewa podbran danej brany
     */
    public KatTreeNode wezelJTree() {
        KatTreeNode ret = new KatTreeNode(this);
        
        if (!this.dzieci.isEmpty()) {
            Iterator iterator = this.dzieci.iterator();
            for (;iterator.hasNext();) 
                ret.add(((EltKatBranz) iterator.next()).wezelJTree());
        }
        return ret;
    }
    
    /** Ustawia wartosc atrybutu odwiedzony na false w wle i poddrzewie
     * ktrego wze jest korzeniem
     */
    public void czyscOdwiedzony() {
        this.odwiedzony = false;
        Iterator iterator = this.dzieci.iterator();
        for (; iterator.hasNext();)
            ((EltKatBranz) iterator.next()).czyscOdwiedzony();
    }
    
    /** Poszukuje wza zawierajcego zadan bran w wle i jego poddrzewie
     * @param szukana Brana, z ktr zwizanego wza poszukujemy
     */
    public void szukajBranzy(shared.Branza szukana) {
        if (this.branza.getId().intValue() == szukana.getId().intValue()) {
            this.oznacz();
            return;
        }
        
        Iterator iterator = this.dzieci.iterator();
        for (; iterator.hasNext();) 
            ((EltKatBranz) iterator.next()).szukajBranzy(szukana);
    }
    
    /** Zaznacza wze i jego poddrzewo jako oznaczone */
    public void oznacz() {
        this.odwiedzony = true;
        
        Iterator iterator = this.dzieci.iterator();
        for (; iterator.hasNext();) {
            ((EltKatBranz) iterator.next()).oznacz();
        }
    }
    
    public boolean maDziecko(Branza branza) {
        Iterator iterator = this.dzieci.iterator();
        for (; iterator.hasNext();) {
            if (((EltKatBranz) iterator.next()).getBranza().getId().intValue() ==
                branza.getId().intValue())
                return true;
        }
        return false;
    }
}
