/*
 * KatTreeNode.java
 *
 * Created on 1 maj 2004, 12:23
 */

package shared.branze;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Wze w modelu dla komponentw intefejsu
 * @author  witus
 * @version %I% %G%
 */
public class KatTreeNode extends DefaultMutableTreeNode {   
    /** Tworzy nowy obiekt klasy KatTreeNode */
    public KatTreeNode() {
        super();
    }
    
    /** Tworzy nowy obiekt typu KatTreeNode
     * @param userObject element Katalogu Bran, z ktrym
     * zwizany bdzie obiekt
     */
    public KatTreeNode(EltKatBranz userObject) {
        super((Object) userObject);
    }
    
    /**
     * Zwraca napis reprezentujcy Bran, zwizan
     * z elementem Katalogu Bran, z ktrym zwizany
     * jest obiekt
     * @return Napis reprezentujcy Bran, zwizan
     * z elementem Katalogu Bran, z ktrym zwizany
     * jest obiekt
     */
    public String toString() {
        return ((EltKatBranz) this.userObject).dajNapis();
    }
    
    /** Zwraca wszystkie wzy drzewa zawierajce zadan Bran
     * @param brana - poszukiwana Brana
     * @return Lista wszystkich wzw z poddrzewa zawierajcych zadan Bran
     */
    public java.util.List szukaj(shared.Branza branza) {
        java.util.List ret = new java.util.ArrayList();
        
        if (((EltKatBranz) getUserObject()).getBranza().getId().intValue() ==
            branza.getId().intValue())
                ret.add(this);
        else {
            if (this.children == null)
                return ret;
            java.util.Iterator iterator = this.children.iterator();
            for (; iterator.hasNext();)
                ret.addAll(((KatTreeNode) iterator.next()).szukaj(branza));
        }
        return ret; 
    }
    
    /** Zwraca potomka zwierajcego zadan Bran
     * @param branza Szukana Brana
     * @return Wze bezporednio potomny zawierajcy zadan Bran,
     * null jeli takiego nie ma
     */
    public KatTreeNode dajPotomka(shared.Branza branza) {
        if (this.children == null)
            return null;
        java.util.Iterator iterator = this.children.iterator();
        for (; iterator.hasNext();) {
            KatTreeNode pom =(KatTreeNode) iterator.next();
            if (((EltKatBranz) pom.getUserObject()).getBranza().getId().intValue() ==
                branza.getId().intValue())
                    return pom;
        }
        return null;
    }
}