/*
 * KatalogBranz.java
 *
 * Created on 29 kwiecie 2004, 10:25
 */

package shared.branze;

import java.util.List;
import shared.Wyjatek;
import java.io.*;
import javax.swing.tree.*;

/**
 * Przechowuje drzewiast struktur Katalogu Bran
 * @author  witus
 * @version %I% %G%
 */
public class KatalogBranzDrzewo implements Serializable {
    /** Korze Katalogu Bran */
    private EltKatBranz korzen;
    
    /** Tworzy nowy obiekt klasy KatalogBranzDrzewo
     * @param drzewo nowy korze Katalogu Bran
     */
    public KatalogBranzDrzewo(EltKatBranz drzewo) {
        korzen = drzewo;
    }
    
    /**
     * Akcesor do korzenia Katalogu Bran
     * @return korze Katalogu Bran
     */
    public EltKatBranz getKorzen() {
        return this.korzen;
    }
    
    /**
     * Zachowuje we wskazanym miejscu Katalog Bran
     * @param path cieka do pliku, w ktrym ma by zachowany
     * Katalog Bran
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     */
    public void saveToFile(String path) throws Wyjatek {
        try {  
            ObjectOutput out = new ObjectOutputStream(new FileOutputStream(path));
            out.writeObject(this);
            out.close();
        } catch (IOException e) {
            throw new Wyjatek();
        }
    }
    
    /** 
     * Wczytanie z pliku Katalogu Bran
     * @param path scieka do pliku, w ktrym jest Katalog Bran
     * @return wczytany Katalog Bran
     * @throws Wyjatek wyrzucany w wypadku niepowodzenia operacji
     * @throws ClassNotFoundException wyrzucany w wypadku niepowodzenia operacji readObject
     */
    public KatalogBranzDrzewo loadFromFile(String path) throws Wyjatek, ClassNotFoundException {
        KatalogBranzDrzewo ret;
        
        try {
            /* Oczytamy obiekt z pliku */
            File file = new File(path);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            ret = (KatalogBranzDrzewo) in.readObject();
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
            throw new Wyjatek();
        }
        
        return ret;
    }
    
    /**
     * Przeksztacenie do obiektu, ktry moe by wywietlany w interfejsie
     * @return model Katalogu Bran, ktry mog wywietla komponenty interfejsu
     */
    public KatTreeNode dajModel() {
        return this.korzen.wezelJTree();
    }
}