/*
 * KomSieciowa.java
 *
 * Created on 26 kwiecie 2004, 22:32
 */

package user;

import shared.*;
import java.util.List;
import java.awt.Point;

/** Klasa odpowiedzialna za komunikacj sieciow Interfejsu Uytkownika z Serwerem.
 *
 * @author  ula
 */
public class KomSieciowa extends komponenty.UniKomSieciowa
                        implements komponenty.UserKomSieciowa, komponenty.MapaKomSieciowa {
    
    /** Tworzy nowy obiekt klasy KomSieciowa. 
     *
     *@param serwer   serwer, z ktrym aplet bdzie si komunikowa
     *@throws Wyjatek gdy nie powiedzie si inicjalizacja
     */
    public KomSieciowa(String serwer) throws Wyjatek {
        init(serwer);
    }
 
    /*wzr: odpala wtek (tre metody run()) i powraca) */
    /*public void aWykonaj() {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    //zrb co sieciowego
                    mapy.warstwy();
                    //powiadom interfejs
                } catch (Exception e) {
                } finally {
                    zamknijWatek();
                }
            }
        });
    }*/
    
    /** Wykonuje zapytanie na serwerze i odbiera wyniki. 
     * @param kryteria      kryteria wykonywanego zapytania
     */
    public void zapytanie(final Kryteria kryteria) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    List wyniki;
                    wyniki = ogloszenia.wyborOgloszen(kryteria);
                    KonsolaUzytkownika.konsola.odbierzWyniki(wyniki);             
                } catch (Wyjatek w) {
                    KonsolaUzytkownika.konsola.wyswietlWyjatek("Niepoprawne parametry zapytania.");
                } catch (Exception e) {
                    e.printStackTrace();
                    KonsolaUzytkownika.konsola.wyswietlWyjatek("Wystpi bd aplikacji");
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    
    public void pobierzWarstwy() {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaUzytkownika.konsola.odbierzWarstwy(mapy.warstwy());
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    public void pobierzFragmenty(final WarstwaMapy w, final int ile, final Point pkt) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaUzytkownika.konsola.odbierzFragmenty(mapy.pobierzFragmenty(w, ile, pkt));
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    public void znajdzUlice(final String nazwa) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaUzytkownika.konsola.odbierzUlice(ulice.znajdzUlice(nazwa));
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
    
    public void znajdzFragmentyUlicy(final Ulica ul) {
         odpalWatek(new Runnable() {
            public void run() {
                try {
                    KonsolaUzytkownika.konsola.odbierzFragmentyUlicy(ulice.znajdzFragmentyUlicy(ul));
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    zamknijWatek();
                }
            }
        });
    }
        
}
