/*
 * KonsolaUzytkownika.java
 *
 * Created on 9 kwiecie 2004, 20:17
 */

/*
 * <applet code=user.KonsolaUzytkownika 
 * codebase="../"
 * width=1000 height=1000></applet>
 */


package user;

import javax.swing.*;
import java.awt.*;
import java.util.*;
import shared.*;
import user.opcjeUzytkownika.*;


/** Obiekt klasy KonsolaUzytkownika przechowuje wszystkie dane potrzebne apletowi
 * do dziaania i zarzdza wywietlaniem odpowiednich widokw.
 *
 * @author  ula
 */
public class KonsolaUzytkownika extends JApplet {
    private Historia historia;
    private Ulubione ulubione = null;
    private boolean czyUlubione = true; //czy ulubione sa wlaczone, czy dzialaja ciacha
    
    //aktualnie obrabiane dane
    private FragmentMapy fragmentMapy = null;
    private java.util.List wyniki = new ArrayList();
    private java.util.List telefony = new ArrayList();
    private java.util.List branze = new ArrayList();
    
    /** Komunikacja sieciowa dla danego apletu. */
    public static KomSieciowa komSieciowa;
    /** Dany aplet, do ktrego odwouj si wszystkie widoki. */
    public static KonsolaUzytkownika konsola;
    private static JFrame frame;
    
    private JPanel card1 = new PanelPodstawowy();
    private JPanel card2 = new WidokPodstawowy();
    private JPanel card3 = new WidokUlubionych();
    private JPanel card4 = new WidokMiniStrony();
    
    final static String PODSTAWOWY = "WidokPodstawowy";
    final static String MINISTRONA = "WidokMiniStrony";
    final static String ULUBIONE = "WidokUlubionych";
    
    /** Tworzy nowy obiekt klasy KonsolaUzytkownika. 
     *
     *@throws Wyjatek gdy nie uda si utworzy apletu
     */
    public KonsolaUzytkownika() throws Wyjatek {
        historia = new Historia();
        //tu nie wolno tworzyc ulubionych, musi byc juz dzialajacy aplet
        //ulubione = new Ulubione();
    }
    

    /** Wysya zapytanie z zadanymi parametrami do bazy. 
     *
     *@param kryteria   zadane parametry wyszukiwania
     */
    public void zapytanie(Kryteria kryteria) {
        historia.dodaj(kryteria);
        this.komSieciowa.zapytanie(kryteria);
    }

    /** Wysya zapytanie do bazy z zadan bran jako jedynym parametrem. 
     *
     *@param nr     numer brany na licie najpopularniejszych bran
     */
    public void zapytanieBranza(int nr) {
        Kryteria k = new Kryteria();
        k.setIle(10);
        k.setZacznijOd(0);
        k.setBranza(((NajpopularniejszaBranza)branze.get(nr)).getBranza());
        ((WidokPodstawowy)card2).ustawZapytanie(k);
        zapytanie(k);
        
        podmienWidok(PODSTAWOWY);
    }
    
    /** Wysya zapytanie z zadanymi parametrami do bazy i przecza widok na podstawowy. 
     *
     *@param nr     numer wstecz pamitanych przez Histori kryteriw
     */
    public void zapytanieHistoria(int nr) {
        ((WidokPodstawowy)card2).ustawZapytanie(historia.pokaz(nr));
        zapytanie(historia.pokaz(nr));
        
        podmienWidok(PODSTAWOWY);
    }
    
    /** Wywietla na menu Historii odpowiednie nazwy starych wyszukiwa.
     *
     *@param str1   string identyfikujcy ostatnie wyszukiwanie
     *@param str2   string identyfikujcy przedostatnie wyszukiwanie
     *@param str3   string identyfikujcy najstarsze wyszukiwanie
     */
    public void wyswietlNaMenuHistorii(String str1, String str2, String str3) {
        ((PanelPodstawowy)card1).wyswietlNaHistorii(2, str1);
        ((PanelPodstawowy)card1).wyswietlNaHistorii(1, str2);
        ((PanelPodstawowy)card1).wyswietlNaHistorii(0, str3);
    }
    
    /** Inicjuje widoki w module uytkownika. */
    public void inicjujWidoki() {
        Container cp = getContentPane();        
        JPanel cards = new JPanel(new CardLayout());
        
        cards.add(card2, PODSTAWOWY);
        cards.add(card3, ULUBIONE);
        cards.add(card4, MINISTRONA);
        
        cp.setLayout(new BorderLayout());
        cp.add(card1, BorderLayout.WEST);
        cp.add(cards, BorderLayout.CENTER);

        cp.validate();
    }    
        
    /** Usuwa biecy widok, zastpujc go podanym nowym.
     *  @param ident panel do wywietlenia w oknie
     */
    private void podmienWidok(String ident) {
        Container cp = getContentPane();
        JPanel comp = (JPanel) cp.getComponent(1);
        CardLayout cl = (CardLayout) comp.getLayout();
        cl.show(comp, ident);
    }
    
    /** Wcza nowy widok zapyta. */
    public void nowyWidokZapytan() {
        wyniki.clear();
        telefony.clear();
        fragmentMapy = null;

        try {
            Container cp = getContentPane();
            JPanel jp = (JPanel)cp.getComponent(1);
            WidokPodstawowy wp = (WidokPodstawowy) jp.getComponent(0);
            wp.noweZapytanie();
        } catch (Exception e) {
            e.printStackTrace();
        }                
        podmienWidok(PODSTAWOWY);
    }
    
    /** Wcza widok zapyta i wynikw z ostatniego zapytania. */
    public void pokazWidokPodstawowy() {
        try {
            Container cp = getContentPane();
            JPanel jp = (JPanel)cp.getComponent(1);
            WidokPodstawowy wp = (WidokPodstawowy) jp.getComponent(0);
        } catch (Exception e) {
            e.printStackTrace();
        }                
        podmienWidok(PODSTAWOWY);
    }
    
    /** Wcza nowy widok ulubionych. */
    public void nowyWidokUlubionych() {
        try {
            Container cp = getContentPane();
            JPanel jp = (JPanel)cp.getComponent(1);
            WidokUlubionych wu = (WidokUlubionych) jp.getComponent(1);
            wu.wyswietlUlubione(ulubione.pokaz());
        } catch (Exception e) {
            e.printStackTrace();
        }                
        
        podmienWidok(ULUBIONE);
    }
    
    /** Dodaje do ulubionych ogoszenie z listy wynikw.
     *
     * @param nr    numer dodawanego ogoszenia
     */
    public void dodajDoUlubionych(int nr) {
        Ogloszenie ogl = (Ogloszenie) wyniki.get(nr);
        //wybor kategorii dla ogloszenia
        
        if (czyUlubione(ogl.getId())) {
            //update automatyczny przy sciaganiu wynikow z serwera
            //String tel = (String)((ArrayList)((ArrayList)telefony.get(nr)).get(0)).get(0);
            //ulubione.update(ogl, tel);
        }
        else {
            String[] stmp = new String[ulubione.pobierzKategorie().size()+1];
            stmp[0] = "NOWA KATEGORIA";
            for (int i = 0; i<ulubione.pobierzKategorie().size(); i++)
                stmp[i+1] = (String)ulubione.pobierzKategorie().get(i);
            String kat = "";
            kat = (String)JOptionPane.showInputDialog(this, "Ulubione maj rne kategorie.", 
                                "Kategoria ulubionych", JOptionPane.QUESTION_MESSAGE, null,
                                stmp, stmp[0]);
            if (kat == "NOWA KATEGORIA") {
                kat = (String)JOptionPane.showInputDialog(this, "Podaj now kategori.");
                System.out.println("KATEGORIA = " + kat + "FF");
                if (kat == null || kat.length() == 0)
                    kat = " ";
                else
                    kat = kat.toUpperCase();
            }
            //dodanie do ulubionych
            String tel = (String)((ArrayList)((ArrayList)telefony.get(nr)).get(0)).get(0);
            ulubione.dodaj(new UlubioneOgloszenie(ogl, tel, kat));
        }        
    }
    
    /** Usuwa z ulubionych ogosze podane ogoszenie.
     *
     * @param ulub  ulubione ogoszenie do usunicia
     */
    public void usunZUlubionych(UlubioneOgloszenie ulub) {
        ulubione.usun(ulub);
        ((WidokPodstawowy)card2).nieUlubione(ulub.getId());
    }    
    
    /** Sprawdza czy ogoszenie o podanym identyfikatorze znajduje si na licie ulubionych. 
     *
     *@param id     identyfikator ogoszenia, ktre jest sprawdzane
     *@return true jeli ogoszenie znajduje si na licie ulubionych
     */
    public boolean czyUlubione(Integer id) {
        if (czyUlubione)
            return ulubione.czyUlubione(id);        
        else
            //nie powinno wystapic ale na wszelki wypadek 
            return false;
    }
    
    /** Wcza widok wywietlania mini strony dla podanego ogoszenia.
     * 
     * @param nr    numer ogoszenia, ktrego mini strone chcemy wywietli
     */
    public void pokazWidokMiniStrony(int nr) {
        Ogloszenie ogl = (Ogloszenie) wyniki.get(nr);
        /*
        if (ogl.getPlatne() == null) {
            String errmsg = "Dla danego ogoszenia nie ma mini strony.";
            JOptionPane.showMessageDialog(this, errmsg);
            return;
        }
         */
        /*
        try {
            Container cp = getContentPane();
            JPanel jp = (JPanel)cp.getComponent(1);
            WidokPodstawowy wp = (WidokPodstawowy) jp.getComponent(2);
            
        } catch (Exception e) {
            e.printStackTrace();
        }                
        podmienWidok(MINISTRONA);
        */
        //na razie mini strona w nowym okienku
        
        JFrame frame = new JFrame("NIIKT- Mini strona: " + ogl.getNazwa());
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        
        //w zaleznosci od polozenia logo tak ustawiamy layout
        Container c = frame.getContentPane();
        c.removeAll();
        c.setLayout(new BorderLayout());

        WidokMiniStrony widokMiniStrony = new WidokMiniStrony(ogl, (ArrayList)telefony.get(nr));  
        
        c.add(widokMiniStrony, BorderLayout.CENTER);
        if (ogl.getPlatne().getLogoGdzie() == komponenty.PomocnikFirmaUser.GORA_LOGO)             
            c.add(new WidokLogo(ogl), BorderLayout.NORTH);
        else if (ogl.getPlatne().getLogoGdzie() == komponenty.PomocnikFirmaUser.DOL_LOGO) 
                c.add(new WidokLogo(ogl), BorderLayout.SOUTH);
            else if (ogl.getPlatne().getLogoGdzie() == komponenty.PomocnikFirmaUser.LEWO_LOGO) 
                    c.add(new WidokLogo(ogl), BorderLayout.WEST);
                else 
                    c.add(new WidokLogo(ogl), BorderLayout.EAST);
        c.validate();
        frame.setBounds(20, 20, 700, 500);
        frame.setVisible(true);
    }
    
    /** Odbiera wyniki wyszukiwania z serwera. Zapamituje na zmiennych lokalnych
     * telefony i ogoszenia, a nastpnie przekazuje wyniki podwidokom do wywietlenia.
     *
     * @param listaWynikow  wyniki do odebrania
     */
    public void odbierzWyniki(java.util.List listaWynikow) {                 
        wyniki.clear();
        telefony.clear();
        fragmentMapy = null;
        //pobierz ogloszenia
        for (int i = 0; i<(listaWynikow.size()-1)/2; i++) 
            wyniki.add(listaWynikow.get(i+1));    
        //pobierz telefony z konca listy
        for (int i = (listaWynikow.size()-1)/2; i<listaWynikow.size()-1; i++)
            telefony.add(listaWynikow.get(i+1));
        //pobierz fragment mapy lub null gdy wyswietlamy bez mapy
        FragmentMapy fragmentMapy = (FragmentMapy)listaWynikow.remove(0);
        
        //aktualizuj ulubione
        if (czyUlubione) {         
            for (int i =0; i< wyniki.size(); i++) {
                Ogloszenie ogl = (Ogloszenie) wyniki.get(i);
                if (czyUlubione(ogl.getId())) {
                    String tel = (String)((ArrayList)((ArrayList)telefony.get(i)).get(0)).get(0);
                    ulubione.update(ogl, tel);
                }
            }    
        }    

        ((WidokPodstawowy)card2).wyswietlWyniki(fragmentMapy, wyniki, telefony);
    }    
    
    /** Przekazuje do widoku podstawowego komunikat do wywietlenia. 
     *
     *@param str    komunikat
     */
    public void wyswietlWyjatek(String str) {
        ((WidokPodstawowy)card2).wyswietlWyjatek(str);
    }
    
    /** Pokazuje dane ogoszenie z listy wynikw na mapce.
     *
     * @param nr    numer ogoszenia na licie wynikw, ktre zostao kliknite
     */
    public void kliknietaLista(int nr) {
        ((WidokPodstawowy)card2).kliknietaLista(nr);
    }
    
    /** Zaznacza na licie wynikw kliknit na mapce firm.
     *
     * @param nr    numer kliknitego ogoszenia na licie wynikw
     */
    public void kliknietaMapka(int nr) {
        ((WidokPodstawowy)card2).kliknietaMapka(nr);
        
    }
    
    /** Przyjmuje i zapamituje odebrane z serwera warstwy mapy.
     *  @param warstwy odebrane warstwy mapy
     */
    public void odbierzWarstwy(WarstwaMapy[] warstwy) {
        ((WidokPodstawowy)card2).odbierzWarstwy(warstwy);
    }
       
    /** Przyjmuje i zapamituje odebrane z serwera fragmenty mapy.
     *  @param fr odebrane fragmenty mapy
     */
    public void odbierzFragmenty(FragmentMapy[] fr) {
        ((WidokPodstawowy)card2).odbierzFragmenty(fr);
    }
    
    /** Przyjmuje i zapamituje odebrane z serwera fragmenty ulicy.
     *  @param fr odebrane fragmenty ulicy
     */
    public void odbierzFragmentyUlicy(FragmentUlicy[] fr) {
        ((WidokPodstawowy)card2).odbierzFragmentyUlicy(fr);
    }

    /** Przyjmuje i zapamituje odebrane z serwera ulice.
     *  @param ul odebrane ulice
     */
    public void odbierzUlice(java.util.List ul) {
        ((WidokPodstawowy)card2).odbierzUlice(ul);
    }

    
    /** Generuje i zapisuje na komputerze uytkownika wizytwk ogoszenia o wskazanym
     * numerze.
     *
     *@param nr     numer ogoszenia na licie wynikw, dla ktrego generowana bdzie wizytwka
     */
    public void generujWizytowke(int nr) {
        try {
            String tel = null;
            if (telefony.get(nr) != null)  {
                tel = (String)((ArrayList)((ArrayList)telefony.get(nr)).get(0)).get(0);
            }
            this.komSieciowa.kontaFirm.generujWizytowke((Ogloszenie)wyniki.get(nr), tel);
            String adresWizytowki =  this.komSieciowa.kontaFirm.adresWizytowki(((Ogloszenie)wyniki.get(nr)).getId());
            this.getAppletContext().showDocument(new java.net.URL(adresWizytowki), "_blank");        
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    
    public void init() {
        try {
            komSieciowa = new KomSieciowa(getCodeBase().getHost());
            konsola = this;
        } catch (Exception e) {
            e.printStackTrace();
        }
        //sprawdz czy dzialaja ciacteczka
        ulubione = new Ulubione();
        czyUlubione = ulubione.checkCookie();
        this.inicjujWidoki();
        //ustaw ulubione na panelu podstawowym i w widoku podstawowym
        ((PanelPodstawowy)card1).ustawGuzikUlubionych(czyUlubione);
        ((WidokPodstawowy)card2).ustawGuzikUlubionych(czyUlubione);
        if (!czyUlubione)
            wyswietlWyjatek("Opcje ulubionych s niedostpne. Sprawd ustawienia ciasteczek w przegldarce i przeaduj aplet.");
        //sciagnij liste najpop branz i wyswietl ja
        try {
            branze = this.komSieciowa.pobierzKatalogNajBranz(getCodeBase().toString());
            ((PanelPodstawowy)card1).wyswietlNaBranzach(branze);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
  
}
