/*
 * NawigacjaMapaLokalizacja.java
 *
 * Created on 21 czerwiec 2004, 21:05
 */

package user;

import komponenty.*;
import shared.*;
import java.awt.*;
import java.awt.event.*;
import java.util.List;
import java.util.ListIterator;
import javax.swing.*;

/** Komponent, odpowiedzialny za lokalizacj firm na mapie. Wykorzystywany przez interfejs 
 *  Moduu Uytkownika do realizacji opcji "Lokalizacja", gdy uytkownik
 *  nie zayczy sobie od razy prezentacji wynikw na mapie.
 *
 * @author  me201258
 */
public class NawigacjaMapaLokalizacja extends NawigacjaMapa {
    
    private Ogloszenie ogl = null;
    private BasicStroke strokeZaznaczenia = new BasicStroke(3.0f);
    private Color kolorUlicy = Color.GRAY;
    private boolean wymagaPrzeliczenia = false;

    /** Tworzy nowy obiekt klasy NawigacjaMapaLokalizacja. */
    public NawigacjaMapaLokalizacja() {
        rozmiarMapkiSlider.setMaximum(5);
    }
    
    public void initWidok(MapaKomSieciowa mKomSieciowa, String adresSerwera) {
        super.initWidok(mKomSieciowa, adresSerwera);
    }
    
    public void paint(Graphics g) {
        super.paint(g);
        if (ogl == null || lewyGornyPkt == null) return;        
        
        //Rysujemy znaczniki ogosze
        Graphics2D mg = (Graphics2D) g.create(pomMapaPanel.getLocation().x,
                               pomMapaPanel.getLocation().y,
                               mapaPanel.getWidth(),
                               mapaPanel.getHeight());
        mg.setStroke(strokeZaznaczenia);
        
        Point p = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(ogl.getWspolrzedna_x(), ogl.getWspolrzedna_y()));
        p.x -= lewyGornyPkt.x;
        p.y -= lewyGornyPkt.y;
        mg.setColor(Color.BLUE);
        mg.fillRect(p.x-8,p.y-8, 17, 17);
        
        if (frUlicy == null) return;
        if (frUlicy.length == 0) return;
        
        //rysujemy przebieg ulicy
        Point poczf, konf;
	int i;
        for (i=0; i<frUlicy.length; i++) {
            mg.setColor(kolorUlicy);
            poczf = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(frUlicy[i].getWsp_pocz_x(), frUlicy[i].getWsp_pocz_y()));
            konf = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(frUlicy[i].getWsp_konc_x(), frUlicy[i].getWsp_konc_y()));
            poczf.x -= lewyGornyPkt.x;
            poczf.y -= lewyGornyPkt.y;
            konf.x -= lewyGornyPkt.x;
            konf.y -= lewyGornyPkt.y;
            mg.drawLine(poczf.x, poczf.y, konf.x, konf.y);
        }
                
    }

    protected void pobierzFragmenty() {
        if (wymagaPrzeliczenia) {
            centralnyPkt = new Point(ogl.getWspolrzedna_x(), ogl.getWspolrzedna_y());
            wymagaPrzeliczenia = false;
        }
        super.pobierzFragmenty();
    }
    
    public void przyszlyFragmentyMapy() {
        repaint();
    }

    protected void fragmentyMapyNarysowane() {
        repaint();
    }
    
    /** Ustawia map tak, aby widoczne byo na niej zadane ogoszenie; zaznacza ogoszenie na mapie.
     *  @param ogloszenie ogoszenie do pokazania
     */
    public void pokazOgloszenie(Ogloszenie ogloszenie) {
        ogl = ogloszenie;
        if (lewyGornyPkt == null) //nie ma jeszcze zadnej warstwy
            wymagaPrzeliczenia = true;
        else {
            Point bezwzglLG = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, lewyGornyPkt);
            Point bezwzglPD = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, new Point(lewyGornyPkt.x+ileFragmentow*biezacaWarstwa.getRozmiar_x(),
                                                                                           lewyGornyPkt.y+ileFragmentow*biezacaWarstwa.getRozmiar_y()));
            Point potrzebne = new Point(ogl.getWspolrzedna_x(), ogl.getWspolrzedna_y());
            if (potrzebne.x > bezwzglPD.x || potrzebne.x < bezwzglLG.x 
              ||potrzebne.y > bezwzglPD.y || potrzebne.y < bezwzglLG.y) {
                  przesunWidok(potrzebne);
            }
        }
        repaint();
    }

}
