/*
 * NawigacjaMapaUser.java
 *
 * Created on 17 czerwiec 2004, 21:28
 */

package user;

import komponenty.*;
import shared.*;
import java.awt.*;
import java.awt.event.*;
import java.util.List;
import java.util.ListIterator;
import javax.swing.*;

/** Komponent wizualizacji wynikw wyszukiwania na mapie.
 *
 * @author  me201258
 */
public class NawigacjaMapaUser extends komponenty.NawigacjaMapa {
    /** Lista prezentowanych na mapce ogosze. */
    private List ogloszenia;
    private final Stroke strokeZaznaczenia = new BasicStroke(3.0f);
    private int wybranaFirma = -1;
    private Color kolorUlicy = Color.GRAY;
    
    /** Tworzy nowy obiekt klasy NawigacjaMapaUser. */
    public NawigacjaMapaUser() {
        rozmiarMapkiSlider.setMaximum(5);
    }
     
    /** Wyrnia na mapie wybran firm.
     *  @param nr numer (0..<liczba_firm_w_wynikach-1>) wybranej firmy
     */
    public void wybranoFirme(int nr) {
        wybranaFirma = nr;
        if (lewyGornyPkt == null || nr == -1) return;
        Ogloszenie wybr = (Ogloszenie) ogloszenia.get(nr);
        Point bezwzglLG = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, lewyGornyPkt);
        Point bezwzglPD = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, new Point(lewyGornyPkt.x+ileFragmentow*biezacaWarstwa.getRozmiar_x(),
                                                                                       lewyGornyPkt.y+ileFragmentow*biezacaWarstwa.getRozmiar_y()));
        Point potrzebne = new Point(wybr.getWspolrzedna_x(),wybr.getWspolrzedna_y());
        if (potrzebne.x > bezwzglPD.x || potrzebne.x < bezwzglLG.x 
          ||potrzebne.y > bezwzglPD.y || potrzebne.y < bezwzglLG.y) {
              przesunWidok(potrzebne);
        }
        repaint();
    }
    
    /** Inicjalizuje widok mapy, pobierajc z serwera wszystkie potrzebne informacje. 
     *  @param mKomSieciowa obiekt komunikacji sieciowej
     *  @param adresSerwera adres http serwera
     *  @param fr preferowany do wywietlenia fragment mapy
     *  @param wyniki lista ogosze do wywietlenia
     */
    public void initWidok(MapaKomSieciowa mKomSieciowa, String adresSerwera, FragmentMapy fr, List wyniki) {
        biezacaWarstwa = fr.getIdWarstwy();
        centralnyPkt = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, new Point((fr.getWsp_lg_x()+fr.getWsp_pd_x())/2, (fr.getWsp_lg_y()+fr.getWsp_pd_y())/2));
        biezacaWarstwaId = fr.getIdWarstwy().getId().intValue();
        ogloszenia = wyniki;
        initWidok(mKomSieciowa, adresSerwera);
    }
    
    /** Metoda wywoywana, gdy uytkownik kliknie gdzie na mapce.
     *  @param evt zdarzenie kliknicia
     */
    public void kliknietaMapka(MouseEvent evt) {
        Point tmpp = ((JLabel)evt.getSource()).getLocation();
        int klikx = evt.getX()-1+lewyGornyPkt.x+tmpp.x-1;
        int kliky = evt.getY()-1+lewyGornyPkt.y+tmpp.y-1;
        Point bzwzglklik = PomocnikMapy.wzgledneNaBezwzgledne(biezacaWarstwa, new Point(klikx, kliky));
        
        Ogloszenie ogl;
        double najblD = -1, tmpD;
        int najblI=0, i=0;
        ListIterator oli = ogloszenia.listIterator();
        while (oli.hasNext()) {
            ogl = (Ogloszenie) oli.next();
            tmpD = bzwzglklik.distance(ogl.getWspolrzedna_x(), ogl.getWspolrzedna_y());
            if (najblD == -1 || tmpD < najblD) {
                najblI = i;
                najblD = tmpD;
            }
            i++;
        }
        if (najblD > 0) {
            KonsolaUzytkownika.konsola.kliknietaMapka(najblI);
            wybranoFirme(najblI);
        }
    }

    protected MouseAdapter stworzPopupMenuDlaFragmentuObecnego() {
        return new MouseAdapter() {
                        public void mouseReleased(MouseEvent evt) {
                            if (evt.getClickCount() == 1 && evt.getButton() == MouseEvent.BUTTON1)
                                kliknietaMapka(evt);
                        }
                    };
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (ogloszenia == null || lewyGornyPkt == null) return;        
        
        //Rysujemy znaczniki ogosze
        ListIterator oli = ogloszenia.listIterator();
        Point p;
        Ogloszenie ogl;
        int i = 0;
        Graphics2D mg = (Graphics2D) g.create(pomMapaPanel.getLocation().x,
                               pomMapaPanel.getLocation().y,
                               mapaPanel.getWidth(),
                               mapaPanel.getHeight());
        mg.setStroke(strokeZaznaczenia);
        
        while (oli.hasNext()) {
            ogl = (Ogloszenie)oli.next();
            if (wybranaFirma != i) {
                i++;
                p = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(ogl.getWspolrzedna_x(), ogl.getWspolrzedna_y()));
                p.x -= lewyGornyPkt.x;
                p.y -= lewyGornyPkt.y;
                mg.setColor(Color.BLUE);
                mg.fillRect(p.x-8,p.y-8, 17, 17);
                mg.setColor(Color.WHITE);
                if (i<10)
                    mg.drawString(String.valueOf(i), p.x-3, p.y+5);
                else
                    mg.drawString(String.valueOf(i), p.x-8, p.y+5);
            } else
                i++;
        }
        
        if (wybranaFirma != -1) {
            ogl = (Ogloszenie) ogloszenia.get(wybranaFirma);
            p = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(ogl.getWspolrzedna_x(), ogl.getWspolrzedna_y()));
            p.x -= lewyGornyPkt.x;
            p.y -= lewyGornyPkt.y;
            mg.setColor(Color.BLUE);
            mg.fillRect(p.x-14, p.y-14, 29, 29);
            mg.setColor(Color.WHITE);
            if (wybranaFirma+1<10)
                mg.drawString(String.valueOf(wybranaFirma+1), p.x-3, p.y+5);
            else
                mg.drawString(String.valueOf(wybranaFirma+1), p.x-8, p.y+5);
        }
        
        if (frUlicy == null) return;
        if (frUlicy.length == 0) return;
        
        //rysujemy przebieg ulicy
        Point poczf, konf;
        for (i=0; i<frUlicy.length; i++) {
            mg.setColor(kolorUlicy);
            poczf = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(frUlicy[i].getWsp_pocz_x(), frUlicy[i].getWsp_pocz_y()));
            konf = PomocnikMapy.bezwzgledneNaWzgledne(biezacaWarstwa, new Point(frUlicy[i].getWsp_konc_x(), frUlicy[i].getWsp_konc_y()));
            poczf.x -= lewyGornyPkt.x;
            poczf.y -= lewyGornyPkt.y;
            konf.x -= lewyGornyPkt.x;
            konf.y -= lewyGornyPkt.y;
            mg.drawLine(poczf.x, poczf.y, konf.x, konf.y);
        }
                
    }
    
    public void przyszlyFragmentyMapy() {
        repaint();
    }

    protected void fragmentyMapyNarysowane() {
        repaint();
    }

}
