/*
 * PanelPodstawowy.java
 *
 * Created on 27 kwiecie 2004, 12:27
 */

package user;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** Panel menu dostpnych uytkownikowi opcji.
 *
 * @author  ula
 */
public class PanelPodstawowy extends javax.swing.JPanel{

    /** Tworzy nowy obiekt klasy PanelPodstawowy. */
    public PanelPodstawowy() {
        
        initComponents();
        
        setMaximumSize(new java.awt.Dimension(140, 300));
	setMinimumSize(new java.awt.Dimension(140, 300));
	setPreferredSize(new java.awt.Dimension(140,300));                
    }
    
    /** Ustawia dostpno guzika ulubionych w zalenoci, 
     * czy opcja ciasteczek w przegldarce jest wczona. 
     *
     *@param czy    true lub false, czy wczy guzik ulubionych
     */
    public void ustawGuzikUlubionych(boolean czy) {
        UlubioneButton.setEnabled(czy);
    }
    
    
    /** Wywietla na odpowiedniej pozycji w menu Historii zadany String. 
     *
     *@param nr     numer pozycji, na ktrej wywietli
     *@param str    strig do wywietlenia
     */
    public void wyswietlNaHistorii(int nr, String str) {
        if (str.length() < 20)
            for (int i = 0; i<20-str.length(); i++)
                str.concat(" ");
        
        if (nr == 2)
            staryLabel.setText("1. " + str);
        else if (nr == 1)
                starszyLabel.setText("2. " + str);
        else
            najstarszyLabel.setText("3. " + str);
    }
    
    /** Wywietla list najpopularniejszych bran w menu Bran. 
     *
     *@param    branze  lista bran
     */
    public void wyswietlNaBranzach(java.util.List branze) {
        for (int i = 0; i<branze.size() && i<10; i++)
            wyswietlBranze(i, ((shared.NajpopularniejszaBranza)branze.get(i)).getBranza().getNazwa());            
    }
    
    private void wyswietlBranze(int nr, String str) {
        switch (nr) {
            case 0:  { jLabel1.setText("1. " + str); break; }
            case 1:  { jLabel2.setText("2. " + str); break; }
            case 2:  { jLabel3.setText("3. " + str); break; }
            case 3:  { jLabel4.setText("4. " + str); break; }
            case 4:  { jLabel5.setText("5. " + str); break; }
            case 5:  { jLabel6.setText("6. " + str); break; }
            case 6:  { jLabel7.setText("7. " + str); break; }
            case 7:  { jLabel8.setText("8. " + str); break; }
            case 8:  { jLabel9.setText("9. " + str); break; }
            case 9:  { jLabel10.setText("10. " + str); break; }            
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        popup = new javax.swing.JPopupMenu();
        staryMenuItem = new javax.swing.JMenuItem();
        starszyMenuItem = new javax.swing.JMenuItem();
        najstarszyMenuItem = new javax.swing.JMenuItem();
        branzePopup = new javax.swing.JPopupMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMenuItem3 = new javax.swing.JMenuItem();
        jMenuItem4 = new javax.swing.JMenuItem();
        jMenuItem5 = new javax.swing.JMenuItem();
        jPanel1 = new javax.swing.JPanel();
        NoweZapytanieButton = new javax.swing.JButton();
        UlubioneButton = new javax.swing.JButton();
        historiaPanel = new javax.swing.JPanel();
        staryLabel = new javax.swing.JLabel();
        starszyLabel = new javax.swing.JLabel();
        najstarszyLabel = new javax.swing.JLabel();
        branzePanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();

        staryMenuItem.setText("Stary");
        popup.add(staryMenuItem);

        starszyMenuItem.setText("Starszy");
        popup.add(starszyMenuItem);

        najstarszyMenuItem.setText("Najstarszy");
        popup.add(najstarszyMenuItem);

        jMenuItem1.setText("Item");
        branzePopup.add(jMenuItem1);

        jMenuItem2.setText("Item");
        branzePopup.add(jMenuItem2);

        jMenuItem3.setText("Item");
        branzePopup.add(jMenuItem3);

        jMenuItem4.setText("Item");
        branzePopup.add(jMenuItem4);

        jMenuItem5.setText("Item");
        branzePopup.add(jMenuItem5);

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        setBorder(new javax.swing.border.TitledBorder("Menu"));
        jPanel1.setLayout(new java.awt.GridLayout(2, 1));

        jPanel1.setMaximumSize(new java.awt.Dimension(32767, 80));
        NoweZapytanieButton.setText("<html>Nowe<br>Zapytanie</html>");
        NoweZapytanieButton.setToolTipText("Prze\u0142\u0105cza widok umo\u017cliwiaj\u0105c zadanie nowego wyszukiwania.");
        NoweZapytanieButton.setMinimumSize(new java.awt.Dimension(190, 30));
        NoweZapytanieButton.setPreferredSize(new java.awt.Dimension(100, 48));
        NoweZapytanieButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                NoweZapytanieButtonActionPerformed(evt);
            }
        });

        jPanel1.add(NoweZapytanieButton);

        UlubioneButton.setText("<html>Ulubione<br>Menu");
        UlubioneButton.setToolTipText("Prze\u0142acza na widok ulubionych og\u0142osze\u0144.");
        UlubioneButton.setMinimumSize(new java.awt.Dimension(190, 40));
        UlubioneButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                UlubioneButtonActionPerformed(evt);
            }
        });

        jPanel1.add(UlubioneButton);

        add(jPanel1);

        historiaPanel.setLayout(new java.awt.GridLayout(3, 1));

        historiaPanel.setBorder(new javax.swing.border.TitledBorder(null, "Historia", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 10)));
        historiaPanel.setMaximumSize(new java.awt.Dimension(1500, 70));
        staryLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        staryLabel.setText("1. ");
        staryLabel.setToolTipText("Ostatnie zapytanie.");
        staryLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                staryLabelMouseClicked(evt);
            }
        });

        historiaPanel.add(staryLabel);

        starszyLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        starszyLabel.setText("2.");
        starszyLabel.setToolTipText("Przedostatnie zapytanie.");
        starszyLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                starszyLabelMouseClicked(evt);
            }
        });

        historiaPanel.add(starszyLabel);

        najstarszyLabel.setFont(new java.awt.Font("Dialog", 0, 11));
        najstarszyLabel.setText("3.");
        najstarszyLabel.setToolTipText("Przedprzedostatnie zapytanie.");
        najstarszyLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                najstarszyLabelMouseClicked(evt);
            }
        });

        historiaPanel.add(najstarszyLabel);

        add(historiaPanel);

        branzePanel.setLayout(new java.awt.GridLayout(10, 1));

        branzePanel.setBorder(new javax.swing.border.TitledBorder(null, "Popularne bran\u017ce", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 10)));
        branzePanel.setMaximumSize(new java.awt.Dimension(32767, 210));
        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setToolTipText("Najpopularniejsza bran\u017ca. Wy\u015bwietli wyniki wyszukiwania dla firm z tej bran\u017cy.");
        jLabel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel1MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel1);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel2MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel2);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel3MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel3);

        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel4MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel4);

        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel5MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel5);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel6MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel6);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel7MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel7);

        jLabel8.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel8.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel8MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel8);

        jLabel9.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel9.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel9MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel9);

        jLabel10.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel10.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel10MouseClicked(evt);
            }
        });

        branzePanel.add(jLabel10);

        add(branzePanel);

    }//GEN-END:initComponents

    private void jLabel10MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel10MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(9);
    }//GEN-LAST:event_jLabel10MouseClicked

    private void jLabel9MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel9MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(8);
    }//GEN-LAST:event_jLabel9MouseClicked

    private void jLabel8MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel8MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(7);
    }//GEN-LAST:event_jLabel8MouseClicked

    private void jLabel7MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel7MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(6);
    }//GEN-LAST:event_jLabel7MouseClicked

    private void jLabel6MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel6MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(5);
    }//GEN-LAST:event_jLabel6MouseClicked

    private void jLabel5MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel5MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(4);
    }//GEN-LAST:event_jLabel5MouseClicked

    private void jLabel4MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel4MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(3);
    }//GEN-LAST:event_jLabel4MouseClicked

    private void jLabel3MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel3MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(2);
    }//GEN-LAST:event_jLabel3MouseClicked

    private void jLabel2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel2MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(1);
    }//GEN-LAST:event_jLabel2MouseClicked

    private void jLabel1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel1MouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieBranza(0);
    }//GEN-LAST:event_jLabel1MouseClicked

    private void najstarszyLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_najstarszyLabelMouseClicked
        // Add your handling code here:
        //najstarszy - 0
        //starszy - 1
        //stary - 2
        KonsolaUzytkownika.konsola.zapytanieHistoria(0);
    }//GEN-LAST:event_najstarszyLabelMouseClicked

    private void starszyLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_starszyLabelMouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieHistoria(1);
    }//GEN-LAST:event_starszyLabelMouseClicked

    private void staryLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_staryLabelMouseClicked
        // Add your handling code here:
        KonsolaUzytkownika.konsola.zapytanieHistoria(2);
    }//GEN-LAST:event_staryLabelMouseClicked

    private void UlubioneButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_UlubioneButtonActionPerformed
        // Add your handling code here:
        KonsolaUzytkownika.konsola.nowyWidokUlubionych();
    }//GEN-LAST:event_UlubioneButtonActionPerformed

    private void NoweZapytanieButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_NoweZapytanieButtonActionPerformed
        // Add your handling code here:
        KonsolaUzytkownika.konsola.nowyWidokZapytan();
    }//GEN-LAST:event_NoweZapytanieButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton NoweZapytanieButton;
    private javax.swing.JButton UlubioneButton;
    private javax.swing.JPanel branzePanel;
    private javax.swing.JPopupMenu branzePopup;
    private javax.swing.JPanel historiaPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JMenuItem jMenuItem4;
    private javax.swing.JMenuItem jMenuItem5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel najstarszyLabel;
    private javax.swing.JMenuItem najstarszyMenuItem;
    private javax.swing.JPopupMenu popup;
    private javax.swing.JLabel starszyLabel;
    private javax.swing.JMenuItem starszyMenuItem;
    private javax.swing.JLabel staryLabel;
    private javax.swing.JMenuItem staryMenuItem;
    // End of variables declaration//GEN-END:variables
    
}
