/*
 * WidokLogo.java
 *
 * Created on 25 maj 2004, 19:21
 */

package user;

import javax.swing.*;
import java.awt.*;

import shared.Ogloszenie;

/** Podwidok klasy WidokMiniStrony, na ktrym wywietlane jest logo firmy.
 *
 * @author  ula
 */
public class WidokLogo extends javax.swing.JPanel {
    private Ogloszenie ogl;
    
    /** Tworzy nowy obiekt klasy WidokLogo. 
     *
     *@param ogloszenie     ogoszenie, ktrego logo bdzie wywietlane
     */
    public WidokLogo(Ogloszenie ogloszenie) {
        initComponents();
        
        logoPanel.setMinimumSize(new java.awt.Dimension(100, 100));
        logoPanel.setMaximumSize(new java.awt.Dimension(100, 100));
        logoPanel.setPreferredSize(new java.awt.Dimension(100, 100));
        this.setBackground(Color.WHITE);
        
        ogl = ogloszenie;
        pobierzWyswietlLogo();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        logoPanel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        add(logoPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    
     /**
     * Wyswietla ikone z logo.
     *
     * @param ii Ikona z logo do wywietlenia
     */
    public void wyswietlLogo(ImageIcon ii) {
        try {
            logoPanel.removeAll();
            logoPanel.setLayout(new GridLayout(1, 1));
            JLabel picture = new JLabel();
            picture.setHorizontalAlignment(JLabel.CENTER);
            picture.setAlignmentX(Component.CENTER_ALIGNMENT);
            picture.setIcon(ii);
            logoPanel.invalidate();
            logoPanel.add(picture);
            logoPanel.validate();
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Nie mo\u0017cna wy\u015bwietli\u0107 pliku.");
        }
    }
    
     /**
     * Pobiera i wywietla logo. Jeli pobieranie logo si nie powiedzie (gdy na przykad
     * firma nie umiecia swojego logo na serwerze) to nic si nie dzieje.
     */
    public void pobierzWyswietlLogo() {
        java.net.URL u;
        try {
            String s = KonsolaUzytkownika.konsola.komSieciowa.kontaFirm.konstruujHttpSciezkeLogo(ogl.getId());
            u = new java.net.URL(s);
            ImageIcon ii = new ImageIcon(u);
            wyswietlLogo(ii);
        } catch (Exception e) {
            e.printStackTrace();
            /* nie informujemy, ze sie nie udalo, bo dostajemy
             * wyjatek, jak do ogloszenia po prostu nie jest przypisane
             * zadne logo */
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel logoPanel;
    // End of variables declaration//GEN-END:variables
    
}
